/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.visitors.components;

import it.polimi.ingsw.galaxytrucker.controller.ClientController;
import it.polimi.ingsw.galaxytrucker.enums.Color;
import it.polimi.ingsw.galaxytrucker.model.essentials.Component;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.BatterySlot;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Cannon;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.CentralHousingUnit;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.DoubleCannon;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.DoubleEngine;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Engine;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.GenericCargoHolds;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.LifeSupportSystem;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.ModularHousingUnit;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Shield;
import it.polimi.ingsw.galaxytrucker.view.Gui.FlightController;
import it.polimi.ingsw.galaxytrucker.view.Gui.zUtils;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentVisitorInterface;
import java.util.ArrayList;
import javafx.beans.binding.Bindings;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class ComponentGuiDetailsRotationVisitor
implements ComponentVisitorInterface<StackPane> {
    private StackPane stackPane;
    private ImageView imageView;
    private int rotation;
    private FlightController flightController;
    private ClientController clientController;
    private Boolean editable = false;

    public ComponentGuiDetailsRotationVisitor(ClientController clientController, FlightController flightController, StackPane stackPane, ImageView imageView, int rotation, Boolean editable) {
        this.stackPane = stackPane;
        this.imageView = imageView;
        this.rotation = rotation;
        this.flightController = flightController;
        this.clientController = clientController;
        this.editable = editable;
    }

    @Override
    public StackPane visit(Component component) {
        return null;
    }

    @Override
    public StackPane visit(BatterySlot component) {
        String imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/batteryCharge.png";
        Image segnalino = new Image(zUtils.class.getResource(imagePath).toExternalForm());
        VBox vbox = new VBox();
        vbox.setSpacing(5.0);
        vbox.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add(vbox);
        VBox.setVgrow(vbox, Priority.ALWAYS);
        for (int i = 1; i < component.getBatteriesLeft() + 1; ++i) {
            ImageView viewSegnalino = new ImageView(segnalino);
            viewSegnalino.fitWidthProperty().bind(this.stackPane.widthProperty().divide(3));
            viewSegnalino.fitHeightProperty().bind(this.stackPane.heightProperty().divide(5));
            vbox.getChildren().add(viewSegnalino);
        }
        vbox.setRotate(-this.rotation);
        return null;
    }

    @Override
    public StackPane visit(Cannon component) {
        return null;
    }

    @Override
    public StackPane visit(CentralHousingUnit component) {
        String imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/AstronautaPedina.png";
        Image segnalino = new Image(zUtils.class.getResource(imagePath).toExternalForm());
        HBox hBox = new HBox();
        hBox.setSpacing(5.0);
        hBox.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add(hBox);
        HBox.setHgrow(hBox, Priority.ALWAYS);
        for (int i = 1; i < component.getNCrewMembers() + 1; ++i) {
            ImageView viewSegnalino = new ImageView(segnalino);
            viewSegnalino.fitWidthProperty().bind(this.imageView.fitWidthProperty().divide(3));
            viewSegnalino.fitHeightProperty().bind(this.imageView.fitHeightProperty().divide(4));
            hBox.getChildren().add(viewSegnalino);
        }
        hBox.setRotate(-this.rotation);
        return null;
    }

    @Override
    public StackPane visit(DoubleCannon component) {
        if (component.isCharged().booleanValue()) {
            String imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/tiles/activeOverlay.png";
            ImageView imgCharged = new ImageView(new Image(zUtils.class.getResource(imagePath).toExternalForm()));
            imgCharged.setPreserveRatio(true);
            imgCharged.setSmooth(true);
            imgCharged.fitWidthProperty().bind(this.imageView.fitWidthProperty());
            imgCharged.fitHeightProperty().bind(this.imageView.fitHeightProperty());
            this.stackPane.getChildren().add(imgCharged);
        }
        return null;
    }

    @Override
    public StackPane visit(DoubleEngine component) {
        if (component.isCharged().booleanValue()) {
            String imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/tiles/activeOverlay.png";
            ImageView imgCharged = new ImageView(new Image(zUtils.class.getResource(imagePath).toExternalForm()));
            imgCharged.setPreserveRatio(true);
            imgCharged.setSmooth(true);
            imgCharged.fitWidthProperty().bind(this.imageView.fitWidthProperty());
            imgCharged.fitHeightProperty().bind(this.imageView.fitHeightProperty());
            this.stackPane.getChildren().add(imgCharged);
        }
        return null;
    }

    @Override
    public StackPane visit(Engine component) {
        return null;
    }

    @Override
    public StackPane visit(GenericCargoHolds component) {
        int i;
        Group group = new Group();
        ArrayList<ImageView> slots = new ArrayList<ImageView>();
        String imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/vuoto.png";
        Image segnalino = new Image(zUtils.class.getResource(imagePath).toExternalForm());
        double relativeWidth = 0.35;
        switch (component.getnMaxContainers()) {
            case 1: {
                double normalizedX = 0.3235294117647059;
                double normalizedY = 0.1437908496732026;
                ImageView uno = new ImageView(segnalino);
                slots.add(uno);
                uno.setPreserveRatio(true);
                group.getChildren().add(uno);
                uno.layoutXProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getWidth() * normalizedX, this.imageView.boundsInParentProperty()));
                uno.layoutYProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getHeight() * normalizedY, this.imageView.boundsInParentProperty()));
                uno.fitWidthProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getWidth() * relativeWidth, this.imageView.boundsInParentProperty()));
                break;
            }
            case 2: {
                double normalizedX = 0.3235294117647059;
                double normalizedY = 0.1437908496732026;
                ImageView uno = new ImageView(segnalino);
                slots.add(uno);
                uno.setPreserveRatio(true);
                group.getChildren().add(uno);
                uno.layoutXProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getWidth() * normalizedX, this.imageView.boundsInParentProperty()));
                uno.layoutYProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getHeight() * normalizedY, this.imageView.boundsInParentProperty()));
                uno.fitWidthProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getWidth() * relativeWidth, this.imageView.boundsInParentProperty()));
                double normalizedY2 = 0.5;
                ImageView due = new ImageView(segnalino);
                slots.add(due);
                due.setPreserveRatio(true);
                group.getChildren().add(due);
                due.layoutXProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getWidth() * normalizedX, this.imageView.boundsInParentProperty()));
                due.layoutYProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getHeight() * normalizedY2, this.imageView.boundsInParentProperty()));
                due.fitWidthProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getWidth() * relativeWidth, this.imageView.boundsInParentProperty()));
                break;
            }
            case 3: {
                double normalizedX = 0.16339869281045752;
                double normalizedY = 0.3235294117647059;
                ImageView uno = new ImageView(segnalino);
                slots.add(uno);
                uno.setPreserveRatio(true);
                group.getChildren().add(uno);
                uno.layoutXProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getWidth() * normalizedX, this.imageView.boundsInParentProperty()));
                uno.layoutYProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getHeight() * normalizedY, this.imageView.boundsInParentProperty()));
                uno.fitWidthProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getWidth() * relativeWidth, this.imageView.boundsInParentProperty()));
                double normalizedX2 = 0.5130718954248367;
                double normalizedY2 = 0.1372549019607843;
                ImageView due = new ImageView(segnalino);
                slots.add(due);
                due.setPreserveRatio(true);
                group.getChildren().add(due);
                due.layoutXProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getWidth() * normalizedX2, this.imageView.boundsInParentProperty()));
                due.layoutYProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getHeight() * normalizedY2, this.imageView.boundsInParentProperty()));
                due.fitWidthProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getWidth() * relativeWidth, this.imageView.boundsInParentProperty()));
                double normalizedY3 = 0.5130718954248367;
                ImageView tre = new ImageView(segnalino);
                slots.add(tre);
                tre.setPreserveRatio(true);
                group.getChildren().add(tre);
                tre.layoutXProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getWidth() * normalizedX2, this.imageView.boundsInParentProperty()));
                tre.layoutYProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getHeight() * normalizedY3, this.imageView.boundsInParentProperty()));
                tre.fitWidthProperty().bind(Bindings.createDoubleBinding(() -> this.imageView.getBoundsInParent().getWidth() * relativeWidth, this.imageView.boundsInParentProperty()));
            }
        }
        String pathMerce = null;
        if (this.flightController != null && this.flightController.getIsManagingGoodTime().booleanValue() && this.editable.booleanValue()) {
            for (int k = 0; k < slots.size(); ++k) {
                int finalK = k;
                ((ImageView)slots.get(k)).setOnMouseClicked(event -> {
                    if (event.getButton() == MouseButton.PRIMARY) {
                        if (this.flightController.getCurrentInHandGood() != null) {
                            if ((this.flightController.getCurrentInHandGood().getColor() != Color.RED || this.flightController.getCurrentInHandGood().getColor() == Color.RED && component.isSpecial().booleanValue()) && !component.isFull()) {
                                component.playerLoadGood(this.flightController.getCurrentInHandGood());
                                this.flightController.setCurrentInHandGood(null);
                                this.flightController.hideHand();
                                this.flightController.showShip(this.clientController.getMyModel().getMyInfo().getShip(), this.clientController.getMyModel().getMyInfo().getNickName());
                            }
                        } else if (this.flightController.getCurrentInHandGood() == null && component.getGoods().size() > finalK && component.getGoods().get(finalK) != null) {
                            this.flightController.setCurrentInHandGood(component.getGoods().get(finalK));
                            this.flightController.showPickedGood();
                            component.removeGood(component.getGoods().get(finalK));
                            this.flightController.showShip(this.clientController.getMyModel().getMyInfo().getShip(), this.clientController.getMyModel().getMyInfo().getNickName());
                        }
                    }
                });
            }
        }
        for (i = 0; i < component.getnMaxContainers(); ++i) {
            System.out.println("Dimensione goods in cargoHold: " + component.getGoods().size());
            if (i >= component.getGoods().size()) continue;
            System.out.println("Sto assegnando una merce");
            switch (component.getGoods().get(i).getColor()) {
                case YELLOW: {
                    pathMerce = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/merceGialla.png";
                    break;
                }
                case RED: {
                    pathMerce = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/merceRossa.png";
                    break;
                }
                case GREEN: {
                    pathMerce = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/merceVerde.png";
                    break;
                }
                case BLUE: {
                    pathMerce = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/merceBlu.png";
                }
            }
            Image merce = new Image(zUtils.class.getResource(pathMerce).toExternalForm());
            ((ImageView)slots.get(i)).setImage(merce);
        }
        this.stackPane.getChildren().add(group);
        for (i = 0; i < slots.size(); ++i) {
            ((ImageView)slots.get(i)).setRotate(-this.rotation);
        }
        return null;
    }

    @Override
    public StackPane visit(LifeSupportSystem component) {
        return null;
    }

    @Override
    public StackPane visit(ModularHousingUnit component) {
        Image segnalino = null;
        switch (component.getAlienColor()) {
            case BROWN: {
                String imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/AlienoMarronePedina.png";
                segnalino = new Image(zUtils.class.getResource(imagePath).toExternalForm());
                break;
            }
            case PURPLE: {
                String imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/AlienoViolaPedina.png";
                segnalino = new Image(zUtils.class.getResource(imagePath).toExternalForm());
                break;
            }
            case EMPTY: {
                String imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/AstronautaPedina.png";
                segnalino = new Image(zUtils.class.getResource(imagePath).toExternalForm());
            }
        }
        HBox hBox = new HBox();
        hBox.setSpacing(5.0);
        hBox.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add(hBox);
        HBox.setHgrow(hBox, Priority.ALWAYS);
        for (int i = 1; i < component.getNCrewMembers() + 1; ++i) {
            ImageView viewSegnalino = new ImageView(segnalino);
            viewSegnalino.setPreserveRatio(true);
            viewSegnalino.setSmooth(true);
            viewSegnalino.setCache(true);
            viewSegnalino.fitWidthProperty().bind(this.stackPane.widthProperty().divide(3));
            viewSegnalino.fitHeightProperty().bind(this.stackPane.heightProperty().divide(4));
            hBox.getChildren().add(viewSegnalino);
        }
        hBox.setRotate(-this.rotation);
        return null;
    }

    @Override
    public StackPane visit(Shield component) {
        if (component.isCharged().booleanValue()) {
            String imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/tiles/activeOverlay.png";
            ImageView imgCharged = new ImageView(new Image(zUtils.class.getResource(imagePath).toExternalForm()));
            imgCharged.setPreserveRatio(true);
            imgCharged.setSmooth(true);
            imgCharged.fitWidthProperty().bind(this.imageView.fitWidthProperty());
            imgCharged.fitHeightProperty().bind(this.imageView.fitHeightProperty());
            this.stackPane.getChildren().add(imgCharged);
        }
        return null;
    }
}

