/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Tui.util;

import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentPrintVisitor;
import java.util.ArrayList;

public class TilePrintUtils {
    private static ComponentPrintVisitor componentPrintVisitor = new ComponentPrintVisitor();

    public static String[][] composeRow(ArrayList<Tile> tileList, int row, int columns, int lastRow) {
        String[][] tileRow = new String[columns][5];
        int Offset2 = row * columns;
        if (lastRow != 0) {
            columns = lastRow;
        }
        for (int i = 0; i < columns; ++i) {
            tileRow[i] = TilePrintUtils.getTileStrings(tileList.get(i + Offset2), true);
        }
        return tileRow;
    }

    public static void printTileList(ArrayList<Tile> tileList, int columns) {
        int rowsEachTile = 6;
        int rows = tileList.size() / columns;
        int lastRow = tileList.size() % columns;
        if (lastRow != 0) {
            ++rows;
        }
        for (int r = 0; r < rows; ++r) {
            String[][] TilesStringRow;
            if (r == rows - 1 && lastRow != 0) {
                TilesStringRow = TilePrintUtils.composeRow(tileList, r, columns, lastRow);
                columns = lastRow;
            } else {
                TilesStringRow = TilePrintUtils.composeRow(tileList, r, columns, 0);
            }
            for (int i = 0; i < rowsEachTile; ++i) {
                for (int c = 0; c < columns; ++c) {
                    System.out.print(TilesStringRow[c][i]);
                }
                System.out.println();
            }
        }
    }

    public static void printTile(Tile tile) {
        String[] tileString = TilePrintUtils.getTileStrings(tile, true);
        for (int i = 0; i < tileString.length; ++i) {
            System.out.println(tileString[i]);
        }
    }

    public static String[] getTileStrings(Tile tile, boolean printId) {
        if (tile == null) {
            return new String[]{".         . ", "            ", "            ", "            ", ".         . "};
        }
        String[] componentRows = tile.getMyComponent().accept(componentPrintVisitor);
        if (printId) {
            StringBuilder sb = new StringBuilder();
            String[] result = new String[]{"", "\u250c----" + tile.getSides().get(0).ordinal() + "----\u2510 ", "|" + componentRows[0] + "| ", tile.getSides().get(3).ordinal() + componentRows[1] + tile.getSides().get(1).ordinal() + " ", "|" + componentRows[2] + "| ", "\u2514----" + tile.getSides().get(2).ordinal() + "----\u2518 "};
            sb.append("ID: " + tile.getId());
            if (tile.getId() > 99) {
                sb.append("     ");
            } else if (tile.getId() > 9) {
                sb.append("      ");
            } else {
                sb.append("       ");
            }
            result[0] = sb.toString();
            return result;
        }
        return new String[]{"\u250c----" + tile.getSides().get(0).ordinal() + "----\u2510 ", "|" + componentRows[0] + "| ", tile.getSides().get(3).ordinal() + componentRows[1] + tile.getSides().get(1).ordinal() + " ", "|" + componentRows[2] + "| ", "\u2514----" + tile.getSides().get(2).ordinal() + "----\u2518 "};
    }
}

