/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Tui.util;

import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.model.essentials.Position;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.TilePrintUtils;

public class ShipPrintUtils {
    public static String[][] composeRow(Ship ship, int row) {
        String[][] shipRow = new String[7][5];
        for (int i = 0; i < 7; ++i) {
            String[] result = ship.getInvalidPositions().contains(new Position(i, row)) ? new String[]{"            ", "            ", "            ", "            ", "            "} : TilePrintUtils.getTileStrings(ship.getShipBoard()[i][row].getTile(), false);
            shipRow[i] = result;
        }
        return shipRow;
    }

    public static void printShip(Ship ship) {
        int rows = 5;
        int cols = 7;
        int rowsEachTile = 5;
        int r = 0;
        int c = 0;
        System.out.println("  |    4    | |    5    | |    6    | |    7    | |    8    | |    9    | |    10   | ");
        for (r = 0; r < rows; ++r) {
            String[][] TilesStringRow = ShipPrintUtils.composeRow(ship, r);
            for (int i = 0; i < rowsEachTile; ++i) {
                if (i == 0) {
                    System.out.print("_ ");
                }
                if (i == 1) {
                    System.out.print("  ");
                }
                if (i == 2) {
                    System.out.print(r + 5 + " ");
                }
                if (i == 3) {
                    System.out.print("  ");
                }
                if (i == 4) {
                    System.out.print("_ ");
                }
                for (c = 0; c < cols; ++c) {
                    System.out.print(TilesStringRow[c][i]);
                }
                System.out.println();
            }
        }
    }
}

