/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Tui.util;

import it.polimi.ingsw.galaxytrucker.enums.Color;
import it.polimi.ingsw.galaxytrucker.model.Planet;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.AdventureCard;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.CardDeck;
import it.polimi.ingsw.galaxytrucker.model.essentials.Good;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.TuiColor;
import it.polimi.ingsw.galaxytrucker.visitors.adventurecards.AdventureCardPrintVisitor;
import it.polimi.ingsw.galaxytrucker.visitors.adventurecards.AdventureCardVisitorsInterface;
import java.util.ArrayList;
import java.util.HashMap;

public class CardPrintUtils {
    private static final AdventureCardVisitorsInterface<String[]> adventureCardPrintVisitor = new AdventureCardPrintVisitor();

    public static void printPlanetList(HashMap<Integer, Planet> planets) {
        for (Integer i : planets.keySet()) {
            StringBuilder sb = new StringBuilder();
            if (planets.get(i).isOccupied()) {
                sb.append("Occ");
            } else {
                sb.append("   ");
            }
            sb.append(" P").append(i).append(": ");
            int j = 0;
            block8: for (j = 0; j < planets.get(i).getGoods().size(); ++j) {
                switch (planets.get(i).getGoods().get(j).getColor()) {
                    case RED: {
                        sb.append((Object)TuiColor.RED).append("\u2588").append((Object)TuiColor.RESET);
                        continue block8;
                    }
                    case BLUE: {
                        sb.append((Object)TuiColor.BLUE).append("\u2588").append((Object)TuiColor.RESET);
                        continue block8;
                    }
                    case GREEN: {
                        sb.append((Object)TuiColor.GREEN).append("\u2588").append((Object)TuiColor.RESET);
                        continue block8;
                    }
                    case YELLOW: {
                        sb.append((Object)TuiColor.BRIGHT_YELLOW).append("\u2588").append((Object)TuiColor.RESET);
                        continue block8;
                    }
                    case EMPTY: {
                        sb.append(" ");
                    }
                }
            }
            System.out.println(sb.toString());
        }
    }

    public static String[][] composeRow(ArrayList<AdventureCard> CardList, int row, int columns, int lastRow) {
        String[][] tileRow = new String[columns][5];
        int Offset2 = row * columns;
        if (lastRow != 0) {
            columns = lastRow;
        }
        for (int i = 0; i < columns; ++i) {
            tileRow[i] = CardPrintUtils.getCardStrings(CardList.get(i + Offset2));
        }
        return tileRow;
    }

    public static void printDeck(CardDeck deck, int columns) {
        int rows = deck.getCards().size() / columns;
        int rowsEachCard = 9;
        int lastRow = deck.getCards().size() % columns;
        if (lastRow != 0) {
            ++rows;
        }
        for (int r = 0; r < rows; ++r) {
            String[][] TilesStringRow;
            if (r == rows - 1 && lastRow != 0) {
                TilesStringRow = CardPrintUtils.composeRow(deck.getCards(), r, columns, lastRow);
                columns = lastRow;
            } else {
                TilesStringRow = CardPrintUtils.composeRow(deck.getCards(), r, columns, 0);
            }
            for (int i = 0; i < rowsEachCard; ++i) {
                for (int c = 0; c < columns; ++c) {
                    System.out.print(TilesStringRow[c][i]);
                }
                System.out.println();
            }
        }
    }

    public static void printCard(AdventureCard card) {
        String[] tileString = CardPrintUtils.getCardStrings(card);
        for (int i = 0; i < tileString.length; ++i) {
            System.out.println(tileString[i]);
        }
    }

    public static String colorBlock(Good good) {
        return switch (good.getColor()) {
            case Color.RED -> String.valueOf((Object)TuiColor.RED) + " \u2588 " + String.valueOf((Object)TuiColor.RESET);
            case Color.BLUE -> String.valueOf((Object)TuiColor.BLUE) + " \u2588 " + String.valueOf((Object)TuiColor.RESET);
            case Color.GREEN -> String.valueOf((Object)TuiColor.GREEN) + " \u2588 " + String.valueOf((Object)TuiColor.RESET);
            case Color.YELLOW -> String.valueOf((Object)TuiColor.BRIGHT_YELLOW) + " \u2588 " + String.valueOf((Object)TuiColor.RESET);
            default -> " ";
        };
    }

    public static String[] getCardStrings(AdventureCard card) {
        return card.accept(adventureCardPrintVisitor);
    }
}

