/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Gui;

import it.polimi.ingsw.galaxytrucker.controller.ClientController;
import it.polimi.ingsw.galaxytrucker.network.client.ClientModel;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.SERVER_INFO;
import it.polimi.ingsw.galaxytrucker.view.Gui.Abstract.GenericSceneController;
import it.polimi.ingsw.galaxytrucker.view.Gui.GuiJavaFx;
import it.polimi.ingsw.galaxytrucker.view.Gui.MusicManager;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class LoginConnectController
extends GenericSceneController {
    @FXML
    private Label TxtError;
    @FXML
    private TextField TxfServerAddr;
    @FXML
    private TextField TxfPort;
    @FXML
    private TextField TxfNickname;
    @FXML
    private RadioButton socketRadio;
    @FXML
    private RadioButton RMIradio;
    private GuiJavaFx mainViewController;
    private Stage primaryStage;
    private MusicManager musicManager;

    public void initialSetupSmall(GuiJavaFx mainViewController, Stage primaryStage, MusicManager musicManager) {
        this.mainViewController = mainViewController;
        this.primaryStage = primaryStage;
        this.musicManager = musicManager;
    }

    public void updateHint() {
        this.TxfPort.setPromptText(this.socketRadio.isSelected() ? "Default Socket: 5000" : "Default RMI: 1099");
    }

    @Override
    public void initialSetup(GuiJavaFx mainViewController, ClientController clientController, ClientModel mymodel, Stage primaryStage, MusicManager musicManager) {
    }

    @Override
    public void ShowGenericMessage(String message) {
        this.TxtError.setText(message);
    }

    @Override
    public String pageName() {
        return "LoginConnectPage";
    }

    public void ConnectToServer(ActionEvent e) {
        int port;
        GuiJavaFx.playWavSoundEffect("ButtonClick.wav");
        String address = this.TxfServerAddr.getText().trim();
        ClientController controller = new ClientController(null, this.socketRadio.isSelected());
        controller.setView(this.mainViewController);
        this.mainViewController.initializeController(controller);
        if (address.isEmpty()) {
            address = "127.0.0.1";
        }
        if (this.TxfPort.getText().isEmpty()) {
            port = controller.getIsSocket() ? 5000 : 1099;
        } else {
            try {
                port = Integer.parseInt(this.TxfPort.getText().trim());
            }
            catch (NumberFormatException ex) {
                this.TxtError.setText("Invalid port number.");
                return;
            }
        }
        try {
            controller.handleServerInfo(new SERVER_INFO(address, port));
        }
        catch (Exception ex) {
            this.TxfPort.setText(ex.toString());
            return;
        }
        controller.handleNicknameInput(this.TxfNickname.getText().trim());
    }
}

