/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Gui;

import it.polimi.ingsw.galaxytrucker.controller.ClientController;
import it.polimi.ingsw.galaxytrucker.network.client.ClientModel;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyInfo;
import it.polimi.ingsw.galaxytrucker.view.Gui.Abstract.GenericSceneController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Elements.SingleLobbyInfoController;
import it.polimi.ingsw.galaxytrucker.view.Gui.GuiJavaFx;
import it.polimi.ingsw.galaxytrucker.view.Gui.MusicManager;
import java.io.IOException;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class ListLobbyController
extends GenericSceneController {
    @FXML
    private Label TxtErr;
    @FXML
    private VBox PnlLobbies;
    private GuiJavaFx mainViewController;
    private ClientController clientController;
    private ClientModel mymodel;
    private Stage primaryStage;
    private MusicManager musicManager;

    @Override
    public void initialSetup(GuiJavaFx mainViewController, ClientController clientController, ClientModel mymodel, Stage primaryStage, MusicManager musicManager) {
        this.mainViewController = mainViewController;
        this.clientController = clientController;
        this.mymodel = mymodel;
        this.primaryStage = primaryStage;
        this.musicManager = musicManager;
    }

    @Override
    public void ShowGenericMessage(String message) {
        this.TxtErr.setText(message);
    }

    @Override
    public String pageName() {
        return "LobbyListPage";
    }

    public void backToMainMenu(ActionEvent e) {
        GuiJavaFx.playWavSoundEffect("ButtonClick.wav");
        this.mainViewController.askJoinOrCreateRoom();
    }

    public void UpdateLobbyList(List<LobbyInfo> lobbies) {
        for (LobbyInfo info : lobbies) {
            try {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/SingleLobbyInfo.fxml"));
                Parent lobbyNode = (Parent)loader.load();
                SingleLobbyInfoController controller = (SingleLobbyInfoController)loader.getController();
                controller.setData(info.getLobbyID(), info.getHost(), info.getConnectedPlayers(), info.getMaxPlayers(), info.isLearningMatch());
                controller.getJoinButton().setOnAction(e -> {
                    this.clientController.handleJoinChoice(info.getLobbyID());
                    GuiJavaFx.playWavSoundEffect("ButtonClick.wav");
                });
                this.PnlLobbies.getChildren().add(lobbyNode);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }
}

