/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Gui;

import it.polimi.ingsw.galaxytrucker.controller.ClientController;
import it.polimi.ingsw.galaxytrucker.enums.ActivatableComponent;
import it.polimi.ingsw.galaxytrucker.enums.AlienColor;
import it.polimi.ingsw.galaxytrucker.enums.GameState;
import it.polimi.ingsw.galaxytrucker.enums.PLAYER_PHASE;
import it.polimi.ingsw.galaxytrucker.enums.ViewType;
import it.polimi.ingsw.galaxytrucker.model.FlightBoard;
import it.polimi.ingsw.galaxytrucker.model.Planet;
import it.polimi.ingsw.galaxytrucker.model.PlayerInfo;
import it.polimi.ingsw.galaxytrucker.model.PlayerScore;
import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.model.essentials.Good;
import it.polimi.ingsw.galaxytrucker.model.essentials.Position;
import it.polimi.ingsw.galaxytrucker.model.essentials.Slot;
import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.ModularHousingUnit;
import it.polimi.ingsw.galaxytrucker.model.game.TimerInfo;
import it.polimi.ingsw.galaxytrucker.model.utils.Util;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyInfo;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.AskPositionResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.CrewInitUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.PhaseUpdate;
import it.polimi.ingsw.galaxytrucker.view.Gui.Abstract.GenericGamePhaseSceneController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Abstract.GenericSceneController;
import it.polimi.ingsw.galaxytrucker.view.Gui.BuildingController;
import it.polimi.ingsw.galaxytrucker.view.Gui.CreateLobbyController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Dialogs.ConfirmDialogController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Dialogs.InfoDialogController;
import it.polimi.ingsw.galaxytrucker.view.Gui.FlightController;
import it.polimi.ingsw.galaxytrucker.view.Gui.ListLobbyController;
import it.polimi.ingsw.galaxytrucker.view.Gui.LobbyController;
import it.polimi.ingsw.galaxytrucker.view.Gui.LoginConnectController;
import it.polimi.ingsw.galaxytrucker.view.Gui.MainMenuController;
import it.polimi.ingsw.galaxytrucker.view.Gui.MusicManager;
import it.polimi.ingsw.galaxytrucker.view.Gui.ScoresController;
import it.polimi.ingsw.galaxytrucker.view.View;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentNameVisitor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Pair;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;

public class GuiJavaFx
implements View {
    private final Stage primaryStage;
    private Scene primaryScene;
    private ClientController controller;
    private GenericSceneController actualPageController;
    private MusicManager musicManager;
    private Boolean firstTimeMainMenu = true;
    private static final Boolean testing = true;
    private CrewInitUpdate crewInitUpdate;

    public GuiJavaFx(Stage primaryStage, Scene primaryScene) {
        this.primaryStage = primaryStage;
        this.primaryScene = primaryScene;
        this.musicManager = new MusicManager();
        primaryStage.setOnCloseRequest(event -> {
            GuiJavaFx.playWavSoundEffect("nenenee.wav");
            if (this.ShowCustomConfirmDialog("Vuoi davvero andartene?").booleanValue()) {
                this.CloseApplication();
            } else {
                event.consume();
            }
        });
    }

    public void initializeController(ClientController controller) {
        this.controller = controller;
        this.primaryScene.setOnKeyPressed(event -> {
            if (controller.getCurrentTileInHand() != null) {
                if (event.getCode() == KeyCode.Q || event.getCode() == KeyCode.LEFT) {
                    controller.rotateCurrentTile(-90);
                } else if (event.getCode() == KeyCode.E || event.getCode() == KeyCode.RIGHT) {
                    controller.rotateCurrentTile(90);
                }
            }
        });
        this.primaryScene.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.SECONDARY) {
                controller.rotateCurrentTile(90);
            }
        });
    }

    @Override
    public Boolean autoShowUpdates() {
        return true;
    }

    @Override
    public ViewType getViewType() {
        return ViewType.GUI;
    }

    public static void playWavSoundEffect(String sound) {
        try {
            InputStream raw = MainMenuController.class.getResourceAsStream("/it/polimi/ingsw/galaxytrucker/Sounds/SoundEffects/" + sound);
            if (raw == null) {
                throw new IllegalArgumentException("File audio non trovato!");
            }
            BufferedInputStream bufferedIn = new BufferedInputStream(raw);
            AudioInputStream audioStream = AudioSystem.getAudioInputStream(bufferedIn);
            Clip clip = AudioSystem.getClip();
            clip.open(audioStream);
            clip.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Boolean ShowCustomConfirmDialog(String message) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Dialogs/ConfirmDialog.fxml"));
            Parent page = (Parent)loader.load();
            Stage dialogStage = new Stage();
            dialogStage.setTitle("Conferma");
            dialogStage.initModality(Modality.APPLICATION_MODAL);
            dialogStage.initStyle(StageStyle.UTILITY);
            dialogStage.setResizable(false);
            dialogStage.setScene(new Scene(page));
            ConfirmDialogController controller = (ConfirmDialogController)loader.getController();
            controller.setDialogStage(dialogStage);
            controller.setMessage(message);
            dialogStage.showAndWait();
            return controller.isConfirmed();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void CloseApplication() {
        this.musicManager.stopBackgroundMusic();
        this.primaryStage.close();
        Platform.exit();
        System.exit(0);
    }

    @Override
    public void askServerInfo() {
        if (this.actualPageController == null || this.actualPageController.pageName() != "LoginConnectPage") {
            Platform.runLater(() -> {
                System.out.println("DEBUG: askServerInfo");
                try {
                    FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/LoginConnect.fxml"));
                    Parent root = (Parent)loader.load();
                    LoginConnectController pageController = (LoginConnectController)loader.getController();
                    pageController.initialSetupSmall(this, this.primaryStage, this.musicManager);
                    this.actualPageController = pageController;
                    this.primaryScene.setRoot(root);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    @Override
    public void askNickname() {
        System.out.println("DEBUG: askNickname");
    }

    @Override
    public void forceReset() {
    }

    @Override
    public void askJoinOrCreateRoom() {
        System.out.println("DEBUG: askJoinOrCreateRoom");
        Platform.runLater(() -> {
            try {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/MainMenu.fxml"));
                Parent root = (Parent)loader.load();
                MainMenuController pageController = (MainMenuController)loader.getController();
                pageController.initialSetup(this, this.controller, this.controller.getMyModel(), this.primaryStage, this.musicManager);
                this.actualPageController = pageController;
                this.primaryScene.setRoot(root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.firstTimeMainMenu.booleanValue()) {
                this.firstTimeMainMenu = false;
                if (!testing.booleanValue()) {
                    this.primaryStage.setFullScreen(true);
                }
            }
            if (!testing.booleanValue()) {
                this.musicManager.playBackgroundMusic("CRMIntroMenu.wav", true);
            }
        });
    }

    @Override
    public void askCreateRoom() {
        System.out.println("DEBUG: askJoinOrCreateRoom");
        Platform.runLater(() -> {
            try {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/CreateLobby.fxml"));
                Parent root = (Parent)loader.load();
                CreateLobbyController pageController = (CreateLobbyController)loader.getController();
                pageController.initialSetup(this, this.controller, this.controller.getMyModel(), this.primaryStage, this.musicManager);
                this.actualPageController = pageController;
                this.primaryScene.setRoot(root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void askRoomCode() {
    }

    @Override
    public void showLobbies(List<LobbyInfo> lobbies) {
        System.out.println("DEBUG: showLobbies");
        Platform.runLater(() -> {
            try {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/ListLobby.fxml"));
                Parent root = (Parent)loader.load();
                ListLobbyController pageController = (ListLobbyController)loader.getController();
                pageController.initialSetup(this, this.controller, this.controller.getMyModel(), this.primaryStage, this.musicManager);
                pageController.UpdateLobbyList(lobbies);
                this.actualPageController = pageController;
                this.primaryScene.setRoot(root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void toShowCurrentMenu() {
    }

    @Override
    public void showPlayerJoined(PlayerInfo playerInfo) {
        System.out.println("DEBUG: showPlayerJoined");
        ArrayList<PlayerInfo> app = new ArrayList<PlayerInfo>();
        app.add(playerInfo);
        Platform.runLater(() -> {
            try {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Lobby.fxml"));
                Parent root = (Parent)loader.load();
                LobbyController pageController = (LobbyController)loader.getController();
                pageController.initialSetup(this, this.controller, this.controller.getMyModel(), this.primaryStage, this.musicManager);
                pageController.updatePlayersList(app);
                this.actualPageController = pageController;
                this.primaryScene.setRoot(root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        this.showGenericMessage("Player joined: " + playerInfo.getNickName(), false);
    }

    @Override
    public void showPlayersLobby(PlayerInfo myInfo, ArrayList<PlayerInfo> playerInfo) {
        System.out.println("DEBUG: showPlayersLobby");
        Platform.runLater(() -> {
            try {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Lobby.fxml"));
                Parent root = (Parent)loader.load();
                LobbyController pageController = (LobbyController)loader.getController();
                pageController.initialSetup(this, this.controller, this.controller.getMyModel(), this.primaryStage, this.musicManager);
                if (playerInfo.size() == 0) {
                    playerInfo.add(myInfo);
                }
                pageController.updatePlayersList(playerInfo);
                this.actualPageController = pageController;
                this.primaryScene.setRoot(root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void handleChoiceForPhase(GameState phase) {
    }

    @Override
    public void handlePhaseUpdate(PhaseUpdate update) {
        System.out.println("DEBUG: handlePhaseUpdate " + update.getState().name());
        GameState gameState = update.getState();
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"BUILDING_START", "BUILDING_TIMER", "CREW_INIT", "BUILDING_END", "SHIP_CHECK", "FLIGHT"}, (GameState)gameState, n)) {
            case 0: {
                this.showBuildingMenu();
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.chooseCrew(this.controller.getMyModel().getMyInfo().getShip());
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            case 3: 
            case 4: {
                ((BuildingController)this.actualPageController).updateBuildingPageInterface(update.getState());
                break;
            }
            case 5: {
                this.showFlightMenu();
                break;
            }
            default: {
                this.showGenericMessage("Phase changed: " + update.getState().name(), false);
            }
        }
    }

    @Override
    public void showBuildingMenu() {
        Platform.runLater(() -> {
            System.out.println("DEBUG: showBuildingMenu");
            if (!this.actualPageController.pageName().equals("BuildingPage")) {
                System.out.println("Debug: rifaccio il building menu");
                try {
                    FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Building.fxml"));
                    Parent root = (Parent)loader.load();
                    BuildingController pageController = (BuildingController)loader.getController();
                    pageController.initialSetup(this, this.controller, this.controller.getMyModel(), this.primaryStage, this.musicManager);
                    this.actualPageController = pageController;
                    for (PlayerInfo playerInfo : this.controller.getMyModel().getPlayerInfos()) {
                        this.showShip(playerInfo.getShip(), playerInfo.getNickName());
                    }
                    this.primaryScene.setRoot(root);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void handleFaceUpTilesUpdate() {
        this.showFaceUpTiles();
    }

    @Override
    public void showFaceUpTiles() {
        System.out.println("DEBUG: showFaceUpTiles");
        Platform.runLater(() -> ((BuildingController)this.actualPageController).updateFaceUpTiles());
    }

    @Override
    public void showFinishedBuildingMenu() {
        this.showBuildingMenu();
    }

    @Override
    public void askShowFaceUpTiles() {
    }

    @Override
    public void askFetchShip() {
    }

    @Override
    public void askRotation() {
    }

    @Override
    public void askPosition() {
    }

    @Override
    public void askViewAdventureDecks() {
    }

    @Override
    public void showTile(Tile tile) {
        if (tile != null) {
            System.out.println("DEBUG: showTile");
            Platform.runLater(() -> {
                ((BuildingController)this.actualPageController).showDrawnTile(tile);
                this.showGenericMessage("Tile: " + tile.getId() + ", Type: " + tile.getMyComponent().getClass().getSimpleName(), false);
            });
        } else {
            Platform.runLater(() -> ((BuildingController)this.actualPageController).hideZonaPescata());
        }
    }

    @Override
    public void askChooseTile() {
    }

    @Override
    public void askPickOrPlaceReservedTile(boolean isPicking) {
    }

    @Override
    public void askDrawTile() {
        this.controller.handleBuildingMenuChoice("d");
    }

    @Override
    public void askTilePlacement() {
        this.controller.handleBuildingMenuChoice("h");
    }

    @Override
    public void showCheckShipMenu() {
    }

    @Override
    public void showEmbarkCrewMenu() {
    }

    @Override
    public void askRemoveTile(Ship ship) {
        System.out.println("Debug: askRemoveTile");
    }

    @Override
    public void chooseComponent(Ship myShip, ActivatableComponent component) throws ExecutionException, InterruptedException {
        System.out.println("Debug: chooseComponent");
        ((FlightController)this.actualPageController).handleChooseComponent(component);
    }

    @Override
    public void chooseDiscardCrew(Ship myShip, int nCrewToDiscard) throws ExecutionException, InterruptedException {
        System.out.println("Debug: chooseDiscardCrew");
        ((FlightController)this.actualPageController).handleDiscradCrew(nCrewToDiscard);
    }

    @Override
    public void chooseTroncone(ArrayList<Ship> tronconi) throws ExecutionException, InterruptedException {
        System.out.println("Debug: chooseTroncone");
        ((GenericGamePhaseSceneController)this.actualPageController).chooseTroncone(tronconi);
    }

    @Override
    public void chooseCrew(Ship myShip) throws ExecutionException, InterruptedException, IOException {
        this.crewInitUpdate = new CrewInitUpdate();
        ComponentNameVisitor namevisitor = new ComponentNameVisitor();
        Slot[][] shipboard = this.controller.getMyModel().getMyInfo().getShip().getShipBoard();
        for (int x = 0; x < shipboard.length; ++x) {
            for (int y = 0; y < shipboard[x].length; ++y) {
                Tile tile = shipboard[x][y].getTile();
                if (tile == null || !Objects.equals(tile.getMyComponent().accept(namevisitor), "ModularHousingUnit")) continue;
                ((GuiJavaFx)this.controller.getView()).editPositionCrew(x, y);
            }
        }
        this.showShip(this.controller.getMyModel().getMyInfo().getShip(), this.controller.getMyModel().getMyInfo().getNickName());
    }

    public void editPositionCrew(int x, int y) {
        ModularHousingUnit currentHousingUnit = (ModularHousingUnit)this.controller.getMyModel().getMyInfo().getShip().getShipBoard()[x][y].getTile().getMyComponent();
        int nBrownAlien = this.controller.getMyModel().getMyInfo().getShip().getNBrownAlien();
        int nPurpleAlien = this.controller.getMyModel().getMyInfo().getShip().getNPurpleAlien();
        System.out.println("CABIN AT " + x + " " + y + " has brown ? ->" + Util.checkNearLFS(new Position(x, y), AlienColor.BROWN, this.controller.getMyModel().getMyInfo().getShip()));
        System.out.println("CABIN AT " + x + " " + y + " has purple ? ->" + Util.checkNearLFS(new Position(x, y), AlienColor.PURPLE, this.controller.getMyModel().getMyInfo().getShip()));
        if (Util.checkNearLFS(new Position(x, y), AlienColor.BROWN, this.controller.getMyModel().getMyInfo().getShip()).booleanValue() && Util.checkNearLFS(new Position(x, y), AlienColor.PURPLE, this.controller.getMyModel().getMyInfo().getShip()).booleanValue()) {
            if (currentHousingUnit.getNPurpleAlien() == 0 && currentHousingUnit.getNBrownAlien() == 0 && nPurpleAlien == 0) {
                currentHousingUnit.removeAllCrew();
                currentHousingUnit.addPurpleAlien();
            } else if (currentHousingUnit.getNPurpleAlien() == 1 && nBrownAlien == 0) {
                currentHousingUnit.removeAllCrew();
                currentHousingUnit.addBrownAlien();
            } else if (nBrownAlien == 0) {
                currentHousingUnit.removeAllCrew();
                currentHousingUnit.addBrownAlien();
            } else {
                currentHousingUnit.removeAllCrew();
                currentHousingUnit.addHumanCrew();
            }
        } else if (Util.checkNearLFS(new Position(x, y), AlienColor.PURPLE, this.controller.getMyModel().getMyInfo().getShip()).booleanValue()) {
            if (currentHousingUnit.getNPurpleAlien() == 0 && nPurpleAlien == 0) {
                currentHousingUnit.removeAllCrew();
                currentHousingUnit.addPurpleAlien();
            } else {
                currentHousingUnit.removeAllCrew();
                currentHousingUnit.addHumanCrew();
            }
        } else if (Util.checkNearLFS(new Position(x, y), AlienColor.BROWN, this.controller.getMyModel().getMyInfo().getShip()).booleanValue()) {
            if (currentHousingUnit.getNBrownAlien() == 0 && nBrownAlien == 0) {
                currentHousingUnit.removeAllCrew();
                currentHousingUnit.addBrownAlien();
            } else {
                currentHousingUnit.removeAllCrew();
                currentHousingUnit.addHumanCrew();
            }
        } else {
            currentHousingUnit.addHumanCrew();
        }
        System.out.println("La cab ha: " + currentHousingUnit.getNBrownAlien() + " marroni " + currentHousingUnit.getNPurpleAlien() + " viola e " + currentHousingUnit.getNCrewMembers() + " membri crew in generale");
        Position position = new Position(x, y);
        this.crewInitUpdate.getCrewPos().removeIf(current -> ((Position)current.getKey()).equals(position));
        this.crewInitUpdate.addCrewPos(new Pair<Position, AlienColor>(position, currentHousingUnit.getAlienColor()));
    }

    public void confirmCrew() {
        this.controller.handleCrewInitUpdate(this.crewInitUpdate);
        System.out.println("CrewInitSent");
    }

    @Override
    public void askDrawCard() {
        System.out.println("Debug: askDrawCard");
        ((FlightController)this.actualPageController).askDrawCard();
    }

    @Override
    public void askActivateAdventureCard() {
        System.out.println("Debug: askActivateAdventureCard");
        ((FlightController)this.actualPageController).handleAskActivateCard();
    }

    @Override
    public void showFlightBoard(FlightBoard flightBoard, ArrayList<PlayerInfo> infoPlayers, PlayerInfo myinfo) {
        System.out.println("Debug: showFlightboard");
        Platform.runLater(() -> ((FlightController)this.actualPageController).updateBoard());
    }

    @Override
    public void showCurrentAdventureCard() {
        System.out.println("Debug: showCurrentAdventureCard");
        Platform.runLater(() -> ((FlightController)this.actualPageController).showCurrentAdventureCard());
    }

    @Override
    public void showFlightMenu() {
        System.out.println("DEBUG: showFlightMenu");
        if (!this.actualPageController.pageName().equals("Flight")) {
            Platform.runLater(() -> {
                try {
                    FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Flight.fxml"));
                    Parent root = (Parent)loader.load();
                    FlightController pageController = (FlightController)loader.getController();
                    pageController.initialSetup(this, this.controller, this.controller.getMyModel(), this.primaryStage, this.musicManager);
                    this.actualPageController = pageController;
                    this.primaryScene.setRoot(root);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        } else {
            ((FlightController)this.actualPageController).showEndTurnMenu();
        }
    }

    @Override
    public void showShip(Ship targetShipView, String Nickname) {
        System.out.println("DEBUG: showShip ");
        Platform.runLater(() -> ((GenericGamePhaseSceneController)this.actualPageController).showShip(targetShipView, Nickname));
    }

    @Override
    public void askFlightBoardPosition(ArrayList<Integer> validPositions, int id) {
        Platform.runLater(() -> {
            ((BuildingController)this.actualPageController).handleFinishBuilding();
            ChoiceDialog<Integer> dialog = new ChoiceDialog<Integer>((Integer)validPositions.get(0), (Collection<Integer>)validPositions);
            dialog.getDialogPane().setStyle("-fx-background-color: Navy;");
            dialog.setTitle("Scegli la posizione");
            dialog.setHeaderText("Scegli la posizione di partenza al decollo");
            dialog.getDialogPane().getButtonTypes().remove(ButtonType.CANCEL);
            dialog.setOnShown(ev -> {
                Stage stage = (Stage)dialog.getDialogPane().getScene().getWindow();
                stage.setOnCloseRequest(closeEvent -> {
                    closeEvent.consume();
                    Integer selected = (Integer)dialog.getSelectedItem();
                    try {
                        this.controller.getClient().sendMessage(new AskPositionResponse(id, selected));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    stage.close();
                });
            });
            dialog.showAndWait().ifPresent(pos -> {
                try {
                    this.controller.getClient().sendMessage(new AskPositionResponse(id, (int)pos));
                }
                catch (Exception e) {
                    this.showGenericMessage("Errore nell'inviare la posizione: " + e.getMessage(), false);
                }
            });
        });
    }

    @Override
    public void askSelectPlanetChoice(HashMap<Integer, Planet> landablePlanets) {
        System.out.println("Debug: askSelectPlanetChoice");
        ((FlightController)this.actualPageController).handlePlanetChoice(landablePlanets);
    }

    @Override
    public void showGenericMessage(String message, Boolean important) {
        Platform.runLater(() -> {
            if (important.booleanValue()) {
                try {
                    FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Dialogs/InfoDialog.fxml"));
                    Parent page = (Parent)loader.load();
                    Stage dialogStage = new Stage();
                    dialogStage.setTitle("Comunicazione");
                    dialogStage.initModality(Modality.APPLICATION_MODAL);
                    dialogStage.initStyle(StageStyle.UTILITY);
                    dialogStage.setResizable(false);
                    dialogStage.setScene(new Scene(page));
                    InfoDialogController controller = (InfoDialogController)loader.getController();
                    controller.setDialogStage(dialogStage);
                    controller.setMessage(null, message);
                    dialogStage.showAndWait();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.actualPageController.ShowGenericMessage(message);
            }
        });
    }

    @Override
    public void showWaitOtherPlayers() {
        Platform.runLater(() -> ((GenericGamePhaseSceneController)this.actualPageController).showWaitOtherPlayers(true));
    }

    @Override
    public void askLoadGoodChoice() {
        System.out.println("Debug: askLoadGoodChoice");
        this.askSelectGoodToLoad(this.controller.getMyModel().getUnplacedGoods(), this.controller.getMyModel().getMyInfo().getShip());
    }

    @Override
    public void askSelectGoodToLoad(ArrayList<Good> goods, Ship myShip) {
        System.out.println("Debug: askSelectGoodToLoad");
        ((FlightController)this.actualPageController).handleGoodsLoading(goods);
    }

    @Override
    public void askSelectGoodToDiscard(Ship myShip) {
        System.out.println("Debug: askSelectGoodToDiscard");
    }

    @Override
    public void showEndGame(ArrayList<PlayerScore> scores) {
        System.out.println("Debug: showEndGame");
        Platform.runLater(() -> {
            try {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Dialogs/ConfirmDialog.fxml"));
                Parent page = (Parent)loader.load();
                Stage dialogStage = new Stage();
                dialogStage.setTitle("ATTENZIONE");
                dialogStage.initModality(Modality.APPLICATION_MODAL);
                dialogStage.initStyle(StageStyle.UTILITY);
                dialogStage.setResizable(false);
                dialogStage.setScene(new Scene(page));
                ConfirmDialogController controller = (ConfirmDialogController)loader.getController();
                controller.setDialogStage(dialogStage);
                controller.setMessage("Che tu lo voglia o no la partita \u00e8 terminata");
                dialogStage.showAndWait();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Scores.fxml"));
                Parent root = (Parent)loader.load();
                ScoresController pageController = (ScoresController)loader.getController();
                pageController.initialSetup(this, this.controller, this.controller.getMyModel(), this.primaryStage, this.musicManager);
                pageController.updateScores(scores);
                this.actualPageController = pageController;
                this.primaryScene.setRoot(root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void askCollectRewards() {
        System.out.println("Debug: askCollectRewards");
        Platform.runLater(() -> {
            if (this.ShowCustomConfirmDialog("Vuoi prendere la ricompensa perdendo i giorni di volo indicati? ").booleanValue()) {
                this.controller.sendCollectRewardsResponse(true);
            } else {
                this.controller.sendCollectRewardsResponse(false);
            }
        });
    }

    @Override
    public void showTimerInfos(ArrayList<TimerInfo> timerInfos, PLAYER_PHASE phase) {
        Platform.runLater(() -> {
            if (this.actualPageController.pageName().equals("BuildingPage")) {
                ((BuildingController)this.actualPageController).showTimerInfo(timerInfos);
            }
        });
    }

    @Override
    public void showYouAreNowSpectating() {
        Platform.runLater(() -> {
            try {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Dialogs/ConfirmDialog.fxml"));
                Parent page = (Parent)loader.load();
                Stage dialogStage = new Stage();
                dialogStage.setTitle("ATTENZIONE");
                dialogStage.initModality(Modality.APPLICATION_MODAL);
                dialogStage.initStyle(StageStyle.UTILITY);
                dialogStage.setResizable(false);
                dialogStage.setScene(new Scene(page));
                ConfirmDialogController controller = (ConfirmDialogController)loader.getController();
                controller.setDialogStage(dialogStage);
                controller.setMessage("Che tu lo voglia o no ora sei uno spettatore");
                dialogStage.showAndWait();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void autoShowShipInTui(Ship shipView, String Nickname) {
    }
}

