/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Gui.Elements;

import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;

public class SingleShipController {
    @FXML
    private StackPane shipGridContainer;
    @FXML
    private GridPane shipGrid;
    private String nicknameOfPlayer;

    public void initialize(String nicknameOfPlayer, StackPane shipGridContainer) {
        this.nicknameOfPlayer = nicknameOfPlayer;
        double aspectRatio = 1.4;
        this.shipGridContainer = shipGridContainer;
        this.shipGridContainer.widthProperty().addListener((obs, oldVal, newVal) -> this.adjustGridPaneSize(aspectRatio));
        this.shipGridContainer.heightProperty().addListener((obs, oldVal, newVal) -> this.adjustGridPaneSize(aspectRatio));
        Platform.runLater(() -> this.adjustGridPaneSize(aspectRatio));
    }

    public GridPane getShipGrid() {
        return this.shipGrid;
    }

    public String getNicknameOfPlayer() {
        return this.nicknameOfPlayer;
    }

    public void setNicknameOfPlayer(String nicknameOfPlayer) {
        this.nicknameOfPlayer = nicknameOfPlayer;
    }

    private void adjustGridPaneSize(double aspectRatio) {
        double newWidth;
        double newHeight;
        double containerWidth = this.shipGridContainer.getWidth();
        double containerHeight = this.shipGridContainer.getHeight();
        if (containerWidth <= 0.0 || containerHeight <= 0.0) {
            return;
        }
        if (containerWidth / containerHeight > aspectRatio) {
            newHeight = containerHeight;
            newWidth = newHeight * aspectRatio;
        } else {
            newWidth = containerWidth;
            newHeight = newWidth / aspectRatio;
        }
        this.shipGrid.setMinWidth(0.0);
        this.shipGrid.setMinHeight(0.0);
        this.shipGrid.setPrefWidth(newWidth);
        this.shipGrid.setPrefHeight(newHeight);
    }
}

