/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Gui;

import it.polimi.ingsw.galaxytrucker.controller.ClientController;
import it.polimi.ingsw.galaxytrucker.enums.GameState;
import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.model.game.TimerInfo;
import it.polimi.ingsw.galaxytrucker.network.client.ClientModel;
import it.polimi.ingsw.galaxytrucker.view.Gui.Abstract.GenericGamePhaseSceneController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Elements.SMCheckShipController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Elements.SMLoadCrewController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Elements.SMSpiedCardsController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Elements.SMtronconiController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Elements.SingleShipController;
import it.polimi.ingsw.galaxytrucker.view.Gui.GuiJavaFx;
import it.polimi.ingsw.galaxytrucker.view.Gui.MusicManager;
import it.polimi.ingsw.galaxytrucker.view.Gui.zUtils;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class BuildingController
extends GenericGamePhaseSceneController {
    private GuiJavaFx mainViewController;
    private ClientController clientController;
    private ClientModel myModel;
    private Stage primaryStage;
    private MusicManager musicManager;
    @FXML
    private StackPane myShipZone;
    @FXML
    private ImageView avatar2;
    @FXML
    private ImageView avatar3;
    @FXML
    private ImageView avatar4;
    @FXML
    private Label name2;
    @FXML
    private Label name3;
    @FXML
    private Label name4;
    @FXML
    private StackPane shipZone2;
    @FXML
    private StackPane shipZone3;
    @FXML
    private StackPane shipZone4;
    @FXML
    private FlowPane listaTiles;
    @FXML
    private ScrollPane scrollListaTiles;
    @FXML
    private StackPane StackCenterMenu;
    @FXML
    private StackPane StackLeftMenu;
    @FXML
    private StackPane mainStackPane;
    @FXML
    private HBox learningMatchOverlay;
    @FXML
    private HBox learningMatchOverlay2;
    @FXML
    private HBox endBuildingOverlay;
    @FXML
    private ImageView inHandTileImage;
    @FXML
    private Pane overlayPane;
    @FXML
    private ImageView asideTile1;
    @FXML
    private ImageView asideTile2;
    @FXML
    private Button BtnFinishBuilding;
    @FXML
    private Label lblTimer1;
    @FXML
    private Label lblTimer2;
    @FXML
    private Label lblTimer3;
    private ArrayList<SingleShipController> shipControllers;
    private Boolean finishedBuilding;
    private Boolean currPhaseDone;

    @Override
    public void initialSetup(GuiJavaFx mainViewController, ClientController clientController, ClientModel myModel, Stage primaryStage, MusicManager musicManager) {
        this.mainViewController = mainViewController;
        this.clientController = clientController;
        this.myModel = myModel;
        this.primaryStage = primaryStage;
        this.musicManager = musicManager;
        this.finishedBuilding = false;
        this.currPhaseDone = false;
        this.listaTiles.prefWidthProperty().bind(this.scrollListaTiles.widthProperty());
        this.shipControllers = new ArrayList();
        if (myModel.isLearningMatch()) {
            this.learningMatchOverlay.visibleProperty().set(true);
            this.learningMatchOverlay2.visibleProperty().set(true);
        }
        int j = 0;
        List<StackPane> shipZones = List.of(this.shipZone2, this.shipZone3, this.shipZone4);
        List<Label> names = List.of(this.name2, this.name3, this.name4);
        List<ImageView> avatars = List.of(this.avatar2, this.avatar3, this.avatar4);
        try {
            j = 0;
            for (int i = 0; i < myModel.getPlayerInfos().size(); ++i) {
                SingleShipController controller;
                Parent shipNode;
                FXMLLoader loader;
                if (myModel.getPlayerInfos().get(i).getNickName().equals(myModel.getMyInfo().getNickName())) {
                    loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/SingleShip.fxml"));
                    shipNode = (Parent)loader.load();
                    controller = (SingleShipController)loader.getController();
                    controller.initialize(myModel.getMyInfo().getNickName(), this.myShipZone);
                    this.shipControllers.add(controller);
                    this.myShipZone.getChildren().add(shipNode);
                    continue;
                }
                loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/SingleShip.fxml"));
                shipNode = (Parent)loader.load();
                controller = (SingleShipController)loader.getController();
                controller.initialize(myModel.getPlayerInfos().get(i).getNickName(), shipZones.get(j));
                this.shipControllers.add(controller);
                shipZones.get(j).getChildren().add(shipNode);
                names.get(j).setText(myModel.getPlayerInfos().get(i).getNickName());
                switch (myModel.getPlayerInfos().get(i).getColor()) {
                    case RED: {
                        avatars.get(j).setImage(new Image(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/AvatarRosso.png").toExternalForm()));
                        break;
                    }
                    case YELLOW: {
                        avatars.get(j).setImage(new Image(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/AvatarGiallo.png").toExternalForm()));
                        break;
                    }
                    case BLUE: {
                        avatars.get(j).setImage(new Image(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/AvatarBlu.png").toExternalForm()));
                        break;
                    }
                    case GREEN: {
                        avatars.get(j).setImage(new Image(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/AvatarVerde.png").toExternalForm()));
                    }
                }
                ++j;
            }
        }
        catch (IOException e) {
            System.out.println("IoException nel caricare i file");
        }
        this.scrollListaTiles.setOnMouseClicked(event -> {
            if (event.getClickCount() == 1 && event.getButton() == MouseButton.PRIMARY) {
                if (clientController.getCurrentTileInHand() != null) {
                    clientController.handleBuildingMenuChoice("h");
                    this.inHandTileImage.visibleProperty().set(false);
                }
                event.consume();
            }
        });
        this.mainStackPane.setOnMouseMoved(event -> Platform.runLater(() -> {
            this.inHandTileImage.setLayoutX(event.getX() - this.inHandTileImage.getFitWidth() / 2.0);
            this.inHandTileImage.setLayoutY(event.getY() - this.inHandTileImage.getFitHeight() / 2.0);
        }));
    }

    public void showTimerInfo(ArrayList<TimerInfo> timerInfos) {
        List<Label> timerLabels = List.of(this.lblTimer1, this.lblTimer2, this.lblTimer3);
        Platform.runLater(() -> {
            if (timerInfos != null) {
                for (int i = 0; i < timerInfos.size(); ++i) {
                    if (((TimerInfo)timerInfos.get(i)).isFlipped()) {
                        ((Label)timerLabels.get(i)).setTextFill(Color.ORANGERED);
                    } else {
                        ((Label)timerLabels.get(i)).setTextFill(Color.WHITE);
                    }
                    ((Label)timerLabels.get(i)).setText(Integer.toString(((TimerInfo)timerInfos.get(i)).getValue()));
                }
            }
        });
    }

    public void flipTimer() {
        if (this.clientController.canFlipHourglass()) {
            this.clientController.sendFlipRequest();
            GuiJavaFx.playWavSoundEffect("ButtonClick.wav");
        } else {
            GuiJavaFx.playWavSoundEffect("error.wav");
        }
    }

    @Override
    public String pageName() {
        return "BuildingPage";
    }

    @Override
    public void ShowGenericMessage(String message) {
        if (this.clientController.getPhase() == GameState.SHIP_CHECK || this.clientController.getPhase() == GameState.CREW_INIT) {
            Platform.runLater(() -> {
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setTitle("Comunicazione di servizio");
                alert.setHeaderText("Sig. " + this.clientController.getMyModel().getMyInfo().getNickName() + ":");
                alert.setContentText(message);
                alert.showAndWait();
            });
        }
    }

    public void updateFaceUpTiles() {
        Platform.runLater(() -> {
            this.listaTiles.getChildren().clear();
            System.out.println("Building controller DEBUG: showFaceUpTiles");
            try {
                this.myModel.getFaceUpTiles().forEach(tile -> {
                    String tileIdVal = String.valueOf(tile.getId());
                    String imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/tiles/GT-new_tiles_16_for web".concat(tileIdVal).concat(".jpg");
                    Image img = new Image(Objects.requireNonNull(zUtils.class.getResource(imagePath)).toExternalForm());
                    ImageView imgView = new ImageView(img);
                    imgView.fitHeightProperty().bind(this.scrollListaTiles.widthProperty().divide(4.5));
                    imgView.fitWidthProperty().bind(imgView.fitHeightProperty());
                    imgView.setRotate(tile.getRotation());
                    imgView.setOnMouseClicked(event -> {
                        if (this.clientController.getCurrentTileInHand() == null) {
                            this.clientController.handleChooseFaceUpTile((Tile)tile);
                        }
                    });
                    this.listaTiles.getChildren().add(imgView);
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void pescaRandom(ActionEvent actionEvent) {
        if (this.clientController.getCurrentTileInHand() == null) {
            this.clientController.handleDrawFaceDownTile();
            GuiJavaFx.playWavSoundEffect("ButtonClick.wav");
        }
    }

    public void hideZonaPescata() {
        this.inHandTileImage.setVisible(false);
    }

    @Override
    public void showShip(Ship ship, String Nickname) {
        Boolean editable = true;
        if (this.finishedBuilding.booleanValue() && this.clientController.getPhase() != GameState.CREW_INIT && this.clientController.getPhase() != GameState.SHIP_CHECK) {
            editable = false;
        }
        if (this.currPhaseDone.booleanValue()) {
            editable = false;
        }
        Boolean details = this.clientController.getPhase() == GameState.CREW_INIT ? Boolean.valueOf(true) : Boolean.valueOf(false);
        for (int i = 0; i < this.shipControllers.size(); ++i) {
            if (!this.shipControllers.get(i).getNicknameOfPlayer().equals(Nickname)) continue;
            if (this.myModel.getMyInfo().getNickName().equals(Nickname)) {
                zUtils.showShipInGrid(this.myModel.getMyInfo().getShip(), this.shipControllers.get(i).getShipGrid(), this.clientController, editable, details, null, null);
                continue;
            }
            zUtils.showShipInGrid(this.myModel.getPlayerInfoByNickname(Nickname).getShip(), this.shipControllers.get(i).getShipGrid(), this.clientController, false, details, null, null);
        }
        this.updateSetAsideTiles();
    }

    @Override
    public void chooseTroncone(ArrayList<Ship> tronconi) {
        Platform.runLater(() -> {
            try {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/SMtronconi.fxml"));
                ScrollPane root = (ScrollPane)loader.load();
                SMtronconiController pageController = (SMtronconiController)loader.getController();
                pageController.initialize(this.clientController, tronconi, this.StackCenterMenu);
                root.setMaxWidth(Double.MAX_VALUE);
                root.setMaxHeight(Double.MAX_VALUE);
                this.StackCenterMenu.getChildren().add(root);
                this.showShip(this.myModel.getMyInfo().getShip(), this.myModel.getMyInfo().getNickName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void showWaitOtherPlayers(Boolean clearLast) {
        System.out.println("debug: showWaitOtherPlayers");
        if (clearLast.booleanValue()) {
            this.StackCenterMenu.getChildren().removeLast();
        }
        if (this.StackCenterMenu.getChildren().size() < 2) {
            this.currPhaseDone = true;
            this.showShip(this.myModel.getMyInfo().getShip(), this.myModel.getMyInfo().getNickName());
            VBox root = null;
            try {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/WaitOverlay.fxml"));
                root = (VBox)loader.load();
                root.setMaxWidth(Double.MAX_VALUE);
                root.setMaxHeight(Double.MAX_VALUE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.StackCenterMenu.getChildren().add(root);
        }
    }

    public void finishBuilding(ActionEvent e) {
        this.clientController.handleBuildingMenuChoice("i");
        GuiJavaFx.playWavSoundEffect("ButtonClick.wav");
    }

    public void handleFinishBuilding() {
        this.BtnFinishBuilding.setDisable(true);
        this.finishedBuilding = true;
        this.showWaitOtherPlayers(false);
        if (!this.myModel.isLearningMatch()) {
            this.endBuildingOverlay.setVisible(true);
        }
    }

    public void updateBuildingPageInterface(GameState state) {
        GameState gameState = state;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"SHIP_CHECK", "CREW_INIT"}, (GameState)gameState, n)) {
            case 0: {
                Platform.runLater(() -> {
                    this.currPhaseDone = false;
                    if (this.StackCenterMenu.getChildren().size() > 1) {
                        this.StackCenterMenu.getChildren().removeLast();
                    }
                    try {
                        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/SMCheckShip.fxml"));
                        VBox root = (VBox)loader.load();
                        SMCheckShipController pageController = (SMCheckShipController)loader.getController();
                        pageController.initialize(this.clientController);
                        root.setMaxWidth(Double.MAX_VALUE);
                        root.setMaxHeight(Double.MAX_VALUE);
                        this.StackCenterMenu.getChildren().add(root);
                        this.showShip(this.myModel.getMyInfo().getShip(), this.myModel.getMyInfo().getNickName());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
                break;
            }
            case 1: {
                Platform.runLater(() -> {
                    this.currPhaseDone = false;
                    if (this.StackCenterMenu.getChildren().size() > 1) {
                        this.StackCenterMenu.getChildren().removeLast();
                    }
                    try {
                        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/SMLoadCrew.fxml"));
                        VBox root = (VBox)loader.load();
                        SMLoadCrewController pageController = (SMLoadCrewController)loader.getController();
                        pageController.initialize(this.clientController, this.mainViewController, this.StackCenterMenu, this);
                        root.setMaxWidth(Double.MAX_VALUE);
                        root.setMaxHeight(Double.MAX_VALUE);
                        this.StackCenterMenu.getChildren().add(root);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.showShip(this.myModel.getMyInfo().getShip(), this.myModel.getMyInfo().getNickName());
                });
                break;
            }
        }
    }

    public void viewMazzoUno() {
        this.viewMazzo(0);
    }

    public void viewMazzoDue() {
        this.viewMazzo(1);
    }

    public void viewMazzoTre() {
        this.viewMazzo(2);
    }

    public void viewMazzo(int num) {
        if (!this.clientController.hasTileInHand() && this.clientController.viewAdventureCardDeck(num).booleanValue()) {
            Platform.runLater(() -> {
                this.clientController.sendShipUpdate();
                if (this.StackLeftMenu.getChildren().size() > 1) {
                    this.StackLeftMenu.getChildren().removeLast();
                }
                try {
                    FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/SMSpiedCards.fxml"));
                    VBox root = (VBox)loader.load();
                    SMSpiedCardsController pageController = (SMSpiedCardsController)loader.getController();
                    pageController.initialize(this.myModel.getCardDecks().get(num), this.StackLeftMenu);
                    root.setMaxWidth(Double.MAX_VALUE);
                    root.setMaxHeight(Double.MAX_VALUE);
                    this.StackLeftMenu.getChildren().add(root);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public void showDrawnTile(Tile tile) {
        String tileIdVal = String.valueOf(tile.getId());
        String imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/tiles/GT-new_tiles_16_for web".concat(tileIdVal).concat(".jpg");
        Image img = new Image(Objects.requireNonNull(zUtils.class.getResource(imagePath)).toExternalForm());
        this.inHandTileImage.setImage(img);
        this.inHandTileImage.setRotate(tile.getRotation());
        this.inHandTileImage.setVisible(true);
        this.inHandTileImage.setFitHeight(100.0);
        this.inHandTileImage.setFitWidth(100.0);
    }

    public void pickedAside1(MouseEvent event) {
        if (event.getButton() == MouseButton.PRIMARY) {
            this.handlePickedAsideTile(0);
        }
    }

    public void pickedAside2(MouseEvent event) {
        if (event.getButton() == MouseButton.PRIMARY) {
            this.handlePickedAsideTile(1);
        }
    }

    public void handlePickedAsideTile(int pos) {
        if (!this.finishedBuilding.booleanValue()) {
            if (this.clientController.getCurrentTileInHand() != null) {
                if (this.clientController.getReservedTiles()[pos] == null) {
                    this.clientController.handlePickReservedTile(pos, false);
                }
            } else if (this.clientController.getReservedTiles()[pos] != null) {
                this.clientController.handlePickReservedTile(pos, true);
            }
        }
    }

    public void updateSetAsideTiles() {
        Platform.runLater(() -> {
            List<ImageView> imageViews = List.of(this.asideTile1, this.asideTile2);
            for (int i = 0; i < this.clientController.getMyShip().getAsideTiles().length; ++i) {
                if (this.clientController.getMyShip().getAsideTiles()[i] != null) {
                    String tileIdVal = String.valueOf(this.clientController.getMyShip().getAsideTiles()[i].getId());
                    String imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/tiles/GT-new_tiles_16_for web".concat(tileIdVal).concat(".jpg");
                    Image img = new Image(zUtils.class.getResource(imagePath).toExternalForm());
                    imageViews.get(i).setImage(img);
                    imageViews.get(i).setRotate(this.clientController.getMyShip().getAsideTiles()[i].getRotation());
                    continue;
                }
                String imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/tiles/empty.jpg";
                Image img = new Image(zUtils.class.getResource(imagePath).toExternalForm());
                imageViews.get(i).setImage(img);
            }
        });
    }
}

