/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.network.server;

import it.polimi.ingsw.galaxytrucker.controller.ServerController;
import it.polimi.ingsw.galaxytrucker.enums.NetworkMessageType;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessage;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.NicknameRequest;
import it.polimi.ingsw.galaxytrucker.network.server.ClientHandler;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.PrinterLabels;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.PrinterUtils;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.TuiColor;
import it.polimi.ingsw.galaxytrucker.visitors.Network.NetworkMessageNameVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SocketClientHandler
implements Runnable,
ClientHandler {
    private final Object inputLock;
    private ObjectOutputStream output;
    private ObjectInputStream input;
    private final Socket clientSocket;
    private final ServerController serverController;
    NetworkMessageNameVisitor nmnv = new NetworkMessageNameVisitor();
    private final UUID clientID;
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public SocketClientHandler(Socket socket, ServerController controller) {
        this.clientSocket = socket;
        this.inputLock = new Object();
        this.serverController = controller;
        this.clientID = UUID.randomUUID();
        try {
            this.output = new ObjectOutputStream(this.clientSocket.getOutputStream());
            this.input = new ObjectInputStream(this.clientSocket.getInputStream());
        }
        catch (IOException e) {
            System.out.println("Error in ClientHandler");
        }
    }

    @Override
    public void run() {
        try {
            System.out.println("Client " + String.valueOf(this.clientSocket.getInetAddress()) + " connected to " + String.valueOf(this.clientSocket.getRemoteSocketAddress()));
            this.ConnectionManager();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            System.out.println("Client " + String.valueOf(this.clientSocket.getInetAddress()) + " connection dropped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void ConnectionManager() throws IOException, ExecutionException, InterruptedException {
        this.serverController.startNewHeartbeat(this);
        try {
            while (!Thread.currentThread().isInterrupted()) {
                Object object = this.inputLock;
                synchronized (object) {
                    NetworkMessage message = (NetworkMessage)this.input.readObject();
                    NetworkMessageType type = message.accept(this.nmnv);
                    if (type.equals((Object)NetworkMessageType.NicknameRequest)) {
                        NicknameRequest request = (NicknameRequest)message;
                        System.out.println("Nickname received: " + request.getNickname());
                    }
                    if (type != NetworkMessageType.HeartbeatRequest) {
                        System.out.println(PrinterUtils.getTextWithLabel(PrinterLabels.ServerSocket, TuiColor.GREEN, "MESSAGE " + String.valueOf((Object)type) + " RECEIVED FROM " + this.clientSocket.getInetAddress().toString()));
                    }
                    this.executor.submit(() -> {
                        try {
                            this.serverController.getMessageManager().handle(message, this);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }
            }
        }
        catch (IOException | ClassCastException | ClassNotFoundException e) {
            this.executor.shutdownNow();
        }
        this.clientSocket.close();
    }

    @Override
    public UUID getClientID() {
        return this.clientID;
    }

    @Override
    public synchronized void sendMessage(NetworkMessage message) {
        try {
            this.output.reset();
            this.output.writeObject(message);
            this.output.flush();
        }
        catch (IOException e) {
            System.out.println(PrinterUtils.getTextWithLabel(PrinterLabels.ServerSocket, TuiColor.GREEN, "Tried to send a message to a closed socket: " + this.clientSocket.getInetAddress().toString()));
        }
    }

    public String toString() {
        return this.clientSocket.getInetAddress().toString();
    }
}

