/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.network.server;

import it.polimi.ingsw.galaxytrucker.controller.ServerController;
import it.polimi.ingsw.galaxytrucker.controller.ServerControllerHandles;
import it.polimi.ingsw.galaxytrucker.network.client.rmi.ClientInterfaceRMI;
import it.polimi.ingsw.galaxytrucker.network.server.ClientHandler;
import it.polimi.ingsw.galaxytrucker.network.server.RMIClientHandler;
import it.polimi.ingsw.galaxytrucker.network.server.ServerRMIInterface;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.PrinterLabels;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.PrinterUtils;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.TuiColor;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServerRMI
extends UnicastRemoteObject
implements ServerRMIInterface {
    ServerControllerHandles serverControllerHandles;
    private final Map<ClientInterfaceRMI, ClientHandler> clientMap = new ConcurrentHashMap<ClientInterfaceRMI, ClientHandler>();

    public ServerRMI(ServerControllerHandles serverControllerHandles) throws RemoteException {
        Registry registry = LocateRegistry.createRegistry(1099);
        registry.rebind("GameServer", this);
        System.out.println(PrinterUtils.getTextWithLabel(PrinterLabels.ServerRMI, TuiColor.BLUE, "Avviato sulla porta 1099"));
        this.serverControllerHandles = serverControllerHandles;
    }

    @Override
    public ServerControllerHandles getControllerHandles() throws RemoteException {
        return this.serverControllerHandles;
    }

    @Override
    public RMIClientHandler getClientHandler(ClientInterfaceRMI clientInterfaceRMI) throws RemoteException {
        return (RMIClientHandler)this.clientMap.get(clientInterfaceRMI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRMIRegistration(ClientInterfaceRMI clientStub) throws RemoteException {
        ServerController controller = (ServerController)this.serverControllerHandles;
        RMIClientHandler handler = new RMIClientHandler(clientStub, controller);
        ArrayList<ClientHandler> arrayList = controller.getClients();
        synchronized (arrayList) {
            controller.addClient(handler);
        }
        this.clientMap.put(clientStub, handler);
    }
}

