/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests;

import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessage;
import it.polimi.ingsw.galaxytrucker.visitors.Network.NetworkMessageVisitorsInterface;
import java.io.Serializable;

public class DrawTileRequest
extends NetworkMessage
implements Serializable {
    private static final long serialVersionUID = 533L;
    private Tile tile;
    private boolean needLastTile;
    private boolean fromReserved;
    private int reservedSlotIndex = -1;

    public DrawTileRequest() {
        this.tile = null;
        this.needLastTile = false;
    }

    public DrawTileRequest(Tile tile) {
        this.tile = tile;
        this.needLastTile = false;
    }

    public static DrawTileRequest reclaimLastTileRequest() {
        DrawTileRequest req = new DrawTileRequest();
        req.needLastTile = true;
        return req;
    }

    public static DrawTileRequest fromReservedSlot(int index) {
        DrawTileRequest req = new DrawTileRequest();
        req.fromReserved = true;
        req.reservedSlotIndex = index;
        return req;
    }

    @Override
    public <T> T accept(NetworkMessageVisitorsInterface<T> visitor) {
        return visitor.visit(this);
    }

    public Tile getTile() {
        return this.tile;
    }

    public boolean isNeedLastTile() {
        return this.needLastTile;
    }

    public boolean isFromReserved() {
        return this.fromReserved;
    }

    public int getReservedSlotIndex() {
        return this.reservedSlotIndex;
    }
}

