/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.model.essentials.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.polimi.ingsw.galaxytrucker.enums.AlienColor;
import it.polimi.ingsw.galaxytrucker.enums.Color;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.CentralHousingUnit;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentVisitorInterface;

public class ModularHousingUnit
extends CentralHousingUnit {
    private int nBrownAlien = 0;
    private int nPurpleAlien = 0;
    private AlienColor alienColor;

    public void setAlienColor(AlienColor alienColor) {
        this.alienColor = alienColor;
    }

    @JsonCreator
    public ModularHousingUnit(@JsonProperty(value="color") Color color, @JsonProperty(value="nbrownAlien") int nBrownAlien, @JsonProperty(value="npurpleAlien") int nPurpleAlien, @JsonProperty(value="alienColor") AlienColor alienColor, @JsonProperty(value="humanCrewNumber") int humanCrew) {
        super(color, humanCrew);
        this.nBrownAlien = nBrownAlien;
        this.nPurpleAlien = nPurpleAlien;
        this.alienColor = alienColor != null ? alienColor : AlienColor.EMPTY;
    }

    public ModularHousingUnit() {
        super(Color.EMPTY);
        this.alienColor = AlienColor.EMPTY;
    }

    public void addBrownAlien() {
        this.alienColor = AlienColor.BROWN;
        ++this.nBrownAlien;
    }

    public void addPurpleAlien() {
        this.alienColor = AlienColor.PURPLE;
        ++this.nPurpleAlien;
    }

    public void addHumanCrew() {
        super.setHumanCrewNumber(2);
    }

    public void removeBrownAlien() {
        if (this.nBrownAlien > 0 && this.alienColor == AlienColor.BROWN) {
            --this.nBrownAlien;
            this.alienColor = AlienColor.EMPTY;
        }
    }

    public void removeAllCrew() {
        this.nPurpleAlien = 0;
        this.nBrownAlien = 0;
        super.setHumanCrewNumber(0);
        this.alienColor = AlienColor.EMPTY;
    }

    public void removeAlienCrew() {
        this.nPurpleAlien = 0;
        this.nBrownAlien = 0;
        this.alienColor = AlienColor.EMPTY;
    }

    public void removePurpleAlien() {
        if (this.nPurpleAlien > 0 && this.alienColor == AlienColor.PURPLE) {
            --this.nPurpleAlien;
            this.alienColor = AlienColor.EMPTY;
        }
    }

    @Override
    public void removeCrewMember() {
        switch (this.alienColor) {
            case EMPTY: {
                super.removeCrewMember();
                break;
            }
            case BROWN: {
                this.removeAllCrew();
                break;
            }
            case PURPLE: {
                this.removeAllCrew();
            }
        }
    }

    @Override
    public int getNCrewMembers() {
        int result = 0;
        switch (this.alienColor) {
            case PURPLE: {
                result = this.getNPurpleAlien();
                break;
            }
            case BROWN: {
                result = this.getNBrownAlien();
                break;
            }
            case EMPTY: {
                result = super.getNCrewMembers();
                break;
            }
            default: {
                throw new IllegalStateException("Multiversal housing issue.");
            }
        }
        return result;
    }

    public int getNBrownAlien() {
        return this.nBrownAlien;
    }

    public int getNPurpleAlien() {
        return this.nPurpleAlien;
    }

    public AlienColor getAlienColor() {
        return this.alienColor;
    }

    @Override
    public ModularHousingUnit clone() {
        ModularHousingUnit copy = (ModularHousingUnit)super.clone();
        copy.nBrownAlien = this.nBrownAlien;
        copy.nPurpleAlien = this.nPurpleAlien;
        copy.alienColor = this.alienColor;
        return copy;
    }

    @Override
    public <T> T accept(ComponentVisitorInterface<T> visitor) {
        return visitor.visit(this);
    }
}

