/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.model.essentials.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.polimi.ingsw.galaxytrucker.model.essentials.Component;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentVisitorInterface;

public class Engine
extends Component {
    protected int enginePower;

    @JsonCreator
    public Engine(@JsonProperty(value="enginePower") int enginePower) {
        super(false);
        this.enginePower = enginePower;
    }

    public int getEnginePower() {
        this.calculatePower();
        return this.enginePower;
    }

    private void calculatePower() {
        if (this.getRotation() != 0) {
            this.enginePower = 0;
        }
    }

    @Override
    public Engine clone() {
        Engine copy = (Engine)super.clone();
        copy.enginePower = this.enginePower;
        return copy;
    }

    @Override
    public <T> T accept(ComponentVisitorInterface<T> visitor) {
        return visitor.visit(this);
    }
}

