/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.model.essentials;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.polimi.ingsw.galaxytrucker.enums.Connector;
import it.polimi.ingsw.galaxytrucker.model.essentials.Component;
import java.io.Serializable;
import java.util.ArrayList;

public class Tile
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 535L;
    private int id;
    private int Rotation;
    private boolean flipped;
    private ArrayList<Connector> sides;
    private int exposedConnectors;
    private Boolean used;
    private Boolean fixed;
    private Component myComponent;
    private Boolean wellConnected;

    public Tile(int id, int rotation, ArrayList<Connector> s, Component c) {
        this.id = id;
        this.Rotation = rotation;
        this.flipped = false;
        this.sides = new ArrayList<Connector>(s);
        this.exposedConnectors = 0;
        this.used = false;
        this.fixed = false;
        this.wellConnected = true;
        this.myComponent = c;
    }

    @JsonCreator
    public Tile(@JsonProperty(value="id") int id, @JsonProperty(value="rotation") int rotation, @JsonProperty(value="flipped") boolean flipped, @JsonProperty(value="sides") ArrayList<Connector> s, @JsonProperty(value="myComponent") Component c, @JsonProperty(value="fixed") boolean fixed, @JsonProperty(value="wellConnected") boolean wellConnected) {
        this.id = id;
        this.Rotation = rotation;
        this.flipped = flipped;
        this.sides = new ArrayList<Connector>(s);
        this.exposedConnectors = 0;
        this.used = false;
        this.fixed = fixed;
        this.wellConnected = wellConnected;
        this.myComponent = c;
    }

    public Tile(Tile other) {
        this.id = other.id;
        this.Rotation = other.Rotation;
        this.flipped = other.flipped;
        this.sides = new ArrayList<Connector>(other.sides);
        this.exposedConnectors = other.exposedConnectors;
        this.used = other.used;
        this.fixed = other.fixed;
        this.wellConnected = other.wellConnected;
        this.myComponent = other.myComponent;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setMyComponent(Component myComponent1) {
        this.myComponent = myComponent1;
    }

    public Component getMyComponent() {
        return this.myComponent;
    }

    public void setUsed(Boolean used) {
        this.used = used;
    }

    public Boolean getUsed() {
        return this.used;
    }

    public Boolean getFixed() {
        return this.fixed;
    }

    public int getExposedConnectors() {
        return this.exposedConnectors;
    }

    public ArrayList<Connector> getSides() {
        return new ArrayList<Connector>(this.sides);
    }

    public void modifyExposedConnector(int i) {
        this.exposedConnectors += i;
    }

    public int getId() {
        return this.id;
    }

    public int getRotation() {
        return this.Rotation;
    }

    public void setRotation(int rotation) {
        this.Rotation = rotation;
    }

    public void rotate(int addRotation) {
        this.Rotation = (this.Rotation + addRotation) % 360;
        this.myComponent.setRotation(this.Rotation);
        this.setRotation(this.Rotation);
        int numRotation = (addRotation % 360 + 360) % 360 / 90;
        for (int i = 0; i < numRotation; ++i) {
            this.rotateSides90();
        }
    }

    private void rotateSides90() {
        if (this.sides == null || this.sides.size() != 4) {
            return;
        }
        Connector temp = this.sides.get(3);
        this.sides.set(3, this.sides.get(2));
        this.sides.set(2, this.sides.get(1));
        this.sides.set(1, this.sides.get(0));
        this.sides.set(0, temp);
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void flip() {
        this.flipped = !this.flipped;
    }

    public Boolean getWellConnected() {
        return this.wellConnected;
    }

    public void setWellConnected(Boolean wellConnected) {
        this.wellConnected = wellConnected;
    }

    public void testPrint() {
        System.out.print(this.id);
        System.out.print(this.Rotation);
        System.out.print(this.flipped);
        System.out.print(this.sides);
        System.out.print(this.exposedConnectors);
        System.out.print(this.used);
        System.out.println(this.fixed);
    }

    public void setFixed(Boolean fixed) {
        this.fixed = fixed;
    }

    public Tile clone() {
        try {
            Tile copy = new Tile(this);
            if (this.myComponent != null) {
                copy.myComponent = this.myComponent.clone();
            }
            return copy;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to clone Tile", e);
        }
    }
}

