/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.model.essentials;

import it.polimi.ingsw.galaxytrucker.model.essentials.FlightBoardMapSlot;
import java.io.Serializable;
import java.util.ArrayList;

public class FlightBoardMap
implements Serializable {
    private static final long serialVersionUID = 456983986094L;
    ArrayList<FlightBoardMapSlot> flightBoardMapSlots;
    int nSlots;
    int fourthPos;
    int thirdPos;
    int secondPos;
    int firstPos;
    int increment = 0;

    public FlightBoardMap(Boolean learnignMatch) {
        if (learnignMatch.booleanValue()) {
            this.generateLearning();
        } else {
            this.generateLvl2();
        }
    }

    public ArrayList<FlightBoardMapSlot> getFlightBoardMapSlots() {
        return this.flightBoardMapSlots;
    }

    private void generateLvl2() {
        this.nSlots = 24;
        this.fourthPos = 0;
        this.thirdPos = 1;
        this.secondPos = 3;
        this.firstPos = 6;
        this.flightBoardMapSlots = new ArrayList(this.nSlots);
        for (int j = 0; j < this.nSlots; ++j) {
            this.flightBoardMapSlots.add(new FlightBoardMapSlot());
        }
        int i = 0;
        for (FlightBoardMapSlot slot : this.flightBoardMapSlots) {
            if (i == this.firstPos || i == this.secondPos || i == this.thirdPos || i == this.fourthPos) {
                slot.setIsStartingPos(true);
                slot.setStartingPos(i);
            } else {
                slot.setIsStartingPos(false);
            }
            ++i;
        }
    }

    private void generateLearning() {
        this.nSlots = 18;
        this.fourthPos = 0;
        this.thirdPos = 1;
        this.secondPos = 2;
        this.firstPos = 4;
        this.flightBoardMapSlots = new ArrayList(this.nSlots);
        for (int j = 0; j < this.nSlots; ++j) {
            this.flightBoardMapSlots.add(new FlightBoardMapSlot());
        }
        int i = 0;
        for (FlightBoardMapSlot slot : this.flightBoardMapSlots) {
            if (i == this.firstPos || i == this.secondPos || i == this.thirdPos || i == this.fourthPos) {
                slot.setIsStartingPos(true);
                slot.setStartingPos(i);
            } else {
                slot.setIsStartingPos(false);
            }
            ++i;
        }
    }

    public int getFirstPos() {
        return this.firstPos + this.increment;
    }

    public int getSecondPos() {
        return this.secondPos + this.increment;
    }

    public int getThirdPos() {
        return this.thirdPos + this.increment;
    }

    public int getFourthPos() {
        return this.fourthPos + this.increment;
    }
}

