/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.model;

import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.model.utils.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

public class TileBunch {
    private ArrayList<Tile> tiles;
    private ArrayList<Tile> faceUpTiles;
    Random rand = new Random();

    public ArrayList<Tile> getTiles() {
        return this.tiles;
    }

    public void setTiles(ArrayList<Tile> tiles) {
        this.tiles = tiles;
    }

    public TileBunch() {
        this.faceUpTiles = new ArrayList();
        try {
            this.tiles = Util.generateTiles();
            ArrayList<Integer> centralCabIds = new ArrayList<Integer>();
            centralCabIds.add(33);
            centralCabIds.add(34);
            centralCabIds.add(52);
            centralCabIds.add(61);
            this.tiles.removeIf(tile -> centralCabIds.contains(tile.getId()));
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    public synchronized ArrayList<Tile> getFaceUpTiles() {
        return this.faceUpTiles;
    }

    public synchronized Tile drawFaceUpTile(int id) {
        if (!this.faceUpTiles.isEmpty()) {
            for (Tile tile : this.faceUpTiles) {
                if (tile.getId() != id) continue;
                this.faceUpTiles.remove(tile);
                return tile;
            }
        }
        return null;
    }

    public synchronized Tile drawTile() {
        if (!this.tiles.isEmpty()) {
            int randomIndex = this.rand.nextInt(this.tiles.size());
            Tile tile = this.tiles.get(randomIndex);
            tile.flip();
            this.tiles.remove(randomIndex);
            return tile;
        }
        return null;
    }

    public synchronized void returnTile(Tile tile) {
        this.faceUpTiles.add(tile);
    }

    public synchronized int getRemainingTiles() {
        return this.tiles.size();
    }
}

