/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.model;

import it.polimi.ingsw.galaxytrucker.enums.AlienColor;
import it.polimi.ingsw.galaxytrucker.enums.Connector;
import it.polimi.ingsw.galaxytrucker.enums.ProjectileDirection;
import it.polimi.ingsw.galaxytrucker.exceptions.InvalidTilePosition;
import it.polimi.ingsw.galaxytrucker.model.essentials.Component;
import it.polimi.ingsw.galaxytrucker.model.essentials.Good;
import it.polimi.ingsw.galaxytrucker.model.essentials.Position;
import it.polimi.ingsw.galaxytrucker.model.essentials.Slot;
import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.BatterySlot;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Cannon;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.CentralHousingUnit;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.DoubleCannon;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.DoubleEngine;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Engine;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.GenericCargoHolds;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.ModularHousingUnit;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Shield;
import it.polimi.ingsw.galaxytrucker.model.utils.Util;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentNameVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.util.Pair;

public class Ship
implements Serializable {
    private static final long serialVersionUID = 35856L;
    private final int shipboardMaxX = 7;
    private final int shipboardMaxY = 5;
    private Slot[][] shipBoard = new Slot[7][5];
    private Tile[] asideTiles = new Tile[2];
    private int nExposedConnector;
    private int destroyedTiles;
    private int nCrew;
    private int nGoods;
    private ArrayList<Pair<Good, Pair<Position, Slot>>> listOfGoods;
    private ArrayList<Good> listNotLoadedGoods;
    private Tile lastTile;
    private Position lastTilePosition;
    private Boolean synch;
    private Boolean learningMatch;
    private Set<Position> storagePos;
    private Set<Position> redStoragePos;
    private Set<Position> housingPos;
    private Set<Position> batteryPos;
    private Set<Position> cannonPos;
    private Set<Position> lssPos;
    private Set<Position> enginePos;
    private ArrayList<Position> invalidPositions;
    public Queue<Position> brokenPositions = new LinkedList<Position>();
    private int initialTiles;

    public Ship(Boolean learningMatch) {
        this.listNotLoadedGoods = new ArrayList();
        this.listOfGoods = new ArrayList();
        this.learningMatch = learningMatch;
        this.invalidPositions = this.createIP();
        this.generateSlot();
        this.initializePos();
    }

    public void generateSlot() {
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.shipBoard[i][j] = new Slot(new Position(i, j));
            }
        }
    }

    public void initializePos() {
        this.enginePos = new LinkedHashSet<Position>();
        this.batteryPos = new LinkedHashSet<Position>();
        this.cannonPos = new LinkedHashSet<Position>();
        this.redStoragePos = new LinkedHashSet<Position>();
        this.housingPos = new LinkedHashSet<Position>();
        this.storagePos = new LinkedHashSet<Position>();
        this.lssPos = new LinkedHashSet<Position>();
    }

    public Slot[][] getShipBoard() {
        return this.shipBoard;
    }

    public ArrayList<Position> getBatteryPos() {
        return new ArrayList<Position>(this.batteryPos);
    }

    public ArrayList<Position> getCannonPos() {
        return new ArrayList<Position>(this.cannonPos);
    }

    public ArrayList<Position> getEnginePos() {
        return new ArrayList<Position>(this.enginePos);
    }

    public int getInitialTiles() {
        return this.initialTiles;
    }

    public int getnExposedConnector() {
        this.calcExposedConnectors();
        return this.nExposedConnector;
    }

    public int getnBatterieLeft() {
        ArrayList<Position> batteryPos = this.getComponentPositionsFromName("BatterySlot");
        int nBatterieLeft = 0;
        for (Position pos : batteryPos) {
            nBatterieLeft += ((BatterySlot)this.getComponentFromPosition(pos)).getBatteriesLeft();
        }
        return nBatterieLeft;
    }

    public int getDestroyedTiles() {
        return this.destroyedTiles;
    }

    public int getNPurpleAlien() {
        return (int)this.getComponentPositionsFromName("ModularHousingUnit").stream().filter(p -> ((ModularHousingUnit)this.shipBoard[p.getX()][p.getY()].getTile().getMyComponent()).getNPurpleAlien() > 0).count();
    }

    public int getNBrownAlien() {
        return (int)this.getComponentPositionsFromName("ModularHousingUnit").stream().filter(p -> ((ModularHousingUnit)this.shipBoard[p.getX()][p.getY()].getTile().getMyComponent()).getNBrownAlien() > 0).count();
    }

    public int getnCrew() {
        this.nCrew = this.getComponentPositionsFromName("ModularHousingUnit").stream().map(p -> ((ModularHousingUnit)this.shipBoard[p.getX()][p.getY()].getTile().getMyComponent()).getNCrewMembers()).reduce(0, Integer::sum) + this.getComponentPositionsFromName("CentralHousingUnit").stream().map(p -> ((CentralHousingUnit)this.shipBoard[p.getX()][p.getY()].getTile().getMyComponent()).getNCrewMembers()).reduce(0, Integer::sum);
        return this.nCrew;
    }

    public ArrayList<Position> getInvalidPositions() {
        return this.invalidPositions;
    }

    public ArrayList<Position> createIP() {
        this.invalidPositions = new ArrayList();
        if (this.learningMatch.booleanValue()) {
            this.invalidPositions.add(new Position(0, 0));
            this.invalidPositions.add(new Position(1, 0));
            this.invalidPositions.add(new Position(2, 0));
            this.invalidPositions.add(new Position(6, 0));
            this.invalidPositions.add(new Position(5, 0));
            this.invalidPositions.add(new Position(4, 0));
            this.invalidPositions.add(new Position(1, 1));
            this.invalidPositions.add(new Position(0, 1));
            this.invalidPositions.add(new Position(5, 1));
            this.invalidPositions.add(new Position(6, 1));
            this.invalidPositions.add(new Position(6, 2));
            this.invalidPositions.add(new Position(0, 2));
            this.invalidPositions.add(new Position(0, 3));
            this.invalidPositions.add(new Position(6, 3));
            this.invalidPositions.add(new Position(0, 4));
            this.invalidPositions.add(new Position(6, 4));
            this.invalidPositions.add(new Position(3, 4));
        } else {
            this.invalidPositions.add(new Position(0, 0));
            this.invalidPositions.add(new Position(1, 0));
            this.invalidPositions.add(new Position(3, 0));
            this.invalidPositions.add(new Position(6, 0));
            this.invalidPositions.add(new Position(5, 0));
            this.invalidPositions.add(new Position(0, 1));
            this.invalidPositions.add(new Position(6, 1));
            this.invalidPositions.add(new Position(3, 4));
        }
        return new ArrayList<Position>(this.invalidPositions);
    }

    public void putTile(Tile tile, Position pos) {
        if (Util.inBoundaries(pos.getX(), pos.getY()).booleanValue() && !this.invalidPositions.contains(pos)) {
            if (this.shipBoard[pos.getX()][pos.getY()] == null) {
                this.shipBoard[pos.getX()][pos.getY()] = new Slot(pos);
            }
            try {
                if (tile == null) {
                    throw new IllegalArgumentException("Tile is null");
                }
                this.shipBoard[pos.getX()][pos.getY()].putTile(tile);
                this.updateSets(pos, tile);
            }
            catch (InvalidTilePosition | IllegalArgumentException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public void updateSets(Position pos, Tile tile) {
        ComponentNameVisitor visitor = new ComponentNameVisitor();
        switch (tile.getMyComponent().accept(visitor)) {
            case "BatterySlot": {
                this.batteryPos.add(pos);
                break;
            }
            case "Cannon": {
                this.cannonPos.add(pos);
                break;
            }
            case "Engine": {
                this.enginePos.add(pos);
                break;
            }
            case "DoubleCannon": {
                this.cannonPos.add(pos);
                break;
            }
            case "DoubleEngine": {
                this.enginePos.add(pos);
                break;
            }
            case "ModularHousingUnit": {
                this.housingPos.add(pos);
                break;
            }
            case "GenericCargoHolds": {
                GenericCargoHolds test = (GenericCargoHolds)tile.getMyComponent();
                Boolean s = test.isSpecial();
                if (s.booleanValue()) {
                    this.redStoragePos.add(pos);
                    break;
                }
                this.storagePos.add(pos);
                break;
            }
            case "LifeSupportSystem": {
                this.lssPos.add(pos);
                break;
            }
        }
    }

    public void removeTile(Position pos, Boolean isNormalRemove) {
        System.out.println("STO ELIMIMANDO" + pos.toOffsetString());
        if (!isNormalRemove.booleanValue()) {
            this.brokenPositions.add(pos);
            ++this.destroyedTiles;
        }
        if (Util.inBoundaries(pos.getX(), pos.getY()).booleanValue() && !this.invalidPositions.contains(pos)) {
            Slot slot = this.shipBoard[pos.getX()][pos.getY()];
            if (slot != null) {
                slot.removeTile();
            } else {
                System.out.println("WARN: Tried to remove tile from null slot at " + String.valueOf(pos));
            }
        } else {
            System.out.println("WARN: Tried to remove tile from null slot at " + String.valueOf(pos));
        }
    }

    public void calcExposedConnectors() {
        this.nExposedConnector = 0;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 5; ++j) {
                Tile tempTile;
                ArrayList validPos = new ArrayList();
                Position tempPos = new Position(i, j);
                if (this.shipBoard[i][j].getTile() == null) continue;
                Tile myTile = this.shipBoard[i][j].getTile();
                Position nord = new Position(i, j - 1);
                Position sud = new Position(i, j + 1);
                Position est = new Position(i + 1, j);
                Position ovest = new Position(i - 1, j);
                if (myTile.getSides().get(0) != Connector.EMPTY) {
                    if (!this.invalidPositions.contains(nord) && Util.inBoundaries(nord.getX(), nord.getY()).booleanValue()) {
                        tempTile = this.shipBoard[nord.getX()][nord.getY()].getTile();
                        if (tempTile == null) {
                            ++this.nExposedConnector;
                        }
                    } else {
                        ++this.nExposedConnector;
                    }
                }
                if (myTile.getSides().get(1) != Connector.EMPTY) {
                    if (!this.invalidPositions.contains(est) && Util.inBoundaries(est.getX(), est.getY()).booleanValue()) {
                        tempTile = this.shipBoard[est.getX()][est.getY()].getTile();
                        if (tempTile == null) {
                            ++this.nExposedConnector;
                        }
                    } else {
                        ++this.nExposedConnector;
                    }
                }
                if (myTile.getSides().get(2) != Connector.EMPTY) {
                    if (!this.invalidPositions.contains(sud) && Util.inBoundaries(sud.getX(), sud.getY()).booleanValue()) {
                        tempTile = this.shipBoard[sud.getX()][sud.getY()].getTile();
                        if (tempTile == null) {
                            ++this.nExposedConnector;
                        }
                    } else {
                        ++this.nExposedConnector;
                    }
                }
                if (myTile.getSides().get(3) == Connector.EMPTY) continue;
                if (!this.invalidPositions.contains(ovest) && Util.inBoundaries(ovest.getX(), ovest.getY()).booleanValue()) {
                    tempTile = this.shipBoard[ovest.getX()][ovest.getY()].getTile();
                    if (tempTile != null) continue;
                    ++this.nExposedConnector;
                    continue;
                }
                ++this.nExposedConnector;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < 5; ++j) {
            for (int i = 0; i < 7; ++i) {
                if (this.shipBoard[i][j] != null && this.shipBoard[i][j].getTile() != null) {
                    if (this.shipBoard[i][j].getTile().getWellConnected().booleanValue()) {
                        sb.append("[Y] ");
                        continue;
                    }
                    sb.append("[N] ");
                    continue;
                }
                if (this.shipBoard[i][j] != null && this.shipBoard[i][j].getTile() == null) {
                    int finalJ = j;
                    int finalI = i;
                    if (this.invalidPositions.stream().anyMatch(pos -> pos.getX() == finalI && pos.getY() == finalJ)) {
                        sb.append("[X] ");
                        continue;
                    }
                    sb.append("[.] ");
                    continue;
                }
                if (this.shipBoard[i][j] != null) continue;
                sb.append("[.] ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public Boolean checkShip() {
        boolean result = true;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 5; ++j) {
                Boolean temp;
                Position tempPos = new Position(i, j);
                Tile tile = this.getTileFromPosition(tempPos);
                if (this.shipBoard[i][j] == null || this.shipBoard[i][j].getTile() == null) continue;
                if (!Util.wellConnectedConnectors(this, this.shipBoard[i][j], this.shipBoard[i][j].getTile()).booleanValue()) {
                    this.shipBoard[i][j].getTile().setWellConnected(false);
                    result = false;
                    continue;
                }
                this.shipBoard[i][j].getTile().setWellConnected(true);
                if (this.shipBoard[i][j].getTile().getMyComponent().accept(new ComponentNameVisitor()).equals("Engine") || this.shipBoard[i][j].getTile().getMyComponent().accept(new ComponentNameVisitor()).equals("DoubleEngine")) {
                    temp = Util.EngineWellConnected(this.shipBoard[i][j].getTile(), this, this.shipBoard[i][j]);
                    this.shipBoard[i][j].getTile().setWellConnected(temp);
                    if (!temp.booleanValue()) {
                        result = false;
                    }
                }
                if (this.shipBoard[i][j].getTile().getMyComponent().accept(new ComponentNameVisitor()).equals("Cannon") || this.shipBoard[i][j].getTile().getMyComponent().accept(new ComponentNameVisitor()).equals("DoubleCannon")) {
                    temp = Util.CannonWellConnected(this.shipBoard[i][j].getTile(), this, this.shipBoard[i][j]);
                    this.shipBoard[i][j].getTile().setWellConnected(temp);
                    if (!temp.booleanValue()) {
                        result = false;
                    }
                }
                if (!this.shipBoard[i][j].getTile().getMyComponent().accept(new ComponentNameVisitor()).equals("ModularHousingUnit")) continue;
                AlienColor al = null;
                ModularHousingUnit temp2 = (ModularHousingUnit)this.shipBoard[i][j].getTile().getMyComponent();
                al = temp2.getAlienColor();
                if (al == AlienColor.EMPTY) continue;
                Boolean result1 = Util.CheckLifeSupportSystem(al, this.shipBoard[i][j].getTile(), this, this.shipBoard[i][j]);
                if (!result1.booleanValue()) {
                    temp2.removeAlienCrew();
                }
                if (result1.booleanValue()) continue;
                result = false;
            }
        }
        return result;
    }

    public ArrayList<Ship> getTronc() {
        ArrayList<Ship> tronconi = new ArrayList<Ship>();
        tronconi.add(this);
        while (!this.brokenPositions.isEmpty()) {
            Position temp = this.brokenPositions.poll();
            int size = tronconi.size();
            boolean bigger = true;
            for (int i = 0; i < tronconi.size() && bigger; ++i) {
                ArrayList<Ship> toRemove = new ArrayList<Ship>();
                ArrayList<Ship> toAdd = new ArrayList<Ship>();
                Ship board = tronconi.get(i);
                if (board == null || board.getShipBoard() == null) {
                    System.err.println("Null board or shipBoard found at index: " + i);
                    continue;
                }
                Slot[][] shipBoard = board.getShipBoard();
                if (shipBoard == null) {
                    System.err.println("WARN: shipBoard is null for board index " + i);
                    continue;
                }
                List<Slot> Slots = Arrays.stream(board.getShipBoard()).flatMap(Arrays::stream).filter(Objects::nonNull).toList();
                for (Slot slot : Slots) {
                    if (slot.getPosition().equals(temp) && slot.getLastAction()) {
                        Position viewPos = new Position(slot.getPosition().getX() + 4, slot.getPosition().getY() + 5);
                        toRemove.add(board);
                        try {
                            toAdd.addAll(this.truncateShip(temp, this.brokenPositions));
                        }
                        catch (InvalidTilePosition e) {
                            System.err.println("Error while computing trunks: " + e.getMessage());
                        }
                        break;
                    }
                    if (!slot.getPosition().equals(temp)) continue;
                    System.out.println("EXTRA");
                }
                tronconi.removeAll(toRemove);
                tronconi.addAll(toAdd);
                if (size == tronconi.size()) {
                    bigger = false;
                }
                size = tronconi.size();
            }
        }
        return tronconi;
    }

    public ArrayList<Ship> truncateShip(Position pos, Queue<Position> brokenPos) throws InvalidTilePosition {
        Position down;
        Position right;
        Position left;
        this.checkShip();
        ArrayList<Pair<ProjectileDirection, Slot>> villagers = new ArrayList<Pair<ProjectileDirection, Slot>>();
        Position up = new Position(pos.getX(), pos.getY() - 1);
        if (!this.invalidPositions.contains(up) && Util.inBoundaries(up.getX(), up.getY()).booleanValue() && this.shipBoard[up.getX()][up.getY()] != null && this.shipBoard[up.getX()][up.getY()].getTile() != null) {
            if (this.shipBoard[up.getX()][up.getY()].getTile().getWellConnected().booleanValue()) {
                villagers.add(new Pair<ProjectileDirection, Slot>(ProjectileDirection.UP, this.shipBoard[up.getX()][up.getY()]));
            } else {
                brokenPos.add(up);
            }
        }
        if (!this.invalidPositions.contains(left = new Position(pos.getX() - 1, pos.getY())) && Util.inBoundaries(left.getX(), left.getY()).booleanValue() && this.shipBoard[left.getX()][left.getY()] != null && this.shipBoard[left.getX()][left.getY()].getTile() != null) {
            if (this.shipBoard[left.getX()][left.getY()].getTile().getWellConnected().booleanValue()) {
                villagers.add(new Pair<ProjectileDirection, Slot>(ProjectileDirection.LEFT, this.shipBoard[left.getX()][left.getY()]));
            } else {
                brokenPos.add(left);
            }
        }
        if (!this.invalidPositions.contains(right = new Position(pos.getX() + 1, pos.getY())) && Util.inBoundaries(right.getX(), right.getY()).booleanValue() && this.shipBoard[right.getX()][right.getY()] != null && this.shipBoard[right.getX()][right.getY()].getTile() != null) {
            if (this.shipBoard[right.getX()][right.getY()].getTile().getWellConnected().booleanValue()) {
                villagers.add(new Pair<ProjectileDirection, Slot>(ProjectileDirection.RIGHT, this.shipBoard[right.getX()][right.getY()]));
            } else {
                brokenPos.add(right);
            }
        }
        if (!this.invalidPositions.contains(down = new Position(pos.getX(), pos.getY() + 1)) && Util.inBoundaries(down.getX(), down.getY()).booleanValue() && this.shipBoard[down.getX()][down.getY()] != null && this.shipBoard[down.getX()][down.getY()].getTile() != null) {
            if (this.shipBoard[down.getX()][down.getY()].getTile().getWellConnected().booleanValue()) {
                villagers.add(new Pair<ProjectileDirection, Slot>(ProjectileDirection.DOWN, this.shipBoard[down.getX()][down.getY()]));
            } else {
                brokenPos.add(down);
            }
        }
        if (!villagers.isEmpty()) {
            ArrayList Nodes = new ArrayList();
            ArrayList<Pair<Integer, ArrayList<Integer>>> nodeLinkedTiles = new ArrayList<Pair<Integer, ArrayList<Integer>>>();
            for (int i = 0; i < villagers.size(); ++i) {
                Nodes.add(new Pair(((Slot)((Pair)villagers.get(i)).getValue()).getTile().getId(), new ArrayList()));
                Tile myTile = ((Slot)((Pair)villagers.get(i)).getValue()).getTile();
                ArrayList<Integer> tilesID = new ArrayList<Integer>();
                Util.visitTile(myTile, tilesID, (Slot)((Pair)villagers.get(i)).getValue(), this.invalidPositions, brokenPos, this);
                nodeLinkedTiles.add(new Pair<Integer, ArrayList<Integer>>(i, new ArrayList<Integer>(tilesID)));
                for (int j = i + 1; j < villagers.size(); ++j) {
                    if (!tilesID.contains(((Slot)((Pair)villagers.get(j)).getValue()).getTile().getId())) continue;
                    ((ArrayList)((Pair)Nodes.get(i)).getValue()).add(((Slot)((Pair)villagers.get(j)).getValue()).getTile().getId());
                }
            }
            ArrayList<ArrayList> equivalenceClasses = new ArrayList<ArrayList>();
            for (int i = 0; i < Nodes.size(); ++i) {
                int finalI = i;
                if (!equivalenceClasses.stream().noneMatch(list -> list.contains(((Pair)Nodes.get(finalI)).getKey()))) continue;
                equivalenceClasses.add((ArrayList)((Pair)nodeLinkedTiles.get(finalI)).getValue());
            }
            int numTronconi = equivalenceClasses.size();
            ArrayList<Ship> ships = new ArrayList<Ship>(numTronconi);
            for (ArrayList equivalenceClass : equivalenceClasses) {
                Ship myShip = new Ship(this.learningMatch);
                Slot[][] myshipBoard = myShip.getShipBoard();
                for (int j = 0; j < 7; ++j) {
                    for (int k = 0; k < 5; ++k) {
                        if (this.shipBoard[j][k].getTile() == null || !equivalenceClass.contains(this.shipBoard[j][k].getTile().getId()) || this.invalidPositions.contains(new Position(j, k))) continue;
                        myShip.putTile(this.shipBoard[j][k].getTile(), this.shipBoard[j][k].getPosition());
                    }
                }
                myShip.cloneStateFrom(this);
                ships.add(myShip);
            }
            return ships;
        }
        ArrayList<Ship> finalShips = new ArrayList<Ship>();
        return finalShips;
    }

    public Boolean activateShield(Position shieldPos, Position batteryPos) {
        if (!this.invalidPositions.contains(shieldPos) && Util.inBoundaries(shieldPos.getX(), shieldPos.getY()).booleanValue() && !this.invalidPositions.contains(batteryPos) && Util.inBoundaries(batteryPos.getX(), batteryPos.getY()).booleanValue()) {
            BatterySlot battery = (BatterySlot)this.getComponentFromPosition(batteryPos);
            Shield shield = (Shield)this.getComponentFromPosition(shieldPos);
            if (battery.getBatteriesLeft() > 0) {
                battery.removeBattery();
                shield.setCharged(true);
                return true;
            }
        }
        return false;
    }

    public Boolean activateDoubleEngine(Position enginePos, Position batteryPos) {
        if (!this.invalidPositions.contains(enginePos) && Util.inBoundaries(enginePos.getX(), enginePos.getY()).booleanValue() && !this.invalidPositions.contains(batteryPos) && Util.inBoundaries(batteryPos.getX(), batteryPos.getY()).booleanValue()) {
            BatterySlot battery = (BatterySlot)this.getComponentFromPosition(batteryPos);
            DoubleEngine engine = (DoubleEngine)this.getComponentFromPosition(enginePos);
            if (battery.getBatteriesLeft() > 0) {
                battery.removeBattery();
                engine.setCharged(true);
                return true;
            }
        }
        return false;
    }

    public Boolean activateDoubleCannon(Position cannonPos, Position batteryPos) {
        if (!this.invalidPositions.contains(cannonPos) && Util.inBoundaries(cannonPos.getX(), cannonPos.getY()).booleanValue() && !this.invalidPositions.contains(batteryPos) && Util.inBoundaries(batteryPos.getX(), batteryPos.getY()).booleanValue()) {
            BatterySlot battery = (BatterySlot)this.getComponentFromPosition(batteryPos);
            DoubleCannon cannon = (DoubleCannon)this.getComponentFromPosition(cannonPos);
            if (battery.getBatteriesLeft() > 0) {
                battery.removeBattery();
                cannon.setCharged(true);
                return true;
            }
        }
        return false;
    }

    public int remainingTiles() {
        int count = 0;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 5; ++j) {
                Tile tile;
                Position pos = new Position(i, j);
                if (this.invalidPositions.contains(pos) || !Util.inBoundaries(i, j).booleanValue() || (tile = this.shipBoard[i][j].getTile()) == null) continue;
                ++count;
            }
        }
        return count;
    }

    public Tile[] getAsideTiles() {
        return this.asideTiles;
    }

    public int calculateEnginePower() {
        ArrayList<Position> enginePos = this.getComponentPositionsFromName("Engine");
        ArrayList<Position> doubleEnginePos = this.getComponentPositionsFromName("DoubleEngine");
        ArrayList<Position> allEnginePos = new ArrayList<Position>();
        allEnginePos.addAll(enginePos);
        allEnginePos.addAll(doubleEnginePos);
        int enginePower = allEnginePos.stream().mapToInt(p -> ((Engine)this.getComponentFromPosition((Position)p)).getEnginePower()).sum();
        if (enginePower != 0) {
            enginePower += this.getNBrownAlien() * 2;
        }
        return enginePower;
    }

    public Component getComponentFromPosition(Position position) {
        Tile tile;
        if (position.getY() >= 0 && position.getX() >= 0 && position.getY() < 5 && position.getX() < 7 && (tile = this.getTileFromPosition(position)) != null) {
            return tile.getMyComponent();
        }
        return null;
    }

    public ArrayList<Position> getComponentPositionsFromName(String componentName) {
        ArrayList<Position> positions = new ArrayList<Position>();
        List<Slot> Slots = Arrays.stream(this.shipBoard).flatMap(Arrays::stream).filter(Objects::nonNull).toList();
        for (Slot slot : Slots) {
            Position p = slot.getPosition();
            Tile tile = slot.getTile();
            if (tile == null || !tile.getMyComponent().accept(new ComponentNameVisitor()).equals(componentName)) continue;
            positions.add(p);
        }
        return positions;
    }

    public Tile getLastTile() {
        return this.lastTile;
    }

    public void setLastTile(Tile tile) {
        this.lastTile = tile;
    }

    public Position getLastTilePosition() {
        return this.lastTilePosition;
    }

    public void setLastTilePosition(Position lastTilePosition) {
        this.lastTilePosition = lastTilePosition;
    }

    public Position getFirstComponentFromDirectionAndIndex(ProjectileDirection direction, int fixedIndex) {
        int step;
        int end;
        if (fixedIndex < 0) {
            return null;
        }
        switch (direction) {
            case UP: 
            case DOWN: {
                if (fixedIndex < 7) break;
                return null;
            }
            case LEFT: 
            case RIGHT: {
                if (fixedIndex < 5) break;
                return null;
            }
        }
        switch (direction) {
            case UP: {
                int start = 0;
                end = 5;
                step = 1;
                break;
            }
            case DOWN: {
                int start = 4;
                end = -1;
                step = -1;
                break;
            }
            case LEFT: {
                int start = 0;
                end = 7;
                step = 1;
                break;
            }
            case RIGHT: {
                int start = 6;
                end = -1;
                step = -1;
                break;
            }
            default: {
                return null;
            }
        }
        for (int i = start; i != end; i += step) {
            Position pos;
            switch (direction) {
                default: {
                    throw new MatchException(null, null);
                }
                case UP: 
                case DOWN: {
                    Position position = new Position(fixedIndex, i);
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    Position position = pos = new Position(i, fixedIndex);
                }
            }
            if (this.getComponentFromPosition(pos) == null) continue;
            return pos;
        }
        return null;
    }

    public Tile getTileFromPosition(Position position) {
        return this.shipBoard[position.getX()][position.getY()].getTile();
    }

    public ArrayList<Pair<Position, Tile>> getConnectedTiles(Position position) {
        Tile tileLeft;
        Tile tileDown;
        Tile tileRight;
        Tile tileUp;
        ArrayList<Pair<Position, Tile>> connectedTilesWithPosition = new ArrayList<Pair<Position, Tile>>();
        int positionX = position.getX();
        int positionY = position.getY();
        int positionUp = position.getY() - 1;
        int positionRight = position.getX() + 1;
        int positionDown = position.getY() + 1;
        int positionLeft = position.getX() - 1;
        if (positionUp >= 0 && (tileUp = this.shipBoard[positionX][positionUp].getTile()) != null) {
            connectedTilesWithPosition.add(new Pair<Position, Tile>(new Position(positionX, positionUp), tileUp));
        }
        if (positionRight < 7 && (tileRight = this.shipBoard[positionRight][positionY].getTile()) != null) {
            connectedTilesWithPosition.add(new Pair<Position, Tile>(new Position(positionRight, positionY), tileRight));
        }
        if (positionDown < 5 && (tileDown = this.shipBoard[positionX][positionDown].getTile()) != null) {
            connectedTilesWithPosition.add(new Pair<Position, Tile>(new Position(positionX, positionDown), tileDown));
        }
        if (positionLeft >= 0 && (tileLeft = this.shipBoard[positionLeft][positionY].getTile()) != null) {
            connectedTilesWithPosition.add(new Pair<Position, Tile>(new Position(positionLeft, positionY), tileLeft));
        }
        return connectedTilesWithPosition;
    }

    public ArrayList<Pair<Position, Tile>> getConnectedHousingUnitTiles(Position position) {
        ComponentNameVisitor componentNameVisitor = new ComponentNameVisitor();
        ArrayList<Pair<Position, Tile>> connected = this.getConnectedTiles(position);
        return this.getConnectedTiles(position).stream().filter(p -> ((Tile)p.getValue()).getMyComponent() != null && (((Tile)p.getValue()).getMyComponent().accept(componentNameVisitor).equals("CentralHousingUnit") || ((Tile)p.getValue()).getMyComponent().accept(componentNameVisitor).equals("ModularHousingUnit"))).collect(Collectors.toCollection(ArrayList::new));
    }

    public Float calculateFirePower() {
        ArrayList<Position> cannonPos = this.getComponentPositionsFromName("Cannon");
        ArrayList<Position> doubleCannonPos = this.getComponentPositionsFromName("DoubleCannon");
        ArrayList<Position> allCannons = new ArrayList<Position>();
        allCannons.addAll(cannonPos);
        allCannons.addAll(doubleCannonPos);
        Float firePower = Float.valueOf((float)allCannons.stream().mapToDouble(p -> ((Cannon)this.getComponentFromPosition((Position)p)).getFirePower().floatValue()).sum());
        if (firePower.floatValue() != 0.0f) {
            firePower = Float.valueOf(firePower.floatValue() + (float)(this.getNPurpleAlien() * 2));
        }
        return firePower;
    }

    public ArrayList<Good> getGoodsOnShipBoard() {
        ArrayList<Good> goods = new ArrayList<Good>();
        ArrayList<Position> genericCargoHoldsPos = this.getComponentPositionsFromName("GenericCargoHolds");
        for (Position p : genericCargoHoldsPos) {
            Component component = this.getComponentFromPosition(p);
            if (!(component instanceof GenericCargoHolds)) continue;
            GenericCargoHolds hold = (GenericCargoHolds)component;
            goods.addAll(hold.getGoods());
        }
        return goods;
    }

    public void addDestroyedTiles(int destroyedTile) {
        this.destroyedTiles = destroyedTile + this.destroyedTiles;
    }

    private void cloneStateFrom(Ship source) {
        if (this.listOfGoods != null) {
            this.listOfGoods = new ArrayList<Pair<Good, Pair<Position, Slot>>>(source.listOfGoods);
        }
        if (this.listNotLoadedGoods != null) {
            this.listNotLoadedGoods = new ArrayList<Good>(source.listNotLoadedGoods);
        }
        this.initialTiles = source.getInitialTiles();
        System.out.println("cloning state from " + source.getClass().getName());
        System.out.println("INITIAL " + this.initialTiles);
    }

    public int getLostTiles() {
        return this.initialTiles - this.remainingTiles();
    }

    public void setInitialTiles(int initialTiles) {
        this.initialTiles = initialTiles;
    }
}

