/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects;

import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.CardContext;
import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects.Utils;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Smugglers;
import it.polimi.ingsw.galaxytrucker.model.essentials.Good;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyManager;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.CollectRewardsRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.CollectRewardsResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.GameMessage;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.ShipUpdate;
import java.util.ArrayList;

public class SmugglersEffect {
    public static void firePowerCheck(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        Smugglers smugglers = (Smugglers)context.getAdventureCard();
        Player player = context.getCurrentPlayer();
        Utils.broadcastGameMessage(context, "Il giocatore " + player.getNickName() + " sta affrontando i Contrabbandieri!");
        Utils.sleepSafe(600L);
        float smugglerFirePower = smugglers.getFirePower();
        float playerFirePower = player.getShip().calculateFirePower().floatValue();
        Utils.resetDoubleCannon(player);
        ShipUpdate shipUpdate = new ShipUpdate(player.getShip(), player.getNickName());
        Utils.broadcast(context, shipUpdate);
        if (smugglerFirePower > playerFirePower) {
            SmugglersEffect.handleSmugglersWin(context, game, player, smugglers);
            context.previousPhase();
        } else {
            if (smugglerFirePower < playerFirePower) {
                context.nextPhase();
                SmugglersEffect.handlePlayerWin(context, game, player);
                return;
            }
            context.previousPhase();
            SmugglersEffect.handleTie(context, game, player);
        }
        if (context.currentPlayerIsLast()) {
            context.goToEndPhase();
        } else {
            context.nextPlayer();
        }
        context.executePhase();
    }

    private static void handleSmugglersWin(CardContext context, LobbyManager game, Player player, Smugglers smugglers) {
        String message;
        game.getPlayerHandlers().get(player.getNickName()).sendMessage(new GameMessage("The Smugglers are going to haunt you!"));
        GameMessage broadcast = new GameMessage(player.getNickName() + " has less FirePower than the Smugglers!");
        Utils.broadcastExcept(context, broadcast, player);
        Utils.sleepSafe(600L);
        ArrayList<Good> removedGoods = Utils.getAndRemoveMostValuableGoods(context, player, smugglers.getPenalty());
        int goodsCount = removedGoods.size();
        int batteryToDiscard = smugglers.getPenalty() - goodsCount;
        if (goodsCount == smugglers.getPenalty()) {
            message = "[Smugglers] Ha ha! We'll steal your " + goodsCount + " most valuable goods!";
        } else if (goodsCount > 0) {
            Utils.removeBatteries(context, player, batteryToDiscard);
            message = "[Smugglers] We'll steal your " + goodsCount + " most valuable good(s) and " + batteryToDiscard + " battery(ies), if you have them.";
        } else {
            Utils.removeBatteries(context, player, batteryToDiscard);
            message = "[Smugglers] You don't have any goods, so we'll steal " + batteryToDiscard + " of your batteries! Well, if you have any, poor fella.";
        }
        GameMessage personalInfo = new GameMessage(message);
        game.getPlayerHandlers().get(player.getNickName()).sendMessage(personalInfo);
    }

    private static void handlePlayerWin(CardContext context, LobbyManager game, Player player) {
        game.getPlayerHandlers().get(player.getNickName()).sendMessage(new GameMessage("You won against the Smugglers!"));
        GameMessage broadcast = new GameMessage(player.getNickName() + " has defeated the Smugglers!");
        Utils.broadcastExcept(context, broadcast, player);
        Utils.sleepSafe(600L);
        CollectRewardsRequest rewardRequest = new CollectRewardsRequest();
        Utils.sendMessage(context, player, rewardRequest);
    }

    private static void handleTie(CardContext context, LobbyManager game, Player player) {
        game.getPlayerHandlers().get(player.getNickName()).sendMessage(new GameMessage("The Smugglers are not going to haunt you!"));
        GameMessage broadcast = new GameMessage("Il giocatore " + player.getNickName() + " ha pareggiato con i Contrabbandieri.");
        Utils.broadcastExcept(context, broadcast, player);
        Utils.sleepSafe(600L);
    }

    public static void receivedRewardsCollectionResponse(CardContext context) {
        CollectRewardsResponse collectRewardsResponse = (CollectRewardsResponse)context.getIncomingNetworkMessage();
        Player player = context.getCurrentPlayer();
        if (collectRewardsResponse.doesWantToCollect()) {
            Utils.broadcastExcept(context, new GameMessage("Player " + player.getNickName() + " scegle di accettare la ricompensa!"), player);
            context.nextPhase();
            Utils.sendMessage(context, player, new ShipUpdate(player.getShip(), player.getNickName()));
            Utils.sleepSafe(600L);
        } else {
            Utils.broadcastExcept(context, new GameMessage("Player " + player.getNickName() + " scegle di  non accettare la ricompensa."), player);
            Utils.sleepSafe(600L);
            if (context.currentPlayerIsLast()) {
                context.goToEndPhase();
            } else {
                context.nextPlayer();
                context.previousPhase(1);
            }
            context.executePhase();
        }
    }

    public static void receivedShipUpdate(CardContext context) {
        Smugglers smugglers = (Smugglers)context.getAdventureCard();
        Utils.movePlayer(context, context.getCurrentPlayer(), -smugglers.getDaysLost());
        context.nextPhase();
        context.executePhase();
    }
}

