/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects;

import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.CardContext;
import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects.Utils;
import it.polimi.ingsw.galaxytrucker.model.Planet;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Planets;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyManager;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.SelectPlanetRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.SelectPlanetResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.SelectedPlanetUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.ShipUpdate;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class PlanetsEffect {
    private static final HashMap<LobbyManager, ArrayList<Player>> landedPlayers = new HashMap();
    private static final HashMap<LobbyManager, Integer> landedPlayerIndex = new HashMap();
    private static final HashMap<LobbyManager, Integer> finishedPlayer = new HashMap();

    public static void sendSelectPlanetRequest(CardContext context) {
        Player player = context.getCurrentPlayer();
        Planets planets = (Planets)context.getAdventureCard();
        HashMap<Integer, Planet> notOccupiedPlanets = new HashMap<Integer, Planet>();
        int i = 1;
        for (Planet planet : planets.getPlanets()) {
            if (!planet.isOccupied()) {
                notOccupiedPlanets.put(i, planet);
            }
            ++i;
        }
        SelectPlanetRequest selectPlanetRequest = new SelectPlanetRequest(notOccupiedPlanets);
        context.nextPhase();
        Utils.broadcastGameMessage(context, "Il giocatore " + player.getNickName() + " sta scegliendo un pianeta...");
        Utils.sleepSafe(100L);
        Utils.sendMessage(context, context.getCurrentPlayer(), selectPlanetRequest);
    }

    public static void receivedSelectPlanetResponse(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        Planets planets = (Planets)context.getAdventureCard();
        SelectPlanetResponse selectPlanetResponse = (SelectPlanetResponse)context.getIncomingNetworkMessage();
        Planet selectedPlanet = selectPlanetResponse.getSelectedPlanet();
        landedPlayers.putIfAbsent(context.getCurrentGame(), new ArrayList());
        if (selectedPlanet != null) {
            planets.getPlanets().get(selectPlanetResponse.getPlanetIndex() - 1).setOccupied(true);
            SelectedPlanetUpdate selectedPlanetUpdate = new SelectedPlanetUpdate(context.getCurrentPlayer().getNickName(), selectedPlanet, selectPlanetResponse.getPlanetIndex());
            Utils.broadcast(context, selectedPlanetUpdate);
            landedPlayers.get(context.getCurrentGame()).add(context.getCurrentPlayer());
        }
        if (!planets.getPlanets().stream().allMatch(Planet::isOccupied) && context.getCurrentPlayer() != context.getCurrentRankedPlayers().getLast()) {
            context.nextPlayer();
            context.previousPhase();
            context.executePhase();
        } else {
            if (landedPlayers.get(game).isEmpty()) {
                context.goToEndPhase();
                context.executePhase();
                return;
            }
            context.nextPhase();
            landedPlayerIndex.putIfAbsent(game, 0);
            context.setCurrentPlayer(landedPlayers.get(game).get(landedPlayerIndex.get(game)));
            context.executePhase();
        }
    }

    public static void sendShipupdate(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        ArrayList<Player> landedPlayersList = landedPlayers.get(game);
        context.nextPhase();
        for (Player p : landedPlayersList) {
            ShipUpdate shipUpdate = new ShipUpdate(p.getShip(), p.getNickName());
            shipUpdate.setLoadMerci(true);
            Utils.sendMessage(context, p, shipUpdate);
        }
    }

    public static void receiveShipUpdate(CardContext context) {
        ShipUpdate shipUpdate = (ShipUpdate)context.getIncomingNetworkMessage();
        LobbyManager game = context.getCurrentGame();
        finishedPlayer.compute(game, (k, v) -> v == null ? 1 : v + 1);
        Utils.broadcast(context, shipUpdate);
        if (landedPlayers.get(game).size() == finishedPlayer.get(game).intValue()) {
            context.nextPhase();
            context.executePhase();
        }
    }

    public static void movePlayers(CardContext context) {
        ArrayList<Player> currentGameLandedPlayers = landedPlayers.get(context.getCurrentGame());
        if (currentGameLandedPlayers != null) {
            Planets planets = (Planets)context.getAdventureCard();
            for (Player player : currentGameLandedPlayers.reversed()) {
                Utils.movePlayer(context, player, -planets.getDaysLost());
            }
            landedPlayers.remove(context.getCurrentGame());
        }
        PlanetsEffect.resetState(context.getCurrentGame());
        context.nextPhase();
        context.executePhase();
    }

    private static void resetState(LobbyManager game) {
        landedPlayers.remove(game);
        landedPlayerIndex.remove(game);
        finishedPlayer.remove(game);
    }
}

