/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects;

import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.CardContext;
import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects.Utils;
import it.polimi.ingsw.galaxytrucker.enums.PlayerLostReason;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyManager;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.ShipUpdate;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class OpenSpaceEffect {
    private static final HashMap<LobbyManager, HashMap<String, Integer>> playerToPowerMapPerGame = new HashMap();
    private static final HashMap<LobbyManager, ArrayList<Player>> originRankedPlayers = new HashMap();
    private static final HashMap<LobbyManager, Integer> playerIndex = new HashMap();

    public static void doubleEnginesActivated(CardContext context) {
        HashMap<Object, Object> playerToPowerMap;
        LobbyManager game = context.getCurrentGame();
        Player player = context.getCurrentPlayer();
        int playerEnginePower = player.getShip().calculateEnginePower();
        if (playerToPowerMapPerGame.get(game) != null) {
            playerToPowerMap = playerToPowerMapPerGame.get(game);
        } else {
            playerToPowerMap = new HashMap();
            playerToPowerMapPerGame.put(game, playerToPowerMap);
        }
        playerToPowerMap.put(player.getNickName(), playerEnginePower);
        playerToPowerMapPerGame.put(game, playerToPowerMap);
        originRankedPlayers.computeIfAbsent(game, k -> context.getCurrentRankedPlayers());
        playerIndex.computeIfAbsent(game, k -> 0);
        Utils.movePlayer(context, player, playerEnginePower);
        Utils.resetDoubleEngine(player);
        ShipUpdate shipUpdate = new ShipUpdate(player.getShip(), player.getNickName());
        Utils.broadcast(context, shipUpdate);
        if (player == originRankedPlayers.get(game).getLast()) {
            context.nextPhase();
        } else {
            playerIndex.put(game, playerIndex.get(game) + 1);
            int nextPlayerIndex = playerIndex.get(game);
            context.setCurrentPlayer(originRankedPlayers.get(game).get(nextPlayerIndex));
            context.previousPhase();
        }
        context.executePhase();
    }

    public static void finalCheck(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        HashMap<String, Integer> playerToPowerMap = playerToPowerMapPerGame.get(game);
        playerToPowerMap.forEach((nickname, power) -> {
            if (power == 0) {
                Utils.broadcastGameMessage(context, "Il giocatore " + nickname + " \u00e8 stato eliminato per potenza motrice pari a zero!");
                Utils.sleepSafe(600L);
                game.getGameController().removePlayerFromGame((String)nickname, PlayerLostReason.ZeroEnginePower);
            }
        });
        OpenSpaceEffect.resetState(game);
        context.nextPhase();
        context.executePhase();
    }

    private static void resetState(LobbyManager game) {
        playerToPowerMapPerGame.remove(game);
        originRankedPlayers.remove(game);
        playerIndex.remove(game);
    }
}

