/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects;

import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.CardContext;
import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects.Utils;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.AbandonedStation;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.ActivateAdventureCardRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.ActivateAdventureCardResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.ShipUpdate;

public abstract class AbandonedStationEffect {
    public static void start(CardContext context) {
        Player player = context.getCurrentPlayer();
        AbandonedStation abandonedStation = (AbandonedStation)context.getAdventureCard();
        if (player.getShip().getnCrew() >= abandonedStation.getRequiredCrewMembers()) {
            Utils.broadcastGameMessage(context, "Il giocatore " + player.getNickName() + "ha abbastanza membri dell'equipaggio e sta decidendo se raccogliere la ricompensa...");
            Utils.sleepSafe(600L);
            context.nextPhase();
            Utils.sendMessage(context, player, new ActivateAdventureCardRequest());
        } else {
            Utils.broadcastGameMessage(context, player.getNickName() + " non ha abbastanza membri dell'equipaggio per attivare questa carta.");
            Utils.sleepSafe(600L);
            if (context.currentPlayerIsLast()) {
                context.goToEndPhase();
            } else {
                context.nextPlayer();
            }
            context.executePhase();
        }
    }

    public static void receivedCardActivationResponse(CardContext context) {
        ActivateAdventureCardResponse activateAdventureCardResponse = (ActivateAdventureCardResponse)context.getIncomingNetworkMessage();
        Player currentPlayer = context.getCurrentPlayer();
        if (activateAdventureCardResponse.isActivated()) {
            Utils.broadcastGameMessage(context, "Il giocatore " + currentPlayer.getNickName() + " ha accettato la ricompensa. In attesa che carichi la propria astronave...");
            context.nextPhase();
            Utils.sendMessage(context, context.getCurrentPlayer(), new ShipUpdate(context.getCurrentPlayer().getShip(), context.getCurrentPlayer().getNickName()));
            Utils.sleepSafe(600L);
        } else {
            Utils.broadcastGameMessage(context, "Il giocatore " + currentPlayer.getNickName() + " rifiuta di attivare l'effetto della carta.");
            Utils.sleepSafe(600L);
            if (context.currentPlayerIsLast()) {
                context.goToEndPhase();
            } else {
                context.resetFSM();
                context.nextPlayer();
            }
            context.executePhase();
        }
    }

    public static void moveCurrentPlayer(CardContext context) {
        AbandonedStation abandonedStation = (AbandonedStation)context.getAdventureCard();
        Utils.broadcastGameMessage(context, "Il giocatore " + context.getCurrentPlayer().getNickName() + " deve muoversi indietro di " + context.getAdventureCard().getDaysLost() + " caselle.");
        Utils.sleepSafe(600L);
        Utils.movePlayer(context, context.getCurrentPlayer(), -abandonedStation.getDaysLost());
        context.nextPhase();
        context.executePhase();
    }
}

