/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller;

import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.CardContext;
import it.polimi.ingsw.galaxytrucker.enums.Color;
import it.polimi.ingsw.galaxytrucker.enums.Connector;
import it.polimi.ingsw.galaxytrucker.enums.GameState;
import it.polimi.ingsw.galaxytrucker.enums.PlayerLostReason;
import it.polimi.ingsw.galaxytrucker.enums.PlayerState;
import it.polimi.ingsw.galaxytrucker.enums.ProjectileDirection;
import it.polimi.ingsw.galaxytrucker.enums.ProjectileSize;
import it.polimi.ingsw.galaxytrucker.enums.ProjectileType;
import it.polimi.ingsw.galaxytrucker.model.FlightBoard;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.model.PlayerScore;
import it.polimi.ingsw.galaxytrucker.model.Projectile;
import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.AdventureCard;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.CardDeck;
import it.polimi.ingsw.galaxytrucker.model.essentials.Good;
import it.polimi.ingsw.galaxytrucker.model.essentials.Position;
import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Cannon;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.DoubleCannon;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Shield;
import it.polimi.ingsw.galaxytrucker.model.game.Game;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyManager;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.DrawnAdventureCardUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.EndTurnUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.FlightBoardUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.GameEndUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.MatchInfoUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.PlayerKickedUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.PlayerLostUpdate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class GameController {
    private GameState gameState;
    private final LobbyManager game;
    private int nCompletedShips = 0;
    final Object ncsLock = new Object();
    private CardDeck cardDeckTest = new CardDeck(true);
    private CardContext currentCardContext;
    private boolean gameAlreadyEnded;
    private CardDeck flightDeck;
    private final Object gameStateLock = new Object();

    public CardContext getCurrentCardContext() {
        return this.currentCardContext;
    }

    public CardDeck getCardDeckTest() {
        return this.cardDeckTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getnCompletedShips() {
        Object object = this.ncsLock;
        synchronized (object) {
            return this.nCompletedShips;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletedShip() {
        Object object = this.ncsLock;
        synchronized (object) {
            ++this.nCompletedShips;
        }
    }

    public GameController(LobbyManager game) {
        this.game = game;
        this.gameState = GameState.LOBBY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GameState getGameState() {
        Object object = this.gameStateLock;
        synchronized (object) {
            return this.gameState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextState() {
        Object object = this.gameStateLock;
        synchronized (object) {
            switch (this.gameState) {
                case LOBBY: {
                    this.gameState = GameState.BUILDING_START;
                    break;
                }
                case BUILDING_START: {
                    this.gameState = GameState.BUILDING_END;
                    break;
                }
                case BUILDING_END: {
                    this.gameState = GameState.SHIP_CHECK;
                    break;
                }
                case SHIP_CHECK: {
                    this.gameState = GameState.CREW_INIT;
                    break;
                }
                case CREW_INIT: {
                    this.gameState = GameState.FLIGHT;
                }
            }
        }
    }

    public void startFlight() throws ExecutionException, InterruptedException, IOException {
        this.flightDeck = this.game.getRealGame().createFlightDeck(this.game.getRealGame().getDecks());
        this.game.getRealGame().getPlayers().forEach(player -> player.setPlayerState(PlayerState.Playing));
    }

    public void sendMatchInfoUpdate() {
        ArrayList<Player> rankedPlayers = this.getRankedPlayers();
        MatchInfoUpdate miu = !rankedPlayers.isEmpty() ? new MatchInfoUpdate(rankedPlayers.getFirst().getNickName(), this.flightDeck.getSize()) : new MatchInfoUpdate("", 0);
        this.game.getPlayerHandlers().values().forEach(ch -> ch.sendMessage(miu));
    }

    public void handleTurn() {
        CardContext context;
        AdventureCard drawnAdventureCard = this.flightDeck.pop();
        if (this.getPlayingPlayers().size() == 1) {
            while (drawnAdventureCard.getName().equals("Zona Guerra")) {
                drawnAdventureCard = this.getCardDeckTest().pop();
            }
        }
        DrawnAdventureCardUpdate drawnAdventureCardUpdate = new DrawnAdventureCardUpdate(drawnAdventureCard);
        this.game.getPlayerHandlers().values().forEach(ch -> ch.sendMessage(drawnAdventureCardUpdate));
        this.currentCardContext = context = new CardContext(this.game, drawnAdventureCard);
        context.executePhase();
    }

    public void handleEndTurn() {
        this.clearPlayersWithNoCrew();
        this.clearLappedPlayers();
        EndTurnUpdate etu = new EndTurnUpdate();
        if (this.game.getRealGame().getFlightBoard().getRankedPlayers().isEmpty() || this.flightDeck.getSize() == 0) {
            etu.setEndGame(true);
            this.game.getPlayerHandlers().values().forEach(ch -> ch.sendMessage(etu));
            if (!this.gameAlreadyEnded) {
                this.gameAlreadyEnded = true;
                this.handleEndGame();
            }
            return;
        }
        etu.setEndGame(false);
        this.game.getPlayerHandlers().values().forEach(ch -> ch.sendMessage(etu));
        this.game.resetReadyPlayers();
        this.currentCardContext = null;
    }

    public void handleEndGame() {
        List<PlayerScore> scores = this.calculateScores();
        GameEndUpdate geu = new GameEndUpdate(new ArrayList<PlayerScore>(scores));
        this.game.getPlayerHandlers().values().forEach(ch -> ch.sendMessage(geu));
    }

    public List<PlayerScore> calculateScores() {
        ArrayList<Player> players = this.game.getRealGame().getPlayers();
        int minExposed = players.stream().mapToInt(p -> p.getShip().getnExposedConnector()).min().orElse(Integer.MAX_VALUE);
        return players.stream().map(player -> {
            int bestLooking = player.getShip().getnExposedConnector() == minExposed && this.getRankedPlayers().contains(player) ? 2 : 0;
            int finishOrder = this.calculateFinishOrderScore((Player)player);
            double reward = this.calculateGoodRewardScore((Player)player);
            int losses = this.calculateLossesScore((Player)player);
            int credits = player.getNCredits();
            return new PlayerScore(player.getNickName(), bestLooking, finishOrder, reward, losses, credits);
        }).sorted(Comparator.comparingDouble(PlayerScore::getTotalScore).reversed()).toList();
    }

    private int calculateFinishOrderScore(Player player) {
        int score = 0;
        ArrayList<Player> activePlayers = this.getRankedPlayers();
        if (activePlayers.contains(player)) {
            int playerIndex = activePlayers.indexOf(player);
            int nPlayers = this.game.getRealGame().getPlayers().size();
            score = nPlayers - playerIndex;
        }
        return score;
    }

    private float calculateGoodRewardScore(Player player) {
        ArrayList<Good> goods = player.getShip().getGoodsOnShipBoard();
        float score = 0.0f;
        for (Good good : goods) {
            score += (float)good.getValue();
        }
        if (PlayerState.Spectating.equals((Object)player.getPlayerState())) {
            float tmpScore = score * 0.5f;
            return (float)Math.ceil(tmpScore);
        }
        return score;
    }

    private int calculateLossesScore(Player player) {
        int score = 0;
        int numToAdd = 0;
        Ship ship = player.getShip();
        for (Tile t : ship.getAsideTiles()) {
            if (t == null) continue;
            ++numToAdd;
        }
        int LossesScore = player.getShip().getLostTiles();
        return score += LossesScore + numToAdd;
    }

    public void removePlayerFromGame(String nickname, PlayerLostReason reason) {
        this.game.getRealGame().getPlayer(nickname).setPlayerState(PlayerState.Spectating);
        this.game.getRealGame().getFlightBoard().removePlayer(this.game.getPlayerColors().get(nickname));
        FlightBoardUpdate fbu = new FlightBoardUpdate(this.game.getRealGame().getFlightBoard());
        PlayerLostUpdate plu = new PlayerLostUpdate(nickname, reason);
        this.game.getPlayerHandlers().values().forEach(ch -> {
            ch.sendMessage(plu);
            ch.sendMessage(fbu);
        });
        if (this.game.getRealGame().getFlightBoard().getRankedPlayers().isEmpty() && !this.gameAlreadyEnded) {
            this.gameAlreadyEnded = true;
            this.handleEndGame();
        }
    }

    public void kickPlayerFromGame(String nickname) {
        FlightBoardUpdate fbu;
        this.game.getPlayerColors().remove(nickname);
        Game realGame = this.game.getRealGame();
        FlightBoard flightBoard = realGame.getFlightBoard();
        realGame.removePlayer(nickname);
        if (flightBoard == null) {
            fbu = null;
        } else {
            flightBoard.removePlayer(this.game.getPlayerColors().get(nickname));
            fbu = new FlightBoardUpdate(this.game.getRealGame().getFlightBoard());
        }
        PlayerKickedUpdate pku = new PlayerKickedUpdate(nickname);
        this.game.getPlayerHandlers().values().forEach(ch -> {
            ch.sendMessage(pku);
            if (fbu != null) {
                ch.sendMessage(fbu);
            }
        });
        this.game.removePlayerHandler(nickname);
        if (this.game.getRealGame().getFlightBoard().getRankedPlayers().isEmpty()) {
            // empty if block
        }
    }

    public Tile reactToProjectile(Player targetPlayer, Projectile projectile, int diceRoll) {
        Ship ship = targetPlayer.getShip();
        Position pos = ship.getFirstComponentFromDirectionAndIndex(projectile.getDirection(), diceRoll);
        if (pos == null) {
            return null;
        }
        Tile destroyedTile = null;
        if (projectile.getType() == ProjectileType.CannonFire) {
            if (projectile.getSize() == ProjectileSize.Big) {
                destroyedTile = ship.getTileFromPosition(pos);
                ship.removeTile(pos, false);
            } else if (projectile.getSize() == ProjectileSize.Little && !this.protectWithFirstAvailableCorrectlyOrientedChargedShield(ship, projectile.getDirection())) {
                destroyedTile = ship.getTileFromPosition(pos);
                ship.removeTile(pos, false);
            }
        } else if (projectile.getType() == ProjectileType.Meteor) {
            if (projectile.getSize() == ProjectileSize.Big) {
                if (!this.protectWithFirstAvailableCannon(ship, projectile.getDirection(), diceRoll)) {
                    destroyedTile = ship.getTileFromPosition(pos);
                    ship.removeTile(pos, false);
                }
            } else if (projectile.getSize() == ProjectileSize.Little) {
                ArrayList<Connector> tileConnectors = ship.getShipBoard()[pos.getX()][pos.getY()].getTile().getSides();
                int index = -1;
                switch (projectile.getDirection()) {
                    case UP: {
                        index = 0;
                        break;
                    }
                    case RIGHT: {
                        index = 1;
                        break;
                    }
                    case DOWN: {
                        index = 2;
                        break;
                    }
                    case LEFT: {
                        index = 3;
                    }
                }
                if (tileConnectors.get(index) != Connector.EMPTY && !this.protectWithFirstAvailableCorrectlyOrientedChargedShield(ship, projectile.getDirection())) {
                    destroyedTile = ship.getTileFromPosition(pos);
                    ship.removeTile(pos, false);
                }
            }
        }
        return destroyedTile;
    }

    private boolean protectWithFirstAvailableCannon(Ship ship, ProjectileDirection direction, int diceRoll) {
        for (Position cannonPos : ship.getComponentPositionsFromName("Cannon")) {
            Cannon cannon = (Cannon)ship.getComponentFromPosition(cannonPos);
            ProjectileDirection directionCannon = ProjectileDirection.fromRotation(cannon.getRotation());
            if (!(direction.equals((Object)ProjectileDirection.UP) ? directionCannon.equals((Object)ProjectileDirection.UP) && diceRoll == cannonPos.getX() : (direction.equals((Object)ProjectileDirection.DOWN) ? directionCannon.equals((Object)ProjectileDirection.DOWN) && Math.abs(cannonPos.getX() - diceRoll) <= 1 : directionCannon.equals((Object)direction) && Math.abs(cannonPos.getY() - diceRoll) <= 1))) continue;
            return true;
        }
        for (Position cannonPos : ship.getComponentPositionsFromName("DoubleCannon")) {
            DoubleCannon doubleCannon = (DoubleCannon)ship.getComponentFromPosition(cannonPos);
            ProjectileDirection directionDoubleCannon = ProjectileDirection.fromRotation(doubleCannon.getRotation());
            if (!doubleCannon.isCharged().booleanValue()) continue;
            if (direction.equals((Object)ProjectileDirection.UP)) {
                if (!directionDoubleCannon.equals((Object)ProjectileDirection.UP) || diceRoll != cannonPos.getX()) continue;
                doubleCannon.setCharged(false);
                return true;
            }
            if (direction.equals((Object)ProjectileDirection.DOWN)) {
                if (!directionDoubleCannon.equals((Object)ProjectileDirection.DOWN) || Math.abs(cannonPos.getX() - diceRoll) > 1) continue;
                doubleCannon.setCharged(false);
                return true;
            }
            if (!directionDoubleCannon.equals((Object)direction) || Math.abs(cannonPos.getY() - diceRoll) > 1) continue;
            doubleCannon.setCharged(false);
            return true;
        }
        return false;
    }

    private boolean protectWithFirstAvailableCorrectlyOrientedChargedShield(Ship ship, ProjectileDirection direction) {
        for (Position shieldPos : ship.getComponentPositionsFromName("Shield")) {
            Shield shield = (Shield)ship.getComponentFromPosition(shieldPos);
            if (!shield.isCharged().booleanValue() || !shield.getProtectedSides().contains((Object)direction)) continue;
            shield.setCharged(false);
            return true;
        }
        return false;
    }

    public ArrayList<Player> getRankedPlayers() {
        ArrayList<Color> rankedColors = this.game.getRealGame().getFlightBoard().getRankedPlayers();
        ArrayList<Player> rankedPlayers = new ArrayList<Player>();
        for (Color color : rankedColors) {
            String nickname = this.game.getNicknameFromColor(color);
            Player player = this.game.getRealGame().getPlayer(nickname);
            if (player == null || player.getPlayerState() != PlayerState.Playing) continue;
            rankedPlayers.add(player);
        }
        return rankedPlayers;
    }

    public List<Player> getPlayingPlayers() {
        return this.game.getRealGame().getPlayers().stream().filter(p -> p.getPlayerState() == PlayerState.Playing).toList();
    }

    public void clearPlayersWithNoCrew() {
        for (Player player : this.getPlayingPlayers()) {
            Ship ship = player.getShip();
            int nCrewAndAlien = ship.getnCrew();
            int nCrew = nCrewAndAlien - ship.getNBrownAlien() - ship.getNPurpleAlien();
            if (nCrew != 0) continue;
            this.removePlayerFromGame(player.getNickName(), PlayerLostReason.NoCrewMembersLeft);
        }
    }

    public void clearLappedPlayers() {
        for (Color color : this.game.getRealGame().getFlightBoard().getRankedPlayers()) {
            if (!this.game.getRealGame().getFlightBoard().isPlayerLapped(color).booleanValue()) continue;
            this.removePlayerFromGame(this.game.getNicknameFromColor(color), PlayerLostReason.Lapped);
        }
    }

    public CardDeck getFlightDeck() {
        return this.flightDeck;
    }
}

