/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.visitors.adventurecards;

import it.polimi.ingsw.galaxytrucker.enums.ProjectileDirection;
import it.polimi.ingsw.galaxytrucker.enums.ProjectileSize;
import it.polimi.ingsw.galaxytrucker.model.Planet;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.AbandonedShip;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.AbandonedStation;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.CombatZone;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Epidemic;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.MeteorSwarm;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.OpenSpace;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Pirates;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Planets;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Slavers;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Smugglers;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Stardust;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.TuiColor;
import it.polimi.ingsw.galaxytrucker.visitors.adventurecards.AdventureCardVisitorsInterface;
import java.util.ArrayList;

public class AdventureCardPrintVisitor
implements AdventureCardVisitorsInterface<String[]> {
    @Override
    public String[] visit(AbandonedShip card) {
        String[] result = new String[]{"\u250c----------------\u2510", "|   Abb. Ship    |", "|                |", "|  -" + card.getRequiredCrewMembers() + " Crew       |", "|                |", "|  +" + card.getCredits() + " Credit     |", "|                |", "|                |", "\u2514----------------\u2518"};
        return this.AddLvLearningDaysLost(result, card.getLevel(), card.isLearningFlight(), card.getDaysLost());
    }

    @Override
    public String[] visit(AbandonedStation card) {
        String[] result = new String[]{"\u250c----------------\u2510", "|  Abb. Station  |", "|                |", "|  Crew: " + card.getRequiredCrewMembers() + "       |", "|                |", "|  Merci:              |", "|                |", "|                |", "\u2514----------------\u2518"};
        StringBuilder sb = new StringBuilder();
        sb.append("| Merci: ");
        int j = 0;
        block7: for (j = 0; j < card.getGoods().size(); ++j) {
            switch (card.getGoods().get(j).getColor()) {
                case RED: {
                    sb.append((Object)TuiColor.RED).append("\u2588").append((Object)TuiColor.RESET);
                    continue block7;
                }
                case BLUE: {
                    sb.append((Object)TuiColor.BLUE).append("\u2588").append((Object)TuiColor.RESET);
                    continue block7;
                }
                case GREEN: {
                    sb.append((Object)TuiColor.GREEN).append("\u2588").append((Object)TuiColor.RESET);
                    continue block7;
                }
                case YELLOW: {
                    sb.append((Object)TuiColor.BRIGHT_YELLOW).append("\u2588").append((Object)TuiColor.RESET);
                    continue block7;
                }
                case EMPTY: {
                    sb.append(" ");
                }
            }
        }
        int spazi = 8 - j;
        for (j = 0; j < spazi; ++j) {
            sb.append(" ");
        }
        sb.append("|");
        result[5] = sb.toString();
        return this.AddLvLearningDaysLost(result, card.getLevel(), card.isLearningFlight(), card.getDaysLost());
    }

    @Override
    public String[] visit(CombatZone card) {
        String[] result = card.getLevel() == 1 ? new String[]{"\u250c----------------\u2510", "|  Combat zone  1|", "|                |", "| \u2193Crew  -3gg    |", "| \u2193EngP  -2Crew  |", "| \u2193FirP   \u2022 \u2191    |", "|         \u25cf \u2191    |", "| L              |", "\u2514----------------\u2518"} : new String[]{"\u250c----------------\u2510", "|  Combat zone  2|", "|                |", "| \u2193FirP  -4gg    |", "| \u2193EngP  -3Merci |", "| \u2193Crew  \u2022 \u2193 \u2192 \u2190 |", "|        \u25cf \u2191     |", "|                |", "\u2514----------------\u2518"};
        return result;
    }

    @Override
    public String[] visit(Epidemic card) {
        String[] result = new String[]{"\u250c----------------\u2510", "|    Epidemic    |", "|     \u2554\u2550\u2550\u2550\u2550\u2550\u2557    |", "|     \u2551 o X \u2551    |", "|     \u255a\u2566\u2550\u2566\u2550\u2566\u255d    |", "|     \u2554\u2569\u2550\u2550\u2550\u2569\u2557    |", "|     \u2551 o X \u2551    |", "|     \u255a\u2550\u2550\u2550\u2550\u2550\u255d    |", "\u2514----------------\u2518"};
        return this.AddLvLearningDaysLost(result, card.getLevel(), card.isLearningFlight(), card.getDaysLost());
    }

    @Override
    public String[] visit(MeteorSwarm card) {
        int j;
        String[] result = new String[]{"\u250c----------------\u2510", "|    Meteors     |", "|                |", "|                |", "|                |", "|                |", "|                |", "|                |", "\u2514----------------\u2518"};
        int Line2 = 2;
        boolean DoubleLinePrec = false;
        ProjectileDirection PrecKind = null;
        int occupied = 0;
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (int i = 0; i < card.getMeteors().size(); ++i) {
            int spazi;
            if (card.getMeteors().get(i).getDirection() == ProjectileDirection.UP || card.getMeteors().get(i).getDirection() == ProjectileDirection.DOWN) {
                if (i == 0) {
                    sb.append("|      ");
                    sb2.append("|      ");
                    occupied = 8;
                }
                if (PrecKind != null && PrecKind != card.getMeteors().get(i).getDirection()) {
                    spazi = 18 - occupied;
                    for (j = 0; j < spazi; ++j) {
                        sb.append(" ");
                    }
                    sb.append("|");
                    if (DoubleLinePrec) {
                        for (j = 0; j < spazi; ++j) {
                            sb2.append(" ");
                        }
                        sb2.append("|");
                        result[Line2] = sb.toString();
                        result[Line2 + 1] = sb2.toString();
                        Line2 += 2;
                    } else {
                        result[Line2] = sb.toString();
                        ++Line2;
                    }
                    sb = new StringBuilder();
                    sb2 = new StringBuilder();
                    sb.append("|      ");
                    sb2.append("|      ");
                    occupied = 8;
                }
                occupied += 2;
                DoubleLinePrec = true;
                if (card.getMeteors().get(i).getDirection() == ProjectileDirection.UP) {
                    sb.append("\u2193 ");
                    if (card.getMeteors().get(i).getSize() == ProjectileSize.Big) {
                        sb2.append("\u25cf ");
                    } else {
                        sb2.append("\u2022 ");
                    }
                } else {
                    sb2.append("\u2191 ");
                    if (card.getMeteors().get(i).getSize() == ProjectileSize.Big) {
                        sb.append("\u25cf ");
                    } else {
                        sb.append("\u2022 ");
                    }
                }
                PrecKind = card.getMeteors().get(i).getDirection();
                continue;
            }
            if (i == 0) {
                if (card.getMeteors().get(i).getDirection() == ProjectileDirection.LEFT) {
                    sb.append("| ");
                    occupied = 2;
                } else {
                    sb.append("|           ");
                    occupied = 12;
                }
            }
            if (PrecKind != null) {
                spazi = 18 - occupied;
                for (j = 0; j < spazi; ++j) {
                    sb.append(" ");
                }
                sb.append("|");
                if (DoubleLinePrec) {
                    for (j = 0; j < spazi; ++j) {
                        sb2.append(" ");
                    }
                    sb2.append("|");
                    result[Line2] = sb.toString();
                    result[Line2 + 1] = sb2.toString();
                    Line2 += 2;
                } else {
                    result[Line2] = sb.toString();
                    ++Line2;
                }
                sb = new StringBuilder();
                if (card.getMeteors().get(i).getDirection() == ProjectileDirection.LEFT) {
                    sb.append("| ");
                    occupied = 2;
                } else {
                    sb.append("|           ");
                    occupied = 12;
                }
            }
            occupied += 4;
            DoubleLinePrec = false;
            if (card.getMeteors().get(i).getDirection() == ProjectileDirection.LEFT) {
                sb.append("\u2192 ");
                if (card.getMeteors().get(i).getSize() == ProjectileSize.Big) {
                    sb.append("\u25cf");
                    continue;
                }
                sb.append("\u2022");
                continue;
            }
            if (card.getMeteors().get(i).getSize() == ProjectileSize.Big) {
                sb.append("\u25cf");
            } else {
                sb.append("\u2022");
            }
            sb.append(" \u2190");
        }
        int spazi = 18 - occupied;
        for (j = 0; j < spazi; ++j) {
            sb.append(" ");
        }
        sb.append("|");
        if (DoubleLinePrec) {
            for (j = 0; j < spazi; ++j) {
                sb2.append(" ");
            }
            sb2.append("|");
            result[Line2] = sb.toString();
            result[Line2 + 1] = sb2.toString();
        } else {
            result[Line2] = sb.toString();
        }
        return this.AddLvLearningDaysLost(result, card.getLevel(), card.isLearningFlight(), card.getDaysLost());
    }

    @Override
    public String[] visit(OpenSpace card) {
        String[] result = new String[]{"\u250c----------------\u2510", "|   Open Space   |", "|                |", "|  1EngP = +1gg  |", "|      \u2554\u2566\u2566\u2557      |", "|     \u2554\u2551\u2551\u2551\u2551\u2557     |", "|     \u2588\u2588\u2588\u2588\u2588\u2588     |", "|      \u2591\u2591\u2591\u2591      |", "\u2514----------------\u2518"};
        return this.AddLvLearningDaysLost(result, card.getLevel(), card.isLearningFlight(), card.getDaysLost());
    }

    @Override
    public String[] visit(Pirates card) {
        String[] result = card.getLevel() == 1 ? new String[]{"\u250c----------------\u2510", "|     Pirati    1|", "|                |", "| FireP:     5   |", "| L:     \u2193 \u2193 \u2193   |", "|        \u2022 \u25cf \u2022   |", "| W:   +4 credit |", "| L      Dlost:1 |", "\u2514----------------\u2518"} : new String[]{"\u250c----------------\u2510", "|     Pirati    2|", "|                |", "| FireP:     6   |", "| L:     \u2193 \u2193 \u2193   |", "|        \u25cf \u2022 \u25cf   |", "| W:   +7 credit |", "|        Dlost:2 |", "\u2514----------------\u2518"};
        return result;
    }

    @Override
    public String[] visit(Planets card) {
        String[] result = new String[]{"\u250c----------------\u2510", "|    Planets     |", "|                |", "|                |", "|                |", "|                |", "|                |", "|                |", "\u2514----------------\u2518"};
        ArrayList<Object> planets = new ArrayList();
        planets = card.getPlanets();
        for (int i = 0; i < planets.size(); ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append("|P").append(i + 1).append(": ");
            int j = 0;
            block8: for (j = 0; j < ((Planet)planets.get(i)).getGoods().size(); ++j) {
                switch (((Planet)planets.get(i)).getGoods().get(j).getColor()) {
                    case RED: {
                        sb.append((Object)TuiColor.RED).append("\u2588").append((Object)TuiColor.RESET);
                        continue block8;
                    }
                    case BLUE: {
                        sb.append((Object)TuiColor.BLUE).append("\u2588").append((Object)TuiColor.RESET);
                        continue block8;
                    }
                    case GREEN: {
                        sb.append((Object)TuiColor.GREEN).append("\u2588").append((Object)TuiColor.RESET);
                        continue block8;
                    }
                    case YELLOW: {
                        sb.append((Object)TuiColor.BRIGHT_YELLOW).append("\u2588").append((Object)TuiColor.RESET);
                        continue block8;
                    }
                    case EMPTY: {
                        sb.append(" ");
                    }
                }
            }
            int spazi = 12 - j;
            for (j = 0; j < spazi; ++j) {
                sb.append(" ");
            }
            sb.append("|");
            result[i + 3] = sb.toString();
        }
        return this.AddLvLearningDaysLost(result, card.getLevel(), card.isLearningFlight(), card.getDaysLost());
    }

    @Override
    public String[] visit(Slavers card) {
        String[] result = new String[]{"\u250c----------------\u2510", "|    Slavers     |", "|                |", "| FireP:    " + card.getFirePower() + "    |", "| L: -" + card.getPenalty() + " Crew     |", "| W: +" + card.getCredits() + " Credit   |", "|                |", "|                |", "\u2514----------------\u2518"};
        return this.AddLvLearningDaysLost(result, card.getLevel(), card.isLearningFlight(), card.getDaysLost());
    }

    @Override
    public String[] visit(Smugglers card) {
        String[] result = new String[]{"\u250c----------------\u2510", "|   Smugglers    |", "|                |", "| FireP:  " + card.getFirePower() + "      |", "| L: -" + card.getPenalty() + " Merci    |", "| W:              |", "|                |", "|                |", "\u2514----------------\u2518"};
        StringBuilder sb = new StringBuilder();
        sb.append("| W: ");
        int j = 0;
        block7: for (j = 0; j < card.getGoods().size(); ++j) {
            switch (card.getGoods().get(j).getColor()) {
                case RED: {
                    sb.append((Object)TuiColor.RED).append("\u2588").append((Object)TuiColor.RESET);
                    continue block7;
                }
                case BLUE: {
                    sb.append((Object)TuiColor.BLUE).append("\u2588").append((Object)TuiColor.RESET);
                    continue block7;
                }
                case GREEN: {
                    sb.append((Object)TuiColor.GREEN).append("\u2588").append((Object)TuiColor.RESET);
                    continue block7;
                }
                case YELLOW: {
                    sb.append((Object)TuiColor.BRIGHT_YELLOW).append("\u2588").append((Object)TuiColor.RESET);
                    continue block7;
                }
                case EMPTY: {
                    sb.append(" ");
                }
            }
        }
        int spazi = 12 - j;
        for (j = 0; j < spazi; ++j) {
            sb.append(" ");
        }
        sb.append("|");
        result[5] = sb.toString();
        return this.AddLvLearningDaysLost(result, card.getLevel(), card.isLearningFlight(), card.getDaysLost());
    }

    @Override
    public String[] visit(Stardust card) {
        String[] result = new String[]{"\u250c----------------\u2510", "|    Stardust    |", "|                |", "| -1gg x expConn |", "|     \u2554\u2550\u2566\u2550\u2550\u2557     |", "|     \u2560\u2557\u255a\u2550\u2557\u2560\u2550 -1 |", "|     \u2560\u2569\u2550\u2550\u2569\u2563     |", "| -1 \u2550\u2569\u2550\u2550\u2550\u2550\u2569\u2550 -1 |", "\u2514----------------\u2518"};
        return this.AddLvLearningDaysLost(result, card.getLevel(), card.isLearningFlight(), card.getDaysLost());
    }

    private String[] AddLvLearningDaysLost(String[] res, int lv, boolean learning, int daysLost) {
        StringBuilder sb = new StringBuilder(res[7]);
        if (learning) {
            sb.replace(2, 3, "L");
        }
        if (daysLost != 0) {
            sb.replace(9, 16, "Dlost:" + daysLost);
        }
        res[7] = sb.toString();
        sb = new StringBuilder(res[1]);
        sb.replace(16, 17, "" + lv);
        res[1] = sb.toString();
        return res;
    }
}

