/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view;

import it.polimi.ingsw.galaxytrucker.enums.ActivatableComponent;
import it.polimi.ingsw.galaxytrucker.enums.GameState;
import it.polimi.ingsw.galaxytrucker.enums.PLAYER_PHASE;
import it.polimi.ingsw.galaxytrucker.enums.ViewType;
import it.polimi.ingsw.galaxytrucker.exceptions.InvalidTilePosition;
import it.polimi.ingsw.galaxytrucker.exceptions.PlayerAlreadyExistsException;
import it.polimi.ingsw.galaxytrucker.exceptions.TooManyPlayersException;
import it.polimi.ingsw.galaxytrucker.model.FlightBoard;
import it.polimi.ingsw.galaxytrucker.model.Planet;
import it.polimi.ingsw.galaxytrucker.model.PlayerInfo;
import it.polimi.ingsw.galaxytrucker.model.PlayerScore;
import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.model.essentials.Good;
import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.model.game.TimerInfo;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyInfo;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.PhaseUpdate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;

public interface View {
    public Boolean autoShowUpdates();

    public ViewType getViewType();

    public void forceReset();

    public void askServerInfo();

    public void askNickname();

    public void showShip(Ship var1, String var2);

    public void askFlightBoardPosition(ArrayList<Integer> var1, int var2);

    public void showGenericMessage(String var1, Boolean var2);

    public void showWaitOtherPlayers();

    public void askJoinOrCreateRoom();

    public void askRoomCode();

    public void askCreateRoom() throws ExecutionException;

    public void showLobbies(List<LobbyInfo> var1);

    public void toShowCurrentMenu();

    public void showPlayerJoined(PlayerInfo var1);

    public void handleChoiceForPhase(GameState var1);

    public void showPlayersLobby(PlayerInfo var1, ArrayList<PlayerInfo> var2);

    public void handlePhaseUpdate(PhaseUpdate var1);

    public void showBuildingMenu();

    public void handleFaceUpTilesUpdate();

    public void showFaceUpTiles();

    public void showFinishedBuildingMenu();

    public void askShowFaceUpTiles();

    public void askRotation();

    public void askPosition() throws ExecutionException;

    public void askViewAdventureDecks();

    public void showTile(Tile var1);

    public void askChooseTile();

    public void askPickOrPlaceReservedTile(boolean var1);

    public void askFetchShip();

    public void askDrawTile();

    public void askTilePlacement();

    public void showCheckShipMenu();

    public void showEmbarkCrewMenu();

    public void askRemoveTile(Ship var1);

    public void chooseComponent(Ship var1, ActivatableComponent var2) throws ExecutionException, InterruptedException;

    public void chooseDiscardCrew(Ship var1, int var2) throws ExecutionException, InterruptedException;

    public void chooseTroncone(ArrayList<Ship> var1) throws ExecutionException, InterruptedException;

    public void chooseCrew(Ship var1) throws ExecutionException, InterruptedException, IOException, InvalidTilePosition, TooManyPlayersException, PlayerAlreadyExistsException;

    public void askDrawCard();

    public void showFlightBoard(FlightBoard var1, ArrayList<PlayerInfo> var2, PlayerInfo var3);

    public void showCurrentAdventureCard();

    public void showFlightMenu();

    public void askActivateAdventureCard();

    public void askSelectPlanetChoice(HashMap<Integer, Planet> var1);

    public void askLoadGoodChoice();

    public void askSelectGoodToLoad(ArrayList<Good> var1, Ship var2);

    public void askSelectGoodToDiscard(Ship var1);

    public void showEndGame(ArrayList<PlayerScore> var1);

    public void askCollectRewards();

    public void showTimerInfos(ArrayList<TimerInfo> var1, PLAYER_PHASE var2);

    public void showYouAreNowSpectating();

    public void autoShowShipInTui(Ship var1, String var2);
}

