/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Tui;

import it.polimi.ingsw.galaxytrucker.enums.GameState;
import it.polimi.ingsw.galaxytrucker.enums.MenuText;

public class MenuManager {
    MenuText currentMenu = MenuText.NONE;
    public static Boolean learningMatch = false;

    public void setLearningMatch(Boolean learningMatch) {
        MenuManager.learningMatch = learningMatch;
    }

    public void setMenuText(GameState phase) {
        switch (phase) {
            case BUILDING_START: {
                this.currentMenu = MenuText.BUILDING_MENU;
                break;
            }
            case BUILDING_END: {
                this.currentMenu = MenuText.FINISHED_BUILDING_MENU;
                break;
            }
            case SHIP_CHECK: {
                this.currentMenu = MenuText.CHECK_SHIP_MENU;
                break;
            }
            case CREW_INIT: {
                this.currentMenu = MenuText.EMBARK_CREW_MENU;
                break;
            }
            case FLIGHT: {
                this.currentMenu = MenuText.FLIGHT_MENU;
                break;
            }
            default: {
                this.currentMenu = MenuText.NONE;
            }
        }
    }

    public void showCurrentMenu() {
        switch (this.currentMenu) {
            case BUILDING_MENU: {
                this.showBuildingMenu();
                break;
            }
            case FINISHED_BUILDING_MENU: {
                this.showFinishedBuildingMenu();
                break;
            }
            case CHECK_SHIP_MENU: {
                this.showCheckShipMenu();
                break;
            }
            case EMBARK_CREW_MENU: {
                this.showEmbarkCrewMenu();
                break;
            }
            case FLIGHT_MENU: {
                this.showFlightMenu();
                break;
            }
            default: {
                return;
            }
        }
    }

    public void showBuildingMenu() {
        MenuManager.clearConsole();
        System.out.println("\n Building Phase Menu:");
        System.out.println("a. select the ship you want to view");
        System.out.println("b. Show Adventure card deck");
        System.out.println("c. Show face-up tiles on table");
        System.out.println("d. Draw a tile (randomly or choose one)");
        System.out.println("e. Show tile in hand");
        System.out.println("f. Rotate tile in hand ");
        System.out.println("g. Place tile");
        System.out.println("h. Discard tile");
        System.out.println("i. Finish building");
        if (!learningMatch.booleanValue()) {
            System.out.println("j. See Timers Status/ Flip Timer");
        }
        System.out.println("m. show menu");
    }

    public void showFinishedBuildingMenu() {
        MenuManager.clearConsole();
        System.out.println("\n Finished Building Phase Menu:");
        System.out.println("a. select the ship you want to view");
        System.out.println("b. Show Adventure card deck");
        System.out.println("c. Show face-up tiles on table");
        if (!learningMatch.booleanValue()) {
            System.out.println("j. See Timers Status/ Flip Timer");
        }
        System.out.println("m. show menu");
    }

    public void showCheckShipMenu() {
        MenuManager.clearConsole();
        System.out.println("\n Check Ship Phase Menu:");
        System.out.println("a. View my ship");
        System.out.println("b. Remove tile");
        System.out.println("c. Send checkShip request");
        System.out.println("menu. show menu");
    }

    public void showEmbarkCrewMenu() {
        MenuManager.clearConsole();
        System.out.println("\n Embark Crew Phase Menu:");
        System.out.println("a. View my ship");
        System.out.println("b. Allocate crew in cabins");
    }

    public void showNoneMenu() {
        System.out.println("\n No menu available at this stage. Please wait ...");
    }

    public static void clearConsole() {
        System.out.print("\u001b[H\u001b[2J");
        System.out.flush();
    }

    public void showPhaseStart(GameState phase) {
        switch (phase) {
            case BUILDING_START: {
                this.showBuildStart();
                break;
            }
            case FLIGHT: {
                this.showFlightStart();
                break;
            }
            case SHIP_CHECK: {
                break;
            }
            case CREW_INIT: {
                break;
            }
            case END: {
                break;
            }
            default: {
                return;
            }
        }
    }

    public void showFlightMenu() {
        MenuManager.clearConsole();
        System.out.println("\n Flight Menu:");
        System.out.println("a. view a ship");
        System.out.println("b. view flight board");
        System.out.println("c. land early");
        System.out.println("d. ready for the next turn");
        System.out.println("menu. show menu");
    }

    private void showBuildStart() {
        String banner = "\u001b[1;34m######                                                 #####                            \n#     #  #    #  #  #      #####   #  #    #  ####     #     # #####   ##   #####  ##### \n#     #  #    #  #  #      #    #  #  ##   # #    #    #         #    #  #  #    #   #   \n######   #    #  #  #      #    #  #  # #  # #          #####    #   #    # #    #   #   \n#     #  #    #  #  #      #    #  #  #  # # #  ###          #   #   ###### #####    #   \n#     #  #    #  #  #      #    #  #  #   ## #    #    #     #   #   #    # #   #    #   \n######    ####   #  ###### #####   #  #    #  ####      #####    #   #    # #    #   #   \n\u001b[0m";
        System.out.println(banner);
    }

    private void showFlightStart() {
        String banner = "\u001b[1;34m _______  __       __    _______  __    __  .___________.        _______..___________.    ___      .______     .___________.\n|   ____||  |     |  |  /  _____||  |  |  | |           |       /       ||           |   /   \\     |   _  \\    |           |\n|  |__   |  |     |  | |  |  __  |  |__|  | `---|  |----`      |   (----``---|  |----`  /  ^  \\    |  |_)  |   `---|  |----`\n|   __|  |  |     |  | |  | |_ | |   __   |     |  |            \\   \\        |  |      /  /_\\  \\   |      /        |  |     \n|  |     |  `----.|  | |  |__| | |  |  |  |     |  |        .----)   |       |  |     /  _____  \\  |  |\\  \\----.   |  |     \n|__|     |_______||__|  \\______| |__|  |__|     |__|        |_______/        |__|    /__/     \\__\\ | _| `._____|   |__|     \n\u001b[0m";
        System.out.println(banner);
    }
}

