/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Gui;

import it.polimi.ingsw.galaxytrucker.controller.ClientController;
import it.polimi.ingsw.galaxytrucker.enums.ActivatableComponent;
import it.polimi.ingsw.galaxytrucker.enums.AlienColor;
import it.polimi.ingsw.galaxytrucker.enums.GameState;
import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.model.essentials.Position;
import it.polimi.ingsw.galaxytrucker.model.essentials.Slot;
import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.BatterySlot;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.CentralHousingUnit;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.DoubleCannon;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.DoubleEngine;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.ModularHousingUnit;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Shield;
import it.polimi.ingsw.galaxytrucker.model.utils.Util;
import it.polimi.ingsw.galaxytrucker.view.Gui.FlightController;
import it.polimi.ingsw.galaxytrucker.view.Gui.GuiJavaFx;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentGuiDetailsRotationVisitor;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentNameVisitor;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

public class zUtils {
    public static void showShipInGrid(Ship ship, GridPane griglia, ClientController clientController, Boolean editable, Boolean viewDetails, FlightController flightController, ActivatableComponent activatableComponent) {
        Label l;
        StackPane stackPane;
        int i;
        griglia.getChildren().clear();
        Slot[][] shipboard = ship.getShipBoard();
        int cornice = 30;
        for (i = 1; i < 8; ++i) {
            stackPane = new StackPane();
            stackPane.alignmentProperty().setValue(Pos.CENTER);
            l = new Label(String.valueOf(i + 3));
            l.prefHeightProperty().setValue(cornice);
            l.setStyle("-fx-text-fill: white;");
            stackPane.getChildren().add(l);
            griglia.add(stackPane, i, 0);
        }
        for (i = 1; i < 6; ++i) {
            stackPane = new StackPane();
            stackPane.alignmentProperty().setValue(Pos.CENTER);
            l = new Label(String.valueOf(i + 4));
            l.maxWidth(cornice);
            l.setStyle("-fx-text-fill: white;");
            stackPane.maxWidth(cornice);
            stackPane.getChildren().add(l);
            griglia.add(stackPane, 0, i);
        }
        for (int x = 0; x < shipboard.length; ++x) {
            for (int y = 0; y < shipboard[x].length; ++y) {
                int fX = x;
                int fY = y;
                Position pos = new Position(fX, fY);
                Tile tile = shipboard[x][y].getTile();
                int rotation = 0;
                StackPane stackPane2 = new StackPane();
                if (tile != null) {
                    String tileIdVal = String.valueOf(tile.getId());
                    String imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/tiles/GT-new_tiles_16_for web".concat(tileIdVal).concat(".jpg");
                    img = new Image(Objects.requireNonNull(zUtils.class.getResource(imagePath)).toExternalForm());
                    rotation = tile.getRotation();
                    ImageView imageView = new ImageView(img);
                    stackPane2.getChildren().add(imageView);
                    imageView.fitWidthProperty().bind(griglia.prefWidthProperty().subtract(cornice).divide(7));
                    imageView.fitHeightProperty().bind(griglia.prefHeightProperty().subtract(cornice).divide(5));
                    if (viewDetails.booleanValue()) {
                        ComponentGuiDetailsRotationVisitor visitor = new ComponentGuiDetailsRotationVisitor(clientController, flightController, stackPane2, imageView, rotation, editable);
                        tile.getMyComponent().accept(visitor);
                    }
                    stackPane2.setRotate(rotation);
                } else if (clientController.getMyShip().getInvalidPositions().contains(new Position(x, y))) {
                    imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/tiles/GT-new_tiles_16_for web157.jpg";
                    img = new Image(Objects.requireNonNull(zUtils.class.getResource(imagePath)).toExternalForm());
                    imageView = new ImageView(img);
                    stackPane2.getChildren().add(imageView);
                    imageView.setPreserveRatio(false);
                    imageView.setSmooth(true);
                    imageView.fitWidthProperty().bind(griglia.prefWidthProperty().subtract(cornice).divide(7));
                    imageView.fitHeightProperty().bind(griglia.prefHeightProperty().subtract(cornice).divide(5));
                } else {
                    imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/tiles/empty.jpg";
                    img = new Image(Objects.requireNonNull(zUtils.class.getResource(imagePath)).toExternalForm());
                    imageView = new ImageView(img);
                    stackPane2.getChildren().add(imageView);
                    imageView.setPreserveRatio(false);
                    imageView.setSmooth(true);
                    imageView.fitWidthProperty().bind(griglia.prefWidthProperty().subtract(cornice).divide(7));
                    imageView.fitHeightProperty().bind(griglia.prefHeightProperty().subtract(cornice).divide(5));
                }
                GridPane.setHgrow(stackPane2, Priority.ALWAYS);
                GridPane.setVgrow(stackPane2, Priority.ALWAYS);
                GridPane.setFillWidth(stackPane2, true);
                GridPane.setFillHeight(stackPane2, true);
                ComponentNameVisitor namevisitor = new ComponentNameVisitor();
                if (editable.booleanValue()) {
                    stackPane2.setOnMouseClicked(event -> {
                        if (event.getClickCount() == 1 && event.getButton() == MouseButton.PRIMARY) {
                            GameState selector0$temp = clientController.getPhase();
                            int index$1 = 0;
                            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"SHIP_CHECK", "CREW_INIT", "FLIGHT"}, (GameState)selector0$temp, index$1)) {
                                case 0: {
                                    if (tile == null || ship.remainingTiles() <= 1) break;
                                    clientController.getMyModel().addTileToRemove(tile.getId());
                                    ship.removeTile(pos, true);
                                    zUtils.showShipInGrid(ship, griglia, clientController, editable, viewDetails, flightController, activatableComponent);
                                    break;
                                }
                                case 1: {
                                    if (tile == null || !Objects.equals(tile.getMyComponent().accept(namevisitor), "ModularHousingUnit") || !Util.checkNearLFS(new Position(fX, fY), AlienColor.BROWN, ship).booleanValue() && !Util.checkNearLFS(new Position(fX, fY), AlienColor.PURPLE, ship).booleanValue()) break;
                                    ((GuiJavaFx)clientController.getView()).editPositionCrew(fX, fY);
                                    zUtils.showShipInGrid(ship, griglia, clientController, editable, viewDetails, flightController, activatableComponent);
                                    break;
                                }
                                case 2: {
                                    CentralHousingUnit centralHousingUnit;
                                    if (activatableComponent != null) {
                                        if (tile != null && tile.getMyComponent() != null && tile.getMyComponent().accept(namevisitor).equals("DoubleEngine") && tile.getMyComponent().accept(namevisitor).equals(activatableComponent.name()) && flightController.getInHandBattery().booleanValue() && !tile.getMyComponent().isCharged().booleanValue()) {
                                            ((DoubleEngine)tile.getMyComponent()).setCharged(true);
                                            flightController.useInHandBattery();
                                            flightController.addActivatedPosition(new Position(fX, fY));
                                            zUtils.showShipInGrid(ship, griglia, clientController, editable, viewDetails, flightController, activatableComponent);
                                        }
                                        if (tile != null && tile.getMyComponent() != null && tile.getMyComponent().accept(namevisitor).equals("DoubleCannon") && tile.getMyComponent().accept(namevisitor).equals(activatableComponent.name()) && flightController.getInHandBattery().booleanValue() && !tile.getMyComponent().isCharged().booleanValue()) {
                                            ((DoubleCannon)tile.getMyComponent()).setCharged(true);
                                            flightController.useInHandBattery();
                                            flightController.addActivatedPosition(new Position(fX, fY));
                                            zUtils.showShipInGrid(ship, griglia, clientController, editable, viewDetails, flightController, activatableComponent);
                                        }
                                        if (tile != null && tile.getMyComponent() != null && tile.getMyComponent().accept(namevisitor).equals("Shield") && tile.getMyComponent().accept(namevisitor).equals(activatableComponent.name()) && flightController.getInHandBattery().booleanValue() && !tile.getMyComponent().isCharged().booleanValue()) {
                                            ((Shield)tile.getMyComponent()).setCharged(true);
                                            flightController.useInHandBattery();
                                            flightController.addActivatedPosition(new Position(fX, fY));
                                            zUtils.showShipInGrid(ship, griglia, clientController, editable, viewDetails, flightController, activatableComponent);
                                        }
                                        if (tile != null && tile.getMyComponent() != null && tile.getMyComponent().accept(namevisitor).equals("BatterySlot") && ((BatterySlot)tile.getMyComponent()).getBatteriesLeft() > 0 && !flightController.getInHandBattery().booleanValue()) {
                                            ((BatterySlot)tile.getMyComponent()).removeBattery();
                                            flightController.showBattery(new Position(fX, fY));
                                            zUtils.showShipInGrid(ship, griglia, clientController, editable, viewDetails, flightController, activatableComponent);
                                        }
                                    }
                                    if (!flightController.getIsDiscardingCrewTime().booleanValue()) break;
                                    if (tile != null && tile.getMyComponent() != null && tile.getMyComponent().accept(namevisitor).equals("ModularHousingUnit")) {
                                        ModularHousingUnit modularHousingUnit = (ModularHousingUnit)tile.getMyComponent();
                                        if (modularHousingUnit.getNCrewMembers() <= 0) break;
                                        System.out.println("Prima la cab ha: " + modularHousingUnit.getNBrownAlien() + " marroni " + modularHousingUnit.getNPurpleAlien() + " viola e " + modularHousingUnit.getNCrewMembers() + " membri crew in generale");
                                        modularHousingUnit.removeCrewMember();
                                        System.out.println("Dopo la cab ha: " + modularHousingUnit.getNBrownAlien() + " marroni " + modularHousingUnit.getNPurpleAlien() + " viola e " + modularHousingUnit.getNCrewMembers() + " membri crew in generale");
                                        flightController.addHousingPosition(new Position(fX, fY));
                                        System.out.println("Ultima inserita Posizione: " + fX + " " + fY);
                                        zUtils.showShipInGrid(ship, griglia, clientController, editable, viewDetails, flightController, activatableComponent);
                                        break;
                                    }
                                    if (tile == null || tile.getMyComponent() == null || !tile.getMyComponent().accept(namevisitor).equals("CentralHousingUnit") || (centralHousingUnit = (CentralHousingUnit)tile.getMyComponent()).getNCrewMembers() <= 0) break;
                                    centralHousingUnit.removeCrewMember();
                                    flightController.addHousingPosition(new Position(fX, fY));
                                    zUtils.showShipInGrid(ship, griglia, clientController, editable, viewDetails, flightController, activatableComponent);
                                    break;
                                }
                                default: {
                                    if (clientController.getCurrentTileInHand() != null) {
                                        try {
                                            if (clientController.getMyShip().getShipBoard()[fX][fY].getTile() != null) break;
                                            clientController.setCurrentPos(fX, fY);
                                            clientController.handleTilePlacement();
                                        }
                                        catch (Exception e) {
                                            System.out.println("Posizione non valida");
                                        }
                                        break;
                                    }
                                    if (clientController.getMyShip().getShipBoard()[fX][fY].getTile() == null || clientController.getMyShip().getShipBoard()[fX][fY].getTile().getFixed().booleanValue()) break;
                                    clientController.reclaimTile();
                                }
                            }
                            event.consume();
                        }
                    });
                }
                griglia.add(stackPane2, x + 1, y + 1);
            }
        }
    }
}

