/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Gui.Elements;

import it.polimi.ingsw.galaxytrucker.controller.ClientController;
import it.polimi.ingsw.galaxytrucker.model.essentials.Good;
import it.polimi.ingsw.galaxytrucker.view.Gui.FlightController;
import it.polimi.ingsw.galaxytrucker.view.Gui.GuiJavaFx;
import it.polimi.ingsw.galaxytrucker.view.Gui.zUtils;
import java.util.ArrayList;
import javafx.fxml.FXML;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;

public class SMloadGoodsController {
    private ClientController clientController;
    private FlightController flightController;
    private HBox container;
    private ArrayList<Good> goods;
    @FXML
    private FlowPane listaGoods;

    public void initialize(ClientController clientController, FlightController flightController, ArrayList<Good> goods, HBox container) {
        this.clientController = clientController;
        this.flightController = flightController;
        this.goods = goods;
        this.container = container;
        this.updateGoodView();
    }

    public void fineLoad() {
        this.clientController.handleLoadGoodChoice("f");
        this.flightController.endManagingGoodTime();
        GuiJavaFx.playWavSoundEffect("ButtonClick.wav");
        this.container.getChildren().clear();
    }

    public void dropGood() {
        if (this.flightController.getCurrentInHandGood() != null) {
            this.goods.add(this.flightController.getCurrentInHandGood());
            this.flightController.setCurrentInHandGood(null);
            this.flightController.hideHand();
            this.updateGoodView();
        }
    }

    public void updateGoodView() {
        this.listaGoods.getChildren().clear();
        System.out.println("Building controller DEBUG: updateGoodView");
        String pathMerce = null;
        int i = 0;
        while (i < this.goods.size()) {
            Good good = this.goods.get(i);
            switch (good.getColor()) {
                case YELLOW: {
                    pathMerce = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/merceGialla.png";
                    break;
                }
                case RED: {
                    pathMerce = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/merceRossa.png";
                    break;
                }
                case GREEN: {
                    pathMerce = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/merceVerde.png";
                    break;
                }
                case BLUE: {
                    pathMerce = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/merceBlu.png";
                }
            }
            Image merce = new Image(zUtils.class.getResource(pathMerce).toExternalForm());
            ImageView imgView = new ImageView(merce);
            imgView.fitWidthProperty().bind(this.listaGoods.widthProperty().divide(3.5));
            imgView.fitHeightProperty().bind(this.listaGoods.widthProperty().divide(3.5));
            int finalI = i++;
            imgView.setOnMouseClicked(event -> {
                if (this.flightController.getCurrentInHandGood() == null) {
                    this.goods.remove(finalI);
                    this.flightController.setCurrentInHandGood(good);
                    this.flightController.showPickedGood();
                    this.updateGoodView();
                    event.consume();
                }
            });
            this.listaGoods.getChildren().add(imgView);
        }
    }
}

