/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Gui.Elements;

import it.polimi.ingsw.galaxytrucker.enums.Color;
import it.polimi.ingsw.galaxytrucker.model.FlightBoard;
import it.polimi.ingsw.galaxytrucker.view.Gui.zUtils;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;

public class FlightBoardController {
    private int size;
    private int width;
    private int height;
    private double aspectRatio;
    private StackPane boardContainer;
    private GridPane grid;

    public void initialize(StackPane boardContainer, FlightBoard flightBoard) {
        this.boardContainer = boardContainer;
        this.size = flightBoard.getFlightBoardMap().getFlightBoardMapSlots().size();
        if (this.size == 18) {
            this.width = 8;
            this.height = 3;
            this.aspectRatio = 2.6666666666666665;
        } else {
            this.width = 10;
            this.height = 4;
            this.aspectRatio = 2.5;
        }
        this.grid = new GridPane();
        for (int i = 0; i < this.height; ++i) {
            RowConstraints rc = new RowConstraints();
            rc.setPercentHeight(100.0 / (double)this.height);
            this.grid.getRowConstraints().add(rc);
        }
        for (int j = 0; j < this.width; ++j) {
            ColumnConstraints cc = new ColumnConstraints();
            cc.setPercentWidth(100.0 / (double)this.width);
            this.grid.getColumnConstraints().add(cc);
        }
        for (int row = 0; row < this.height; ++row) {
            for (int col = 0; col < this.width; ++col) {
                StackPane cell = new StackPane();
                this.grid.add(cell, col, row);
            }
        }
        this.boardContainer.widthProperty().addListener((obs, oldVal, newVal) -> this.adjustGridPaneSize(this.aspectRatio));
        this.boardContainer.heightProperty().addListener((obs, oldVal, newVal) -> this.adjustGridPaneSize(this.aspectRatio));
        boardContainer.getChildren().add(this.grid);
        this.updateBoard(flightBoard);
        Platform.runLater(() -> this.adjustGridPaneSize(this.aspectRatio));
    }

    public void updateBoard(FlightBoard flightBoard) {
        System.out.println("Debug: FlightBoardController.updateBoard");
        int x = 0;
        int y = 0;
        int position = 0;
        y = 0;
        for (x = 0; x < this.width; ++x) {
            this.compileBoardCell(x, y, position, flightBoard);
            ++position;
        }
        x = this.width - 1;
        for (y = 1; y < this.height; ++y) {
            this.compileBoardCell(x, y, position, flightBoard);
            ++position;
        }
        y = this.height - 1;
        for (x = this.width - 2; x > -1; --x) {
            this.compileBoardCell(x, y, position, flightBoard);
            ++position;
        }
        x = 0;
        for (y = this.height - 2; y > 0; --y) {
            this.compileBoardCell(x, y, position, flightBoard);
            ++position;
        }
    }

    private void compileBoardCell(int x, int y, int position, FlightBoard flightBoard) {
        this.clearStack(x, y);
        String imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/tiles/emptyBoardSlot.png";
        if (x == 0 && y == 0) {
            imagePath = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/tiles/emptyBoardSlotFirst.png";
        }
        Image img = new Image(zUtils.class.getResource(imagePath).toExternalForm());
        String pathSegnalino = "";
        this.addImageAt(x, y, img);
        if (flightBoard.getFlightBoardMap().getFlightBoardMapSlots().get(position).getPlayerToken() != Color.EMPTY) {
            switch (flightBoard.getFlightBoardMap().getFlightBoardMapSlots().get(position).getPlayerToken()) {
                case RED: {
                    pathSegnalino = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/razzoRosso.png";
                    break;
                }
                case BLUE: {
                    pathSegnalino = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/razzoBlu.png";
                    break;
                }
                case GREEN: {
                    pathSegnalino = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/razzoVerde.png";
                    break;
                }
                case YELLOW: {
                    pathSegnalino = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/razzoGiallo.png";
                }
            }
            Image segnalino = new Image(zUtils.class.getResource(pathSegnalino).toExternalForm());
            this.addImageAt(x, y, segnalino);
            System.out.println("Aggiunto segnalino in: " + position);
        }
    }

    private void clearStack(int col, int row) {
        for (Node node : this.grid.getChildren()) {
            if (GridPane.getColumnIndex(node) == null || GridPane.getRowIndex(node) == null) continue;
            int nodeCol = GridPane.getColumnIndex(node);
            int nodeRow = GridPane.getRowIndex(node);
            if (nodeCol != col || nodeRow != row) continue;
            StackPane cell = (StackPane)node;
            cell.getChildren().clear();
            break;
        }
    }

    private void addImageAt(int col, int row, Image image) {
        for (Node node : this.grid.getChildren()) {
            if (GridPane.getColumnIndex(node) == null || GridPane.getRowIndex(node) == null) continue;
            int nodeCol = GridPane.getColumnIndex(node);
            int nodeRow = GridPane.getRowIndex(node);
            if (nodeCol != col || nodeRow != row) continue;
            StackPane cell = (StackPane)node;
            ImageView imageView = new ImageView(image);
            imageView.setPreserveRatio(true);
            imageView.setSmooth(true);
            imageView.fitWidthProperty().bind(this.grid.prefWidthProperty().divide(this.width));
            imageView.fitHeightProperty().bind(this.grid.prefHeightProperty().divide(this.height));
            cell.getChildren().add(imageView);
            break;
        }
    }

    private void adjustGridPaneSize(double aspectRatio) {
        double newWidth;
        double newHeight;
        double containerWidth = this.boardContainer.getWidth();
        double containerHeight = this.boardContainer.getHeight();
        if (containerWidth <= 0.0 || containerHeight <= 0.0) {
            return;
        }
        if (containerWidth / containerHeight > aspectRatio) {
            newHeight = containerHeight;
            newWidth = newHeight * aspectRatio;
        } else {
            newWidth = containerWidth;
            newHeight = newWidth / aspectRatio;
        }
        this.grid.setMinWidth(0.0);
        this.grid.setMinHeight(0.0);
        this.grid.setPrefWidth(newWidth);
        this.grid.setPrefHeight(newHeight);
        this.grid.setMaxWidth(newWidth);
        this.grid.setMaxHeight(newHeight);
    }
}

