/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Gui;

import it.polimi.ingsw.galaxytrucker.controller.ClientController;
import it.polimi.ingsw.galaxytrucker.network.client.ClientModel;
import it.polimi.ingsw.galaxytrucker.view.Gui.Abstract.GenericSceneController;
import it.polimi.ingsw.galaxytrucker.view.Gui.GuiJavaFx;
import it.polimi.ingsw.galaxytrucker.view.Gui.MusicManager;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class CreateLobbyController
extends GenericSceneController {
    @FXML
    private Text TxtErr;
    @FXML
    private ToggleGroup Nplayers;
    @FXML
    private ToggleGroup MatchType;
    private GuiJavaFx mainViewController;
    private ClientController clientController;
    private ClientModel mymodel;
    private Stage primaryStage;
    private MusicManager musicManager;

    @Override
    public void initialSetup(GuiJavaFx mainViewController, ClientController clientController, ClientModel mymodel, Stage primaryStage, MusicManager musicManager) {
        this.mainViewController = mainViewController;
        this.clientController = clientController;
        this.mymodel = mymodel;
        this.primaryStage = primaryStage;
        this.musicManager = musicManager;
    }

    @Override
    public void ShowGenericMessage(String message) {
        this.TxtErr.setText(message);
    }

    public void backToMainMenu(ActionEvent e) {
        GuiJavaFx.playWavSoundEffect("ButtonClick.wav");
        this.mainViewController.askJoinOrCreateRoom();
    }

    @Override
    public String pageName() {
        return "CreateLobbyPage";
    }

    public void confirm(ActionEvent e) {
        Toggle selectedToggleNumber = this.Nplayers.getSelectedToggle();
        Toggle selectedToggleMatch = this.MatchType.getSelectedToggle();
        if (selectedToggleNumber != null && selectedToggleMatch != null) {
            RadioButton selectedRadioButtonNumber = (RadioButton)selectedToggleNumber;
            RadioButton selectedRadioButtonMatch = (RadioButton)selectedToggleMatch;
            Boolean learning = false;
            Integer max = 2;
            switch (selectedRadioButtonMatch.getId()) {
                case "radioLearning": {
                    learning = true;
                    break;
                }
                case "radioLv2": {
                    learning = false;
                    break;
                }
                default: {
                    this.ShowGenericMessage("Tipo match non valido");
                }
            }
            switch (selectedRadioButtonNumber.getId()) {
                case "radio2": {
                    max = 2;
                    break;
                }
                case "radio3": {
                    max = 3;
                    break;
                }
                case "radio4": {
                    max = 4;
                    break;
                }
                default: {
                    this.ShowGenericMessage("Numero giocatori non valido");
                }
            }
            this.clientController.handleCreateChoice(max, learning);
            GuiJavaFx.playWavSoundEffect("ButtonClick.wav");
        } else {
            this.ShowGenericMessage("Seleziona Numero Giocatori e tipo di match.");
        }
    }
}

