/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.network.common;

import it.polimi.ingsw.galaxytrucker.controller.GameController;
import it.polimi.ingsw.galaxytrucker.enums.Color;
import it.polimi.ingsw.galaxytrucker.model.PlayerInfo;
import it.polimi.ingsw.galaxytrucker.model.TileBunch;
import it.polimi.ingsw.galaxytrucker.model.game.Game;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessage;
import it.polimi.ingsw.galaxytrucker.network.server.ClientHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javafx.util.Pair;

public class LobbyManager {
    private Game RealGame;
    private final int gameID;
    private final HashMap<String, Color> PlayerColors;
    private Color nextAvailableColor;
    private final HashMap<String, ClientHandler> PlayerHandlers = new HashMap();
    private final TileBunch tileBunch;
    private final GameController gameController;
    private final ArrayList<String> playerShipFinished = new ArrayList();
    private final ArrayList<String> playerCrewFinished = new ArrayList();
    private final ArrayList<PlayerInfo> playerInfos = new ArrayList();
    private final Set<String> readyPlayers = new HashSet<String>();
    private final Set<String> earlyLandingPlayers = new HashSet<String>();
    private final ArrayList<ClientHandler> timerSubscribers = new ArrayList();
    private ArrayList<Pair<Integer, CompletableFuture<NetworkMessage>>> pendingResponses;
    public final Object positionLock = new Object();
    public final Object checkShipLock = new Object();
    public final Object timerLock = new Object();
    final Object lock1 = new Object();
    final Object lock2 = new Object();
    final Object lock3 = new Object();
    final Object lock4 = new Object();
    final Object lock6 = new Object();

    public int getGameID() {
        return this.gameID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<PlayerInfo> getPlayerInfos() {
        Object object = this.lock6;
        synchronized (object) {
            return this.playerInfos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayerInfo(PlayerInfo playerInfo) {
        Object object = this.lock6;
        synchronized (object) {
            this.playerInfos.add(playerInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayerShipFinished(String playerShipFinished) {
        Object object = this.lock1;
        synchronized (object) {
            this.playerShipFinished.add(playerShipFinished);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerShipFinishedSize() {
        Object object = this.lock1;
        synchronized (object) {
            return this.playerShipFinished.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayerCrewFinished(String playerNickname) {
        Object object = this.lock4;
        synchronized (object) {
            this.playerCrewFinished.add(playerNickname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerCrewSize() {
        Object object = this.lock4;
        synchronized (object) {
            return this.playerCrewFinished.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingResponse(CompletableFuture<NetworkMessage> response, Integer id) {
        Object object = this.lock2;
        synchronized (object) {
            this.pendingResponses.add(new Pair<Integer, CompletableFuture<NetworkMessage>>(id, response));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Pair<Integer, CompletableFuture<NetworkMessage>>> getPendingResponses() {
        Object object = this.lock2;
        synchronized (object) {
            return this.pendingResponses;
        }
    }

    public Game getRealGame() {
        return this.RealGame;
    }

    public LobbyManager(int gameID) {
        this.gameID = gameID;
        this.PlayerColors = new HashMap();
        this.RealGame = new Game();
        this.nextAvailableColor = Color.RED;
        this.tileBunch = new TileBunch();
        this.gameController = new GameController(this);
        this.pendingResponses = new ArrayList();
    }

    public HashMap<String, Color> getPlayerColors() {
        return this.PlayerColors;
    }

    public Color useNextAvailableColor() {
        Color temp = this.nextAvailableColor;
        int nextIndex = temp.ordinal() + 1;
        this.nextAvailableColor = Color.values()[nextIndex];
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayerHandler(ClientHandler handler, String playerName) {
        Object object = this.lock3;
        synchronized (object) {
            this.PlayerHandlers.put(playerName, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayerHandler(String playerName) {
        Object object = this.lock3;
        synchronized (object) {
            this.PlayerHandlers.remove(playerName);
        }
    }

    public synchronized void addReadyPlayer(String playerNickname) {
        this.readyPlayers.add(playerNickname);
    }

    public synchronized void addEarlyLandingPlayer(String playerNickname) {
        this.earlyLandingPlayers.add(playerNickname);
    }

    public synchronized boolean allActivePlayerReady() {
        int playingPlayers = this.gameController.getPlayingPlayers().size();
        int readyPlayers = this.readyPlayers.size();
        int earlyLandingPlayers = this.earlyLandingPlayers.size();
        return readyPlayers == playingPlayers;
    }

    public synchronized void resetReadyPlayers() {
        this.readyPlayers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, ClientHandler> getPlayerHandlers() {
        Object object = this.lock3;
        synchronized (object) {
            return new HashMap<String, ClientHandler>(this.PlayerHandlers);
        }
    }

    public TileBunch getTileBunch() {
        return this.tileBunch;
    }

    public GameController getGameController() {
        return this.gameController;
    }

    public String getNicknameFromColor(Color color) {
        return this.PlayerColors.entrySet().stream().filter(pair -> ((Color)((Object)((Object)pair.getValue()))).equals((Object)color)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public ArrayList<ClientHandler> getTimerSubscribers() {
        return this.timerSubscribers;
    }
}

