/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.network.client;

import it.polimi.ingsw.galaxytrucker.enums.PlayerState;
import it.polimi.ingsw.galaxytrucker.model.FlightBoard;
import it.polimi.ingsw.galaxytrucker.model.Planet;
import it.polimi.ingsw.galaxytrucker.model.PlayerInfo;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.AdventureCard;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.CardDeck;
import it.polimi.ingsw.galaxytrucker.model.essentials.Good;
import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.model.game.TimerInfo;
import java.util.ArrayList;

public class ClientModel {
    private ArrayList<Integer> tilesToRemove = new ArrayList();
    private PlayerInfo myInfo;
    private ArrayList<PlayerInfo> playerInfos;
    private FlightBoard flightBoard;
    private ArrayList<CardDeck> cardDecks = new ArrayList();
    private ArrayList<Tile> faceUpTiles = new ArrayList();
    private boolean isLeader;
    private Planet selectedPlanet;
    private PlayerState playerState;
    private boolean isLearningMatch;
    private ArrayList<Good> unplacedGoods = new ArrayList();
    private AdventureCard currentAdventureCard;
    private final ArrayList<TimerInfo> timerInfos = new ArrayList();

    public ClientModel() {
        this.myInfo = new PlayerInfo();
        this.playerInfos = new ArrayList();
    }

    public PlayerState getPlayerState() {
        return this.playerState;
    }

    public void setPlayerState(PlayerState playerState) {
        this.playerState = playerState;
    }

    public ArrayList<Integer> getTilesToRemove() {
        return this.tilesToRemove;
    }

    public void setTilesToRemove(ArrayList<Integer> tilesToRemove) {
        this.tilesToRemove = tilesToRemove;
    }

    public void addTileToRemove(Integer tileID) {
        this.tilesToRemove.add(tileID);
    }

    public ArrayList<CardDeck> getCardDecks() {
        return this.cardDecks;
    }

    public void setCardDecks(ArrayList<CardDeck> cardDecks) {
        this.cardDecks = cardDecks;
    }

    public FlightBoard getFlightBoard() {
        return this.flightBoard;
    }

    public void setFlightBoard(FlightBoard flightBoard) {
        this.flightBoard = flightBoard;
    }

    public void setMyInfo(PlayerInfo myInfo) {
        this.myInfo = myInfo;
    }

    public PlayerInfo getMyInfo() {
        return this.myInfo;
    }

    public void setPlayerInfos(ArrayList<PlayerInfo> playerInfos) {
        this.playerInfos = playerInfos;
    }

    public ArrayList<PlayerInfo> getPlayerInfos() {
        return this.playerInfos;
    }

    public ArrayList<Tile> getFaceUpTiles() {
        return this.faceUpTiles;
    }

    public void setFaceUpTiles(ArrayList<Tile> faceUpTiles) {
        this.faceUpTiles = faceUpTiles;
    }

    public Tile[] getReservedTiles() {
        if (this.myInfo != null && this.myInfo.getShip() != null) {
            return this.myInfo.getShip().getAsideTiles();
        }
        return new Tile[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerInfo getPlayerInfoByNickname(String nickname) {
        if (this.myInfo != null && this.myInfo.getNickName().equals(nickname)) {
            return this.myInfo;
        }
        ArrayList<PlayerInfo> arrayList = this.playerInfos;
        synchronized (arrayList) {
            return this.playerInfos.stream().filter(info -> info.getNickName().equals(nickname)).findFirst().orElse(null);
        }
    }

    public void setLeader(boolean isLeader) {
        this.isLeader = isLeader;
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public boolean hasPlayerWithNickname(String nickname) {
        return this.getPlayerInfoByNickname(nickname) != null;
    }

    public Planet getSelectedPlanet() {
        return this.selectedPlanet;
    }

    public void setSelectedPlanet(Planet selectedPlanet) {
        this.selectedPlanet = selectedPlanet;
    }

    public boolean isLearningMatch() {
        return this.isLearningMatch;
    }

    public void setLearningMatch(boolean learningMatch) {
        this.isLearningMatch = learningMatch;
    }

    public AdventureCard getCurrentAdventureCard() {
        return this.currentAdventureCard;
    }

    public void setCurrentAdventureCard(AdventureCard currentAdventureCard) {
        this.currentAdventureCard = currentAdventureCard;
    }

    public ArrayList<Good> getUnplacedGoods() {
        return this.unplacedGoods;
    }

    public void setUnplacedGoods(ArrayList<Good> unplacedGoods) {
        this.unplacedGoods = unplacedGoods;
    }

    public ArrayList<TimerInfo> getTimerInfos() {
        return this.timerInfos;
    }
}

