/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.network;

import it.polimi.ingsw.galaxytrucker.controller.ServerController;
import it.polimi.ingsw.galaxytrucker.network.server.ClientHandler;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;

public class Heartbeat
extends Thread {
    private final ServerController serverController;
    private final ClientHandler clientHandler;
    private static final Duration sleepDuration = Duration.ofSeconds(5L);
    private boolean canBeInterrupted = true;
    private final AtomicBoolean active = new AtomicBoolean(true);

    public Heartbeat(ServerController serverController, ClientHandler clientHandler) {
        this.serverController = serverController;
        this.clientHandler = clientHandler;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(sleepDuration.toMillis());
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (!this.active.get()) {
            return;
        }
        System.out.println("KICKING " + String.valueOf(this.clientHandler));
        this.serverController.removeClient(this.clientHandler);
    }

    public void regenerate() {
        if (!this.active.get()) {
            return;
        }
        this.active.set(false);
        this.interrupt();
        this.serverController.startNewHeartbeat(this.clientHandler);
    }

    public ClientHandler getClientHandler() {
        return this.clientHandler;
    }
}

