/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.model.game;

import it.polimi.ingsw.galaxytrucker.exceptions.PlayerAlreadyExistsException;
import it.polimi.ingsw.galaxytrucker.exceptions.TooManyPlayersException;
import it.polimi.ingsw.galaxytrucker.model.FlightBoard;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.model.TileBunch;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.CardDeck;
import it.polimi.ingsw.galaxytrucker.model.game.TimerInfo;
import it.polimi.ingsw.galaxytrucker.model.utils.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Game {
    private int nMaxPlayer = 4;
    private final Map<String, Player> playerMap;
    private final HashSet<String> usedNicknames;
    private final HashMap<Player, Integer> playerOrder;
    private ArrayList<TimerInfo> timerInfos = new ArrayList();
    private boolean learningMatch = false;
    private ArrayList<CardDeck> Decks;
    private CardDeck flightDeck;
    public FlightBoard flightBoard;
    private final TileBunch tileBunch;

    public ArrayList<TimerInfo> getTimerInfos() {
        return this.timerInfos;
    }

    public Game() {
        this.playerMap = new HashMap<String, Player>();
        this.usedNicknames = new HashSet();
        this.playerOrder = new HashMap();
        this.Decks = new ArrayList();
        this.tileBunch = new TileBunch();
        this.setupTimerInfos();
    }

    public ArrayList<CardDeck> getDecks() {
        return this.Decks;
    }

    private void setupTimerInfos() {
        if (!this.learningMatch) {
            this.timerInfos.add(new TimerInfo(0, 0, false));
            this.timerInfos.add(new TimerInfo(1, 0, false));
            this.timerInfos.add(new TimerInfo(2, 0, false));
        }
    }

    public CardDeck getFlightDeck() {
        return this.flightDeck;
    }

    public void initFlightBoard() {
        this.flightBoard = new FlightBoard(this.learningMatch);
    }

    public void setFlightBoard(FlightBoard flightBoard) {
        this.flightBoard = flightBoard;
    }

    public FlightBoard getFlightBoard() {
        return this.flightBoard;
    }

    public void setLearningMatch(Boolean learningMatch) {
        this.learningMatch = learningMatch;
    }

    public void setnMaxPlayer(Integer nMaxPlayer) {
        this.nMaxPlayer = nMaxPlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNicknameUsed(String nickname) {
        HashSet<String> hashSet = this.usedNicknames;
        synchronized (hashSet) {
            return this.usedNicknames.contains(nickname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(Player player) throws TooManyPlayersException, PlayerAlreadyExistsException {
        Map<String, Player> map = this.playerMap;
        synchronized (map) {
            if (this.playerMap.size() >= this.nMaxPlayer) {
                throw new TooManyPlayersException(this.nMaxPlayer);
            }
            if (this.isNicknameUsed(player.getNickName())) {
                throw new PlayerAlreadyExistsException(player.getNickName());
            }
            this.playerMap.put(player.getNickName(), player);
            HashSet<String> hashSet = this.usedNicknames;
            synchronized (hashSet) {
                this.usedNicknames.add(player.getNickName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(String nickname) {
        Map<String, Player> map = this.playerMap;
        synchronized (map) {
            Player player = this.playerMap.get(nickname);
            if (player == null) {
                return;
            }
            this.playerMap.remove(nickname);
            HashSet<String> hashSet = this.usedNicknames;
            synchronized (hashSet) {
                this.usedNicknames.remove(nickname);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Player> getPlayers() {
        Map<String, Player> map = this.playerMap;
        synchronized (map) {
            return new ArrayList<Player>(this.playerMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player getPlayer(String nickname) {
        Map<String, Player> map = this.playerMap;
        synchronized (map) {
            return this.playerMap.get(nickname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumPlayers() {
        Map<String, Player> map = this.playerMap;
        synchronized (map) {
            return this.playerMap.size();
        }
    }

    public TileBunch getTileBunch() {
        return this.tileBunch;
    }

    public Integer getMaxPlayers() {
        return this.nMaxPlayer;
    }

    public Boolean getIsLearningMatch() {
        return this.learningMatch;
    }

    public HashMap<Player, Integer> getPlayerOrder() {
        return this.playerOrder;
    }

    public Player getPlayerFromName(String nickname) {
        return this.playerMap.get(nickname);
    }

    public ArrayList<CardDeck> createBuildingCardDecks(CardDeck lvl1cards, CardDeck lvl2cards) {
        lvl1cards.shuffle();
        lvl2cards.shuffle();
        ArrayList<CardDeck> decks = new ArrayList<CardDeck>();
        for (int i = 0; i < 4; ++i) {
            CardDeck deck = new CardDeck(i < 3);
            deck.addCard(lvl2cards.pop());
            deck.addCard(lvl2cards.pop());
            deck.addCard(lvl1cards.pop());
            decks.add(deck);
        }
        return new ArrayList<CardDeck>(decks);
    }

    public CardDeck createFlightDeck(ArrayList<CardDeck> decks) {
        CardDeck flightDeck = new CardDeck(true);
        for (CardDeck deck : decks) {
            flightDeck = flightDeck.merge(new CardDeck(deck.getCards(), deck.isSpyable()));
        }
        flightDeck.shuffle();
        if (!this.learningMatch) {
            flightDeck.putFirstLvl2CardOnTop();
        }
        return flightDeck;
    }

    public void createDecks() {
        ArrayList decks = new ArrayList();
        if (this.learningMatch) {
            CardDeck learningDeck = Util.createLearningDeck();
            this.Decks.add(learningDeck);
            this.flightDeck = learningDeck;
        } else {
            ArrayList<CardDeck> tempDecks = this.createBuildingCardDecks(Util.createLvl1Deck(), Util.createLvl2Deck());
            this.Decks = new ArrayList<CardDeck>(tempDecks);
            this.flightDeck = tempDecks.get(0);
        }
    }
}

