/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.model.essentials.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.polimi.ingsw.galaxytrucker.enums.Color;
import it.polimi.ingsw.galaxytrucker.model.essentials.Component;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentVisitorInterface;

public class CentralHousingUnit
extends Component {
    private final Color color;
    private int humanCrewNumber = 0;
    private Boolean isColored = Boolean.TRUE;

    @JsonCreator
    public CentralHousingUnit(@JsonProperty(value="color") Color color, @JsonProperty(value="humanCrewNumber") int humanCrewNumber) {
        super(false);
        this.color = color;
        if (!color.equals((Object)Color.EMPTY)) {
            this.setHumanCrewNumber(2);
        }
        if (color.equals((Object)Color.EMPTY)) {
            this.isColored = false;
        }
    }

    public CentralHousingUnit(Color color) {
        super(false);
        this.color = color;
        if (!color.equals((Object)Color.EMPTY)) {
            this.setHumanCrewNumber(2);
        }
        if (color.equals((Object)Color.EMPTY)) {
            this.isColored = false;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public int getNCrewMembers() {
        return this.humanCrewNumber;
    }

    public void setHumanCrewNumber(int humanCrewNumber) {
        if (humanCrewNumber < 0 || humanCrewNumber > 2) {
            throw new IllegalArgumentException("humanCrewNumber must be between 0 and 2");
        }
        this.humanCrewNumber = humanCrewNumber;
    }

    public Boolean getIsColored() {
        return this.isColored;
    }

    public void removeCrewMember() {
        if (this.humanCrewNumber > 0) {
            --this.humanCrewNumber;
        }
    }

    @Override
    public CentralHousingUnit clone() {
        CentralHousingUnit copy = (CentralHousingUnit)super.clone();
        copy.humanCrewNumber = this.humanCrewNumber;
        copy.isColored = this.isColored;
        copy.setRotation(this.getRotation());
        return copy;
    }

    @Override
    public <T> T accept(ComponentVisitorInterface<T> visitor) {
        return visitor.visit(this);
    }
}

