/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.model.essentials.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.polimi.ingsw.galaxytrucker.model.essentials.Component;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentVisitorInterface;

public class Cannon
extends Component {
    protected Float FirePower;

    @JsonCreator
    public Cannon(@JsonProperty(value="firePower") Float firePower) {
        super(false);
        this.FirePower = firePower;
    }

    public Float getFirePower() {
        this.calculateFP();
        return this.FirePower;
    }

    private void calculateFP() {
        if (this.getRotation() != 0) {
            this.FirePower = Float.valueOf(this.FirePower.floatValue() / 2.0f);
        }
    }

    @Override
    public Cannon clone() {
        Cannon copy = (Cannon)super.clone();
        copy.FirePower = this.FirePower;
        return copy;
    }

    @Override
    public <T> T accept(ComponentVisitorInterface<T> visitor) {
        return visitor.visit(this);
    }
}

