/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.model.adventurecards;

import it.polimi.ingsw.galaxytrucker.model.adventurecards.AdventureCard;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

public class CardDeck
implements Serializable {
    private static final long serialVersionUID = 19819109L;
    private final ArrayList<AdventureCard> cards;
    public final boolean spyable;

    public boolean isSpyable() {
        return this.spyable;
    }

    public CardDeck(ArrayList<AdventureCard> cards, boolean spyable) {
        this.cards = cards;
        this.spyable = spyable;
    }

    public CardDeck(boolean spyable) {
        this.spyable = spyable;
        this.cards = new ArrayList();
    }

    public int getSize() {
        return this.cards.size();
    }

    public void addCard(AdventureCard card) {
        this.cards.addFirst(card);
    }

    public AdventureCard pop() {
        AdventureCard popped = this.cards.getFirst();
        this.cards.remove(popped);
        return popped;
    }

    public CardDeck merge(CardDeck cd) {
        for (AdventureCard c : cd.getCards()) {
            this.cards.addFirst(c);
        }
        return this;
    }

    public void shuffle() {
        Collections.shuffle(this.cards);
    }

    public void clear() {
        this.cards.clear();
    }

    public AdventureCard peek() {
        return this.cards.getFirst();
    }

    public void putFirstLvl2CardOnTop() {
        if (this.peek().getLevel() != 2) {
            AdventureCard toBeFirst = this.cards.stream().filter(card -> card.getLevel() == 2).findFirst().get();
            this.cards.remove(toBeFirst);
            this.cards.addFirst(toBeFirst);
        }
    }

    public ArrayList<AdventureCard> getCards() {
        return this.cards;
    }
}

