/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects;

import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.CardContext;
import it.polimi.ingsw.galaxytrucker.enums.Color;
import it.polimi.ingsw.galaxytrucker.enums.ProjectileDirection;
import it.polimi.ingsw.galaxytrucker.enums.ProjectileSize;
import it.polimi.ingsw.galaxytrucker.enums.ProjectileType;
import it.polimi.ingsw.galaxytrucker.model.FlightBoard;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.model.Projectile;
import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.model.essentials.Component;
import it.polimi.ingsw.galaxytrucker.model.essentials.Good;
import it.polimi.ingsw.galaxytrucker.model.essentials.Position;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.BatterySlot;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Cannon;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.CentralHousingUnit;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.DoubleCannon;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.DoubleEngine;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.GenericCargoHolds;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Shield;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyManager;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessage;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.DiscardCrewMembersResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.FlightBoardUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.GameMessage;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.ShipUpdate;
import it.polimi.ingsw.galaxytrucker.network.server.ClientHandler;
import it.polimi.ingsw.galaxytrucker.visitors.Network.NetworkMessageCouplingVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class Utils {
    private static final NetworkMessageCouplingVisitor networkMessageCouplingVisitor = new NetworkMessageCouplingVisitor();

    protected static void movePlayer(CardContext context, Player player, int steps) {
        LobbyManager game = context.getCurrentGame();
        FlightBoard flightBoard = game.getRealGame().getFlightBoard();
        flightBoard.movePlayer(game.getPlayerColors().get(player.getNickName()), steps, player);
        FlightBoardUpdate fbu = new FlightBoardUpdate(flightBoard);
        String direction = steps < 0 ? "backwards" : "forwards";
        String message = "Player " + player.getNickName() + " moved " + Math.abs(steps) + " steps " + direction + "!";
        Utils.broadcast(context, new GameMessage(message));
        Utils.broadcast(context, fbu);
        Utils.sleepSafe(600L);
        context.setCurrentRankedPlayers(context.getCurrentGame().getGameController().getRankedPlayers());
    }

    protected static void discardCrewMembers(CardContext context, Player player, DiscardCrewMembersResponse discardCrewMembersResponse, int numberOfCrewMembersToBeDiscarded) {
        for (Position position : discardCrewMembersResponse.getHousingPositions()) {
            Component housingUnit = player.getShip().getComponentFromPosition(position);
            CentralHousingUnit centralHousingUnit = (CentralHousingUnit)housingUnit;
            if (centralHousingUnit.getNCrewMembers() <= 0 || numberOfCrewMembersToBeDiscarded <= 0) continue;
            centralHousingUnit.removeCrewMember();
            --numberOfCrewMembersToBeDiscarded;
        }
        ShipUpdate shipUpdate = new ShipUpdate(player.getShip(), player.getNickName());
        Utils.broadcast(context, shipUpdate);
        String message = "Player " + player.getNickName() + " ha perso " + discardCrewMembersResponse.getHousingPositions().size() + " crew members!";
        Utils.broadcast(context, new GameMessage(message));
        Utils.sleepSafe(600L);
    }

    protected static void sendMessage(CardContext context, Player player, NetworkMessage message) {
        context.incrementExpectedNumberOfNetworkMessages(message.accept(networkMessageCouplingVisitor));
        context.getCurrentGame().getPlayerHandlers().get(player.getNickName()).sendMessage(message);
    }

    protected static void sendGameMessage(CardContext context, Player player, String message) {
        GameMessage gameMessage = new GameMessage(message);
        gameMessage.setMessage(message);
        context.getCurrentGame().getPlayerHandlers().get(player.getNickName()).sendMessage(gameMessage);
    }

    protected static void broadcastGameMessage(CardContext context, String message) {
        Utils.broadcast(context, new GameMessage(message));
    }

    protected static void broadcast(CardContext context, NetworkMessage message) {
        LobbyManager lobbyManager = context.getCurrentGame();
        lobbyManager.getPlayerHandlers().values().forEach(ch -> ch.sendMessage(message));
    }

    protected static void broadcastExcept(CardContext context, NetworkMessage message, Player player) {
        LobbyManager lobbyManager = context.getCurrentGame();
        ClientHandler excludedPlayerClientHandler = lobbyManager.getPlayerHandlers().get(player.getNickName());
        lobbyManager.getPlayerHandlers().values().forEach(ch -> {
            if (ch != excludedPlayerClientHandler) {
                ch.sendMessage(message);
            }
        });
    }

    protected static boolean playerCanDefendThemselvesWithAShield(Player player, Projectile projectile) {
        if (projectile.getSize() == ProjectileSize.Big) {
            return false;
        }
        return player.getShip().getComponentPositionsFromName("Shield").stream().anyMatch(p -> ((Shield)player.getShip().getComponentFromPosition((Position)p)).getProtectedSides().contains((Object)projectile.getDirection()));
    }

    protected static boolean playerCanDefendThemselvesWithASingleCannon(Player player, Projectile projectile, int diceRoll) {
        if (projectile.getType() != ProjectileType.Meteor || projectile.getSize() != ProjectileSize.Big) {
            return false;
        }
        Ship ship = player.getShip();
        ProjectileDirection direction = projectile.getDirection();
        for (Position cannonPos : ship.getComponentPositionsFromName("Cannon")) {
            Cannon cannon = (Cannon)ship.getComponentFromPosition(cannonPos);
            ProjectileDirection directionCannon = ProjectileDirection.fromRotation(cannon.getRotation());
            if (!directionCannon.equals((Object)direction) || !(direction == ProjectileDirection.UP ? diceRoll == cannonPos.getX() : (direction == ProjectileDirection.DOWN ? Math.abs(cannonPos.getX() - diceRoll) <= 1 : Math.abs(cannonPos.getY() - diceRoll) <= 1))) continue;
            return true;
        }
        return false;
    }

    protected static boolean playerCanDefendThemselvesWithADoubleCannon(Player player, Projectile projectile, int diceRoll) {
        if (projectile.getType() != ProjectileType.Meteor || projectile.getSize() != ProjectileSize.Big) {
            return false;
        }
        Ship ship = player.getShip();
        ProjectileDirection direction = projectile.getDirection();
        for (Position cannonPos : ship.getComponentPositionsFromName("DoubleCannon")) {
            DoubleCannon doubleCannon = (DoubleCannon)ship.getComponentFromPosition(cannonPos);
            ProjectileDirection directionDoubleCannon = ProjectileDirection.fromRotation(doubleCannon.getRotation());
            if (!directionDoubleCannon.equals((Object)direction) || !doubleCannon.isCharged().booleanValue() || !(direction == ProjectileDirection.UP ? diceRoll == cannonPos.getX() : (direction == ProjectileDirection.DOWN ? Math.abs(cannonPos.getX() - diceRoll) <= 1 : Math.abs(cannonPos.getY() - diceRoll) <= 1))) continue;
            return true;
        }
        return false;
    }

    protected static int getCorrectedDiceRoll(int diceRoll, ProjectileDirection direction) {
        switch (direction) {
            case UP: 
            case DOWN: {
                return diceRoll - 4;
            }
            case LEFT: 
            case RIGHT: {
                return diceRoll - 5;
            }
        }
        throw new IllegalArgumentException("Invalid direction");
    }

    protected static ArrayList<Good> getAndRemoveMostValuableGoods(CardContext context, Player player, int penalty) {
        Ship ship = player.getShip();
        ArrayList<Good> goodsToDiscard = new ArrayList<Good>();
        HashMap goodPositions = new HashMap();
        goodPositions.put(Color.RED, new ArrayList());
        goodPositions.put(Color.BLUE, new ArrayList());
        goodPositions.put(Color.GREEN, new ArrayList());
        goodPositions.put(Color.YELLOW, new ArrayList());
        ArrayList<Position> storagePos = ship.getComponentPositionsFromName("GenericCargoHolds");
        for (Position pos : storagePos) {
            GenericCargoHolds hold = (GenericCargoHolds)ship.getComponentFromPosition(pos);
            if (hold.isEmpty()) continue;
            for (Good good : hold.getGoods()) {
                Color color = good.getColor();
                ((ArrayList)goodPositions.get((Object)color)).add(pos);
            }
        }
        List<Color> priority = List.of(Color.RED, Color.YELLOW, Color.GREEN, Color.BLUE);
        int index = 0;
        while (goodsToDiscard.size() < penalty && index < priority.size()) {
            Color currentColor = priority.get(index);
            List positions = (List)goodPositions.get((Object)currentColor);
            if (positions.isEmpty()) {
                ++index;
                continue;
            }
            Position pos = (Position)positions.remove(0);
            GenericCargoHolds hold = (GenericCargoHolds)ship.getComponentFromPosition(pos);
            hold.removeGood(currentColor);
            ShipUpdate shipUpdate = new ShipUpdate(ship, player.getNickName());
            Utils.broadcast(context, shipUpdate);
            goodsToDiscard.add(new Good(currentColor));
        }
        return goodsToDiscard;
    }

    protected static void removeBatteries(CardContext context, Player player, int batteryToDiscard) {
        if (batteryToDiscard <= 0) {
            return;
        }
        Ship ship = player.getShip();
        ArrayList<Position> storagePos = ship.getComponentPositionsFromName("BatterySlot");
        int removed = 0;
        for (Position pos : storagePos) {
            boolean success;
            BatterySlot batterySlot = (BatterySlot)ship.getComponentFromPosition(pos);
            while (batterySlot.getBatteriesLeft() > 0 && removed < batteryToDiscard && (success = batterySlot.removeBattery())) {
                ++removed;
                ShipUpdate shipUpdate = new ShipUpdate(ship, player.getNickName());
                Utils.broadcast(context, shipUpdate);
            }
            if (removed < batteryToDiscard) continue;
            break;
        }
    }

    protected static void resetDoubleCannon(Player player) {
        Ship ship = player.getShip();
        ArrayList<Position> doubleCannonPos = ship.getComponentPositionsFromName("DoubleCannon");
        if (doubleCannonPos.isEmpty()) {
            return;
        }
        for (Position pos : doubleCannonPos) {
            DoubleCannon doubleCannon = (DoubleCannon)ship.getComponentFromPosition(pos);
            doubleCannon.setCharged(false);
        }
    }

    protected static void resetShield(Player player) {
        Ship ship = player.getShip();
        ArrayList<Position> shieldPos = ship.getComponentPositionsFromName("Shield");
        if (shieldPos.isEmpty()) {
            return;
        }
        for (Position pos : shieldPos) {
            Shield shield = (Shield)ship.getComponentFromPosition(pos);
            shield.setCharged(false);
        }
    }

    protected static void resetDoubleEngine(Player player) {
        Ship ship = player.getShip();
        ArrayList<Position> doubleEnginePos = ship.getComponentPositionsFromName("DoubleEngine");
        if (doubleEnginePos.isEmpty()) {
            return;
        }
        for (Position pos : doubleEnginePos) {
            DoubleEngine doubleEngine = (DoubleEngine)ship.getComponentFromPosition(pos);
            doubleEngine.setCharged(false);
        }
    }

    protected static void addDestroyedTilesInTrunc(Player player, ArrayList<Ship> trucks) {
        int removed = 0;
        for (Ship ship : trucks) {
            removed += ship.remainingTiles();
        }
        player.getShip().addDestroyedTiles(removed);
    }

    protected static void sleepSafe(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected static void broadcastShipUpdate(CardContext context, Player player) {
        ShipUpdate shipUpdate = new ShipUpdate(player.getShip(), player.getNickName());
        shipUpdate.setShouldDisplay(true);
        Utils.broadcast(context, shipUpdate);
        Utils.sleepSafe(600L);
    }
}

