/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects;

import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.CardContext;
import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects.Utils;
import it.polimi.ingsw.galaxytrucker.enums.ActivatableComponent;
import it.polimi.ingsw.galaxytrucker.enums.ProjectileSize;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.model.Projectile;
import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.MeteorSwarm;
import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyManager;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.ActivateComponentRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.AskTrunkRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.AskTrunkResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.ShipUpdate;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentNameVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public abstract class MeteorSwarmEffect {
    private static final HashMap<LobbyManager, Integer> projectileCounters = new HashMap();
    private static final HashMap<LobbyManager, Integer> diceRolls = new HashMap();
    private static final Random rand = new Random();
    private static final HashMap<LobbyManager, ArrayList<Player>> needToAskTrunkReq = new HashMap();
    private static final HashMap<LobbyManager, HashMap<Player, ArrayList<Ship>>> trunkOptions = new HashMap();
    private static final HashMap<LobbyManager, Integer> askTrunkReceived = new HashMap();

    public static void sendActivateComponentRequests(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        MeteorSwarm meteorSwarm = (MeteorSwarm)context.getAdventureCard();
        int projectileIndex = projectileCounters.computeIfAbsent(game, lobbyManager -> 0);
        Projectile projectile = meteorSwarm.getMeteors().get(projectileIndex);
        int viewDiceRoll = rand.nextInt(2, 13);
        int diceRoll = Utils.getCorrectedDiceRoll(viewDiceRoll, projectile.getDirection());
        Utils.broadcastGameMessage(context, "Stai per essere colpito da un " + projectile.getType().name() + "  " + String.valueOf((Object)projectile.getSize()) + " " + projectile.getDirection().name() + ", indice " + viewDiceRoll + "!");
        Utils.sleepSafe(600L);
        diceRolls.put(game, diceRoll);
        ActivateComponentRequest activateShieldsRequest = new ActivateComponentRequest(ActivatableComponent.Shield);
        ActivateComponentRequest activateDoubleCannonsRequest = new ActivateComponentRequest(ActivatableComponent.DoubleCannon);
        if (projectile.getSize() == ProjectileSize.Little) {
            for (Player player : context.getCurrentRankedPlayers()) {
                if (player.getShip().getFirstComponentFromDirectionAndIndex(projectile.getDirection(), diceRoll) == null || !Utils.playerCanDefendThemselvesWithAShield(player, projectile)) continue;
                Utils.sendGameMessage(context, player, "Puoi difenderti con uno scudo!");
                Utils.sleepSafe(600L);
                context.nextPhase();
                Utils.sendMessage(context, player, activateShieldsRequest);
                return;
            }
        } else if (projectile.getSize() == ProjectileSize.Big) {
            for (Player player : context.getCurrentRankedPlayers()) {
                if (player.getShip().getFirstComponentFromDirectionAndIndex(projectile.getDirection(), diceRoll) == null) continue;
                if (Utils.playerCanDefendThemselvesWithASingleCannon(player, projectile, diceRoll)) {
                    Utils.sendGameMessage(context, player, "Ti protegger\u00e0 un cannone singolo!");
                    Utils.sleepSafe(600L);
                    continue;
                }
                if (!Utils.playerCanDefendThemselvesWithADoubleCannon(player, projectile, diceRoll)) continue;
                Utils.sendGameMessage(context, player, "Puoi difenderti con un cannone doppio!");
                Utils.sleepSafe(600L);
                context.nextPhase();
                Utils.sendMessage(context, player, activateDoubleCannonsRequest);
                return;
            }
        }
        context.nextPhase();
        context.executePhase();
    }

    public static void unleashTheMeteorSwarm(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        MeteorSwarm meteorSwarm = (MeteorSwarm)context.getAdventureCard();
        int projectileIndex = projectileCounters.computeIfAbsent(game, lobbyManager -> 0);
        Projectile projectile = meteorSwarm.getMeteors().get(projectileIndex);
        int diceRoll = diceRolls.get(game);
        needToAskTrunkReq.putIfAbsent(game, new ArrayList());
        for (Player player : context.getCurrentRankedPlayers()) {
            Utils.broadcastShipUpdate(context, player);
            Utils.sleepSafe(600L);
            Tile removedTile = game.getGameController().reactToProjectile(player, projectile, diceRoll);
            if (removedTile != null) {
                ComponentNameVisitor componentNameVisitor = new ComponentNameVisitor();
                Utils.broadcastGameMessage(context, "Purtroppo, " + player.getNickName() + " \u00e8 stato colpito e ha perso un " + removedTile.getMyComponent().accept(componentNameVisitor));
            } else {
                Utils.broadcastGameMessage(context, "Congratulazioni, " + player.getNickName() + " \u00e8 riuscito a schivare l'attacco!");
            }
            Utils.sleepSafe(600L);
            Utils.resetShield(player);
            Utils.resetDoubleCannon(player);
            Utils.broadcastShipUpdate(context, player);
            ArrayList<Ship> troncs = player.getShip().getTronc();
            if (troncs.size() > 1) {
                needToAskTrunkReq.get(game).add(player);
                trunkOptions.computeIfAbsent(game, g -> new HashMap()).put(player, troncs);
            }
            ShipUpdate shipUpdate = new ShipUpdate(player.getShip(), player.getNickName());
            Utils.broadcast(context, shipUpdate);
        }
        if (!needToAskTrunkReq.get(game).isEmpty()) {
            context.nextPhase();
            context.executePhase();
            return;
        }
        Utils.broadcastGameMessage(context, "Tutti gli attacchi meteorici di questo turno sono stati risolti.");
        Utils.sleepSafe(300L);
        MeteorSwarmEffect.goToEndPhaseOrReset(context);
    }

    public static void askTrunkReq(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        ArrayList<Player> players = needToAskTrunkReq.get(game);
        context.nextPhase();
        for (Player player : players) {
            ArrayList<Ship> troncs = trunkOptions.get(game).get(player);
            AskTrunkRequest askTrunkRequest = new AskTrunkRequest(troncs);
            Utils.sendMessage(context, player, askTrunkRequest);
        }
    }

    public static void receivedTrunkRepo(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        AskTrunkResponse askTrunkResponse = (AskTrunkResponse)context.getIncomingNetworkMessage();
        int indexTrunk = askTrunkResponse.getTrunkIndex();
        ArrayList<Player> rankedPlayers = context.getCurrentRankedPlayers();
        Player currentPlayer = rankedPlayers.stream().filter(p -> p.getNickName().equals(askTrunkResponse.getPlayerNickname())).findFirst().orElse(null);
        if (currentPlayer == null) {
            MeteorSwarmEffect.resetState(game);
            return;
        }
        ArrayList<Ship> trunks = trunkOptions.get(game).get(currentPlayer);
        if (trunks != null && indexTrunk >= 0 && indexTrunk < trunks.size()) {
            Ship newShip = trunks.remove(indexTrunk);
            currentPlayer.replaceShip(newShip);
            Utils.broadcast(context, new ShipUpdate(newShip, currentPlayer.getNickName()));
            Utils.addDestroyedTilesInTrunc(currentPlayer, trunks);
        }
        askTrunkReceived.merge(game, 1, Integer::sum);
        if (askTrunkReceived.get(game).intValue() == needToAskTrunkReq.get(game).size()) {
            needToAskTrunkReq.remove(game);
            trunkOptions.remove(game);
            askTrunkReceived.remove(game);
            MeteorSwarmEffect.goToEndPhaseOrReset(context);
        }
    }

    private static void goToEndPhaseOrReset(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        MeteorSwarm meteorSwarm = (MeteorSwarm)context.getAdventureCard();
        int projectileIndex = projectileCounters.computeIfAbsent(game, lobbyManager -> 0);
        if (projectileIndex < meteorSwarm.getMeteors().size() - 1) {
            projectileCounters.put(game, projectileIndex + 1);
            context.resetFSM();
            context.executePhase();
        } else {
            MeteorSwarmEffect.resetState(context.getCurrentGame());
            context.goToEndPhase();
            context.executePhase();
        }
    }

    private static void resetState(LobbyManager game) {
        projectileCounters.remove(game);
        diceRolls.remove(game);
        needToAskTrunkReq.remove(game);
        trunkOptions.remove(game);
        askTrunkReceived.remove(game);
    }
}

