/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects;

import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.CardContext;
import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects.Utils;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.model.essentials.Position;
import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.CentralHousingUnit;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.ShipUpdate;
import java.util.ArrayList;
import java.util.HashSet;
import javafx.util.Pair;

public abstract class EpidemicEffect {
    public static void check(CardContext context) {
        ArrayList<Position> housings = new ArrayList<Position>();
        Player currentPlayer = context.getCurrentPlayer();
        Ship ship = context.getCurrentPlayer().getShip();
        Utils.broadcastGameMessage(context, "Il giocatore " + currentPlayer.getNickName() + " sta subendo l\u2019effetto della carta e gli equipaggi nelle cabine idonee verranno rimossi");
        Utils.sleepSafe(600L);
        housings.addAll(ship.getComponentPositionsFromName("CentralHousingUnit"));
        housings.addAll(ship.getComponentPositionsFromName("ModularHousingUnit"));
        HashSet<String> processedPairs = new HashSet<String>();
        for (Position housingUnitPosition : housings) {
            CentralHousingUnit housingUnit = (CentralHousingUnit)ship.getComponentFromPosition(housingUnitPosition);
            if (housingUnit.getNCrewMembers() == 0) continue;
            ArrayList<Pair<Position, Tile>> connectedHousingUnitTilesWithPositions = ship.getConnectedHousingUnitTiles(housingUnitPosition);
            for (Pair<Position, Tile> connectedHousingUnitTileWithPosition : connectedHousingUnitTilesWithPositions) {
                String key;
                CentralHousingUnit connectedHousingUnit = (CentralHousingUnit)connectedHousingUnitTileWithPosition.getValue().getMyComponent();
                Position connectedPos = connectedHousingUnitTileWithPosition.getKey();
                if (connectedHousingUnit == null || connectedHousingUnit.getNCrewMembers() == 0 || processedPairs.contains(key = EpidemicEffect.createSortedKey(housingUnitPosition, connectedPos)) || housingUnit.getNCrewMembers() <= 0 || connectedHousingUnit.getNCrewMembers() <= 0) continue;
                housingUnit.removeCrewMember();
                connectedHousingUnit.removeCrewMember();
                processedPairs.add(key);
            }
        }
        if (context.getCurrentPlayer() != context.getCurrentRankedPlayers().getLast()) {
            Utils.broadcast(context, new ShipUpdate(ship, currentPlayer.getNickName()));
            Utils.broadcastGameMessage(context, "Effetto concluso. Tocca al prossimo giocatore.");
            Utils.sleepSafe(600L);
            context.nextPlayer();
            context.executePhase();
        } else {
            Utils.broadcast(context, new ShipUpdate(ship, currentPlayer.getNickName()));
            Utils.broadcastGameMessage(context, "Effetto concluso.");
            Utils.sleepSafe(600L);
            context.nextPhase();
            context.executePhase();
        }
    }

    private static String createSortedKey(Position p1, Position p2) {
        if (p1.getX() < p2.getX() || p1.getX() == p2.getX() && p1.getY() < p2.getY()) {
            return p1.getX() + "," + p1.getY() + "-" + p2.getX() + "," + p2.getY();
        }
        return p2.getX() + "," + p2.getY() + "-" + p1.getX() + "," + p1.getY();
    }
}

