/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects;

import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.CardContext;
import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects.Utils;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.AbandonedShip;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.ActivateAdventureCardRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.DiscardCrewMembersRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.ActivateAdventureCardResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.DiscardCrewMembersResponse;

public abstract class AbandonedShipEffect {
    public static void start(CardContext context) {
        AbandonedShip abandonedShip = (AbandonedShip)context.getAdventureCard();
        Player player = context.getCurrentPlayer();
        if (player.getShip().getnCrew() >= abandonedShip.getRequiredCrewMembers()) {
            ActivateAdventureCardRequest activateAdventureCardRequest = new ActivateAdventureCardRequest();
            context.nextPhase();
            Utils.sleepSafe(600L);
            Utils.sendMessage(context, player, activateAdventureCardRequest);
        } else {
            Utils.sendGameMessage(context, player, "Non hai abbastanza membri dell'equipaggio per attivare questa carta.");
            Utils.sleepSafe(600L);
            if (context.currentPlayerIsLast()) {
                context.goToEndPhase();
            } else {
                context.nextPlayer();
            }
            context.executePhase();
        }
    }

    public static void receivedCardActivationResponse(CardContext context) {
        ActivateAdventureCardResponse activateAdventureCardResponse = (ActivateAdventureCardResponse)context.getIncomingNetworkMessage();
        if (activateAdventureCardResponse.isActivated()) {
            AbandonedShip abandonedShip = (AbandonedShip)context.getAdventureCard();
            context.nextPhase();
            Player player = context.getCurrentPlayer();
            int playerCrewMembersNumber = player.getShip().getnCrew();
            int nCrewToBeDiscarded = Integer.min(playerCrewMembersNumber, abandonedShip.getRequiredCrewMembers());
            DiscardCrewMembersRequest discardCrewMembersRequest = new DiscardCrewMembersRequest(nCrewToBeDiscarded);
            if (nCrewToBeDiscarded != abandonedShip.getRequiredCrewMembers()) {
                Utils.sendGameMessage(context, player, "Dato che non hai abbastanza membri dell'equipaggio, ti preghiamo di svuotare completamente il tuo equipaggio.");
            }
            Utils.sleepSafe(600L);
            Utils.sendMessage(context, context.getCurrentPlayer(), discardCrewMembersRequest);
        } else {
            if (context.currentPlayerIsLast()) {
                context.goToEndPhase();
            } else {
                context.resetFSM();
                context.nextPlayer();
            }
            context.executePhase();
        }
    }

    public static void crewDiscarded(CardContext context) {
        Player player = context.getCurrentPlayer();
        AbandonedShip abandonedShip = (AbandonedShip)context.getAdventureCard();
        DiscardCrewMembersResponse discardCrewMembersResponse = (DiscardCrewMembersResponse)context.getIncomingNetworkMessage();
        Utils.discardCrewMembers(context, context.getCurrentPlayer(), discardCrewMembersResponse, discardCrewMembersResponse.getHousingPositions().size());
        player.addCredits(abandonedShip.getCredits());
        Utils.broadcastGameMessage(context, "Il giocatore " + player.getNickName() + " ha guadagnato " + abandonedShip.getCredits() + " punti");
        Utils.sleepSafe(600L);
        Utils.movePlayer(context, player, -abandonedShip.getDaysLost());
        context.nextPhase();
        context.executePhase();
    }
}

