/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller;

import it.polimi.ingsw.galaxytrucker.controller.ClientController;
import it.polimi.ingsw.galaxytrucker.enums.PLAYER_PHASE;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.PhaseUpdate;

public class ClientPhaseController {
    private final ClientController controller;
    private PLAYER_PHASE phase;

    public ClientPhaseController(ClientController controller) {
        this.controller = controller;
        this.phase = PLAYER_PHASE.START;
    }

    public synchronized PLAYER_PHASE getPhase() {
        return this.phase;
    }

    public synchronized void setPhase(PLAYER_PHASE phase) {
        this.phase = phase;
    }

    public synchronized void handlePhaseUpdate(PhaseUpdate update) {
        switch (update.getState()) {
            case BUILDING_START: {
                this.phase = PLAYER_PHASE.BUILDING;
                break;
            }
            case BUILDING_TIMER: {
                if (this.phase == PLAYER_PHASE.FINISH_BUILDING) {
                    return;
                }
                this.phase = PLAYER_PHASE.BUILDING_TIMER;
                break;
            }
            case BUILDING_END: {
                this.phase = PLAYER_PHASE.FINISH_BUILDING;
                break;
            }
            case CREW_INIT: {
                this.phase = PLAYER_PHASE.CREW_CHOICE;
                break;
            }
            case SHIP_CHECK: {
                this.phase = PLAYER_PHASE.CHECK_SHIP;
                break;
            }
            case FLIGHT: {
                this.phase = PLAYER_PHASE.FLIGHT;
            }
        }
    }
}

