/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller;

import it.polimi.ingsw.galaxytrucker.controller.ClientPhaseController;
import it.polimi.ingsw.galaxytrucker.enums.ActivatableComponent;
import it.polimi.ingsw.galaxytrucker.enums.Color;
import it.polimi.ingsw.galaxytrucker.enums.GameState;
import it.polimi.ingsw.galaxytrucker.enums.PLAYER_PHASE;
import it.polimi.ingsw.galaxytrucker.enums.PlayerState;
import it.polimi.ingsw.galaxytrucker.enums.TimerStatus;
import it.polimi.ingsw.galaxytrucker.enums.ViewType;
import it.polimi.ingsw.galaxytrucker.exceptions.InvalidTilePosition;
import it.polimi.ingsw.galaxytrucker.exceptions.PlayerAlreadyExistsException;
import it.polimi.ingsw.galaxytrucker.exceptions.TooManyPlayersException;
import it.polimi.ingsw.galaxytrucker.model.Planet;
import it.polimi.ingsw.galaxytrucker.model.PlayerInfo;
import it.polimi.ingsw.galaxytrucker.model.PlayerScore;
import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.AbandonedStation;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.AdventureCard;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.CardDeck;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Smugglers;
import it.polimi.ingsw.galaxytrucker.model.essentials.Component;
import it.polimi.ingsw.galaxytrucker.model.essentials.Good;
import it.polimi.ingsw.galaxytrucker.model.essentials.Position;
import it.polimi.ingsw.galaxytrucker.model.essentials.Slot;
import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.GenericCargoHolds;
import it.polimi.ingsw.galaxytrucker.model.game.TimerInfo;
import it.polimi.ingsw.galaxytrucker.model.utils.Util;
import it.polimi.ingsw.galaxytrucker.network.client.Client;
import it.polimi.ingsw.galaxytrucker.network.client.ClientModel;
import it.polimi.ingsw.galaxytrucker.network.client.rmi.ClientRMI;
import it.polimi.ingsw.galaxytrucker.network.client.socket.ClientSocket;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyInfo;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessage;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.SERVER_INFO;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.ActivateAdventureCardRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.ActivateComponentRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.AskTimerInfoRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.AskTrunkRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.CheckShipStatusRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.CollectRewardsRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.CreateRoomRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.DiscardCrewMembersRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.DiscardTileRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.DrawAdventureCardRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.DrawTileRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.EarlyLandingRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.FinishBuildingRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.FlipTimerRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.HeartbeatRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.JoinRoomRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.JoiniRoomOptionsRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.NicknameRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.PlaceTileRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.ReadyTurnRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.SelectPlanetRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.ActivateAdventureCardResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.ActivateComponentResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.AskTrunkResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.CheckShipStatusResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.CollectRewardsResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.DiscardCrewMembersResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.DrawTileResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.JoinRoomOptionsResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.JoinRoomResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.NicknameResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.PlaceTileResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.SelectPlanetResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.TimerInfoResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.AskPositionUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.CrewInitUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.DecksUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.DrawnAdventureCardUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.EndTurnUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.FaceUpTileUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.FlightBoardUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.GameEndUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.GameMessage;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.MatchInfoUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.PhaseUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.PlayerJoinedUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.PlayerKickedUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.PlayerLostUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.SelectedPlanetUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.ShipUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkingUtils;
import it.polimi.ingsw.galaxytrucker.observer.Observer;
import it.polimi.ingsw.galaxytrucker.view.Tui.MenuManager;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.CardPrintUtils;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.ShipPrintUtils;
import it.polimi.ingsw.galaxytrucker.view.View;
import it.polimi.ingsw.galaxytrucker.visitors.Network.ClientNetworkMessageVisitor;
import it.polimi.ingsw.galaxytrucker.visitors.Network.NetworkMessageVisitorsInterface;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentNameVisitor;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.rmi.NotBoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.util.Pair;

public class ClientController
implements Observer {
    private Client client;
    private View view;
    private CompletableFuture<NetworkMessage> completableFuture;
    private Pair<Integer, CompletableFuture<NetworkMessage>> pair;
    private ClientModel myModel;
    private final NetworkMessageVisitorsInterface<Void> messageVisitor = new ClientNetworkMessageVisitor(this);
    private Tile currentTileInHand = null;
    private Position currentPosition;
    private Position tmpCurrentPosition;
    private final ClientPhaseController clientPhaseController = new ClientPhaseController(this);
    private final AtomicBoolean isConnectionAlive = new AtomicBoolean(false);
    private GameState phase = GameState.LOBBY;
    private boolean isPlaced = false;
    private final Boolean isSocket;
    private ScheduledFuture<?> heartbeatTask;
    private boolean recentTimerAsked = false;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r);
        t.setName("HeartbeatThread");
        t.setPriority(10);
        t.setDaemon(false);
        return t;
    });

    public boolean isRecentTimerAsked() {
        return this.recentTimerAsked;
    }

    public void setRecentTimerAsked(boolean recentTimerAsked) {
        this.recentTimerAsked = recentTimerAsked;
    }

    public GameState getPhase() {
        return this.phase;
    }

    public ClientModel getMyModel() {
        return this.myModel;
    }

    public void setCompletableFuture(CompletableFuture<NetworkMessage> completableFuture, int id) {
        this.completableFuture = completableFuture;
        this.pair = new Pair<Integer, CompletableFuture<NetworkMessage>>(id, completableFuture);
    }

    public ClientController(View view, Boolean flag) {
        this.myModel = new ClientModel();
        this.isSocket = flag;
        this.view = view;
        InputStream in = System.in;
        System.setIn(new FilterInputStream(this, in){

            @Override
            public void close() throws IOException {
                System.out.println("\u26a0\ufe0f QUALCOSA STA CHIUDENDO System.in!");
                super.close();
            }
        });
    }

    @Override
    public void update(NetworkMessage message) {
        message.accept(this.messageVisitor);
    }

    public void connectToServer(String address, int port) throws IOException, NotBoundException {
        if (this.isSocket.booleanValue()) {
            this.client = new ClientSocket(address, port);
            ((ClientSocket)this.client).create(address, port);
            ((ClientSocket)this.client).addObserver(this);
            ((ClientSocket)this.client).receiveMessage();
        } else {
            System.setProperty("java.rmi.server.hostname", NetworkingUtils.getLocalIP());
            this.client = new ClientRMI(address, port, this);
        }
        this.isConnectionAlive.set(true);
        this.heartbeatTask = this.scheduler.scheduleAtFixedRate(this.getHeartbeatTask(), 0L, 1L, TimeUnit.SECONDS);
    }

    private Runnable getHeartbeatTask() {
        return () -> {
            HeartbeatRequest heartbeatRequest = new HeartbeatRequest();
            this.safeSendMessage(heartbeatRequest);
        };
    }

    public void handleServerInfo(SERVER_INFO info) {
        try {
            this.connectToServer(info.getAddress(), info.getPort());
        }
        catch (IOException | NotBoundException e) {
            this.view.showGenericMessage("Couldn't connect you to the specified server. Try again.", false);
            this.view.askServerInfo();
            return;
        }
        new Thread(() -> this.view.askNickname()).start();
    }

    private boolean isNicknameLegal(String nickname) {
        if (nickname == null || nickname.trim().isEmpty()) {
            return false;
        }
        return nickname.matches("^[a-zA-Z0-9_]+$");
    }

    public void handleNicknameInput(String nickname) {
        if (!this.isNicknameLegal(nickname)) {
            this.view.showGenericMessage("Invalid nickname. It must contain only letters, numbers, or underscores.", false);
            this.view.askNickname();
            return;
        }
        NicknameRequest request = new NicknameRequest(nickname);
        CompletableFuture<NetworkMessage> future = new CompletableFuture<NetworkMessage>();
        this.setCompletableFuture(future, request.getID());
        this.setNickname(nickname);
        this.safeSendMessage(request);
    }

    public void handleNicknameResponse(NicknameResponse response) {
        if ("VALID".equals(response.getResponse())) {
            this.view.showGenericMessage("Nickname accepted.", false);
            this.view.askJoinOrCreateRoom();
        } else {
            this.setNickname(null);
            this.view.showGenericMessage("Nickname rejected. Try again.", false);
            this.view.askNickname();
        }
    }

    public void handleCreateOrJoinChoice(String choice) throws ExecutionException {
        switch (choice.toLowerCase()) {
            case "a": {
                this.view.askCreateRoom();
                break;
            }
            case "b": {
                this.handleJoinRoomOptionsChoice();
                break;
            }
            case "reset": {
                break;
            }
            default: {
                this.view.showGenericMessage("Invalid choice.", false);
                this.view.askJoinOrCreateRoom();
            }
        }
    }

    public void handleCreateChoice(int maxPlayers, boolean isLearningMatch) {
        CreateRoomRequest request = new CreateRoomRequest(maxPlayers, isLearningMatch, this.getNickname(), this.view.getViewType() == ViewType.GUI);
        CompletableFuture<NetworkMessage> future = new CompletableFuture<NetworkMessage>();
        this.setCompletableFuture(future, request.getID());
        if (!this.safeSendMessage(request)) {
            return;
        }
        this.view.showGenericMessage("Room creation request sent.", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleJoinRoomResponse(JoinRoomResponse response) {
        if (response.getOperationSuccess().booleanValue()) {
            this.clientPhaseController.setPhase(PLAYER_PHASE.LOBBY);
            this.myModel.getMyInfo().setColor(response.getColor());
            this.myModel.getMyInfo().setShip(response.getMyShip());
            this.myModel.getMyInfo().setNickName(this.getNickname());
            this.myModel.setLearningMatch(response.getIsLearningMatch());
            MenuManager.learningMatch = response.getIsLearningMatch();
            ArrayList<PlayerInfo> playerInfos = response.getPlayerInfos();
            if (playerInfos == null) {
                playerInfos = new ArrayList();
            }
            ArrayList<PlayerInfo> arrayList = this.myModel.getPlayerInfos();
            synchronized (arrayList) {
                this.myModel.getPlayerInfos().add(this.myModel.getMyInfo());
                this.myModel.setPlayerInfos(playerInfos);
            }
            this.view.showPlayersLobby(this.myModel.getMyInfo(), this.myModel.getPlayerInfos());
            this.view.showGenericMessage("Lobby joinata con successo, in attesa di giocatori...", false);
        } else {
            this.view.showGenericMessage("Room join failed: " + response.getErrMess(), true);
            this.view.askJoinOrCreateRoom();
        }
    }

    public void handleJoinRoomOptionsChoice() {
        JoiniRoomOptionsRequest request = new JoiniRoomOptionsRequest();
        CompletableFuture<NetworkMessage> future = new CompletableFuture<NetworkMessage>();
        this.setCompletableFuture(future, request.getID());
        this.safeSendMessage(request);
    }

    public void handleJoinRoomOptionsResponse(JoinRoomOptionsResponse response) {
        ArrayList<LobbyInfo> lobbies = response.getLobbyInfos();
        if (lobbies.isEmpty()) {
            this.view.showLobbies(lobbies);
        } else {
            this.view.showLobbies(lobbies);
            this.view.askRoomCode();
        }
    }

    public void handleJoinChoice(int roomId) {
        JoinRoomRequest request = new JoinRoomRequest(roomId, this.getNickname(), this.view.getViewType() == ViewType.GUI);
        CompletableFuture<NetworkMessage> future = new CompletableFuture<NetworkMessage>();
        this.setCompletableFuture(future, request.getID());
        this.safeSendMessage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePlayerJoinedUpdate(PlayerJoinedUpdate playerJoinedUpdate) {
        ArrayList<PlayerInfo> arrayList = this.myModel.getPlayerInfos();
        synchronized (arrayList) {
            this.myModel.setPlayerInfos(playerJoinedUpdate.getPlayersJoinedBefore());
        }
        this.view.showPlayerJoined(playerJoinedUpdate.getPlayerInfo());
        this.view.showPlayersLobby(this.myModel.getMyInfo(), this.myModel.getPlayerInfos());
    }

    public void handlePhaseUpdate(PhaseUpdate phaseUpdate) {
        this.phase = phaseUpdate.getState();
        this.recentTimerAsked = false;
        if (this.phase.equals((Object)GameState.FLIGHT)) {
            this.myModel.setPlayerState(PlayerState.Playing);
        }
        if (this.phase.equals((Object)GameState.BUILDING_END)) {
            if (this.clientPhaseController.getPhase().equals((Object)PLAYER_PHASE.FINISH_BUILDING)) {
                return;
            }
            if (this.clientPhaseController.getPhase().equals((Object)PLAYER_PHASE.BUILDING_TIMER) || this.clientPhaseController.getPhase().equals((Object)PLAYER_PHASE.BUILDING)) {
                this.view.forceReset();
                this.clientPhaseController.setPhase(PLAYER_PHASE.FINISH_BUILDING);
                FinishBuildingRequest finishBuildingRequest = new FinishBuildingRequest(this.myModel.getMyInfo().getShip(), this.myModel.getMyInfo().getShip().getLastTile());
                finishBuildingRequest.name = this.getNickname();
                this.safeSendMessage(finishBuildingRequest);
                return;
            }
            this.view.handlePhaseUpdate(phaseUpdate);
            return;
        }
        this.clientPhaseController.handlePhaseUpdate(phaseUpdate);
        this.view.handlePhaseUpdate(phaseUpdate);
    }

    public void handleBuildingMenuChoice(String input) {
        switch (input) {
            case "menu": 
            case "?": 
            case "m": {
                this.view.toShowCurrentMenu();
                this.view.handleChoiceForPhase(this.phase);
                break;
            }
            case "a": {
                this.view.askFetchShip();
                break;
            }
            case "b": {
                if (!this.myModel.isLearningMatch()) {
                    if (this.isPlaced || this.currentTileInHand == null) {
                        this.sendShipUpdate();
                        this.view.askViewAdventureDecks();
                        break;
                    }
                    this.view.showGenericMessage("Hai una tile in mano, per favore posizionala prima.", false);
                    this.view.showBuildingMenu();
                    break;
                }
                this.view.showGenericMessage("You are not allowed to spy on the learningMatch!", false);
                this.view.showBuildingMenu();
                break;
            }
            case "c": {
                this.view.askShowFaceUpTiles();
                this.view.showBuildingMenu();
                break;
            }
            case "d": {
                if (this.currentTileInHand != null) {
                    this.view.showGenericMessage("You already have a tile in hand! Place it or discard it before drawing a new one.", false);
                    this.view.showBuildingMenu();
                    break;
                }
                this.isPlaced = false;
                this.view.askDrawTile();
                break;
            }
            case "e": {
                this.showTileInHand();
                break;
            }
            case "f": {
                if (this.currentTileInHand == null) {
                    this.view.showGenericMessage("Before setting a rotation, you need to draw a tile.", false);
                    this.view.showBuildingMenu();
                    break;
                }
                this.view.askRotation();
                break;
            }
            case "g": {
                this.view.askTilePlacement();
                break;
            }
            case "h": {
                this.sendDiscardRequest();
                break;
            }
            case "i": {
                this.clientPhaseController.setPhase(PLAYER_PHASE.FINISH_BUILDING);
                FinishBuildingRequest finishBuildingRequest = new FinishBuildingRequest(this.myModel.getMyInfo().getShip(), this.myModel.getMyInfo().getShip().getLastTile());
                finishBuildingRequest.name = this.getNickname();
                this.safeSendMessage(finishBuildingRequest);
                break;
            }
            case "j": {
                this.recentTimerAsked = true;
                this.sendAskTimerInfoRequest();
                break;
            }
            case "reset": {
                break;
            }
            default: {
                new Thread(() -> {
                    this.view.showGenericMessage("Invalid option \"" + input + "\". Please try again.", false);
                    this.view.showBuildingMenu();
                }).start();
            }
        }
    }

    public void handleFinishedBuildingMenuChoice(String input) {
        switch (input) {
            case "menu": 
            case "?": 
            case "m": {
                this.view.toShowCurrentMenu();
                this.view.handleChoiceForPhase(this.phase);
                break;
            }
            case "a": {
                this.view.askFetchShip();
                break;
            }
            case "b": {
                if (!this.myModel.isLearningMatch()) {
                    if (this.isPlaced || this.currentTileInHand == null) {
                        this.sendShipUpdate();
                        this.view.askViewAdventureDecks();
                        break;
                    }
                    this.view.showGenericMessage("Hai una tile in mano, per favore posizionala prima.", false);
                    this.view.showFinishedBuildingMenu();
                    break;
                }
                this.view.showGenericMessage("You are not allowed to spy on the learningMatch!", false);
                this.view.showFinishedBuildingMenu();
                break;
            }
            case "c": {
                this.view.askShowFaceUpTiles();
                this.view.showFinishedBuildingMenu();
                break;
            }
            case "j": {
                this.recentTimerAsked = true;
                this.sendAskTimerInfoRequest();
                break;
            }
            case "reset": {
                break;
            }
            default: {
                new Thread(() -> {
                    this.view.showGenericMessage("Invalid option \"" + input + "\". Please try again.", false);
                    this.view.showFinishedBuildingMenu();
                }).start();
            }
        }
    }

    public void sendShipUpdate() {
        if (this.myModel.getMyInfo().getShip().getLastTile() != null) {
            ShipUpdate update = new ShipUpdate(this.myModel.getMyInfo().getShip(), this.myModel.getMyInfo().getNickName());
            this.currentPosition = null;
            this.currentTileInHand = null;
            update.setOnlyFix(true);
            this.safeSendMessage(update);
        }
    }

    public void handleFetchShip(String targetNickname) {
        boolean exists = this.myModel.hasPlayerWithNickname(targetNickname);
        if (exists) {
            if (this.myModel.getMyInfo().getNickName().equals(targetNickname)) {
                this.view.showShip(this.myModel.getMyInfo().getShip(), this.myModel.getMyInfo().getNickName());
                this.view.handleChoiceForPhase(this.phase);
            } else {
                Ship targetShip = this.myModel.getPlayerInfoByNickname(targetNickname).getShip();
                this.view.showShip(targetShip, targetNickname);
                this.view.handleChoiceForPhase(this.phase);
            }
        } else {
            this.view.showGenericMessage("No player with nickname " + targetNickname + " found. Please try again.", false);
            this.view.askFetchShip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleShipUpdate(ShipUpdate update) {
        String owner = update.getNickName();
        Ship ship = update.getShipView();
        if (this.phase == GameState.FLIGHT && update.getLoadMerci().booleanValue()) {
            this.view.askLoadGoodChoice();
        }
        if (owner != null) {
            if (this.getNickname().equals(owner)) {
                PlayerInfo playerInfo = this.myModel.getMyInfo();
                synchronized (playerInfo) {
                    this.myModel.getMyInfo().setShip(ship);
                }
            }
            ArrayList<PlayerInfo> arrayList = this.myModel.getPlayerInfos();
            synchronized (arrayList) {
                PlayerInfo playerInfo = this.myModel.getPlayerInfoByNickname(owner);
                if (playerInfo != null) {
                    playerInfo.setShip(ship);
                } else {
                    this.view.showGenericMessage("Player with nickname " + owner + " not found.", false);
                }
            }
            if (update.getShouldDisplay().booleanValue()) {
                this.view.autoShowShipInTui(ship, owner);
            }
            if (this.view.autoShowUpdates().booleanValue()) {
                this.view.showShip(ship, owner);
                System.out.println("Debug: stampo ultimo shipUpdate");
                ShipPrintUtils.printShip(ship);
            }
        } else {
            this.view.showGenericMessage("No ship belongs to this player.", false);
            this.view.handleChoiceForPhase(this.phase);
        }
    }

    public Boolean viewAdventureCardDeck(int DeckID) {
        boolean allowed = false;
        ArrayList<CardDeck> cardDecks = this.myModel.getCardDecks();
        if (!cardDecks.isEmpty()) {
            if (cardDecks.size() <= DeckID) {
                this.view.showGenericMessage("Numero del deck non valido", false);
            } else {
                CardDeck deck = cardDecks.get(DeckID);
                boolean spyable = deck.isSpyable();
                if (spyable) {
                    int colums = 3;
                    CardPrintUtils.printDeck(deck, colums);
                    this.view.showGenericMessage("Deck  " + ++DeckID + " received successfully. ", false);
                    allowed = true;
                } else {
                    this.view.showGenericMessage("You are not allowed to spy on this deck!", false);
                }
            }
        } else {
            this.view.showGenericMessage("No card decks found.", false);
        }
        this.view.showBuildingMenu();
        return allowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFaceUpTileUpdate(FaceUpTileUpdate update) {
        ArrayList<Tile> faceUpTiles = update.getFaceUpTiles();
        ArrayList<Tile> arrayList = this.myModel.getFaceUpTiles();
        synchronized (arrayList) {
            this.myModel.setFaceUpTiles(faceUpTiles);
        }
        this.view.handleFaceUpTilesUpdate();
    }

    public void sendAskTimerInfoRequest() {
        AskTimerInfoRequest askTimerInfoRequest = new AskTimerInfoRequest();
        this.safeSendMessage(askTimerInfoRequest);
    }

    public void handleTimerInfoResponse(TimerInfoResponse timerInfoResponse) {
        this.myModel.getTimerInfos().clear();
        this.myModel.getTimerInfos().addAll(timerInfoResponse.getTimerInfoList());
        this.view.showTimerInfos(this.myModel.getTimerInfos(), this.clientPhaseController.getPhase());
        if (timerInfoResponse.getLast().booleanValue() && PLAYER_PHASE.isBefore(this.clientPhaseController.getPhase(), PLAYER_PHASE.FINISH_BUILDING).booleanValue()) {
            this.handlePhaseUpdate(new PhaseUpdate(GameState.BUILDING_END));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canFlipHourglass() {
        boolean oneActive = false;
        int numFlipped = 0;
        ArrayList<TimerInfo> arrayList = this.myModel.getTimerInfos();
        synchronized (arrayList) {
            for (TimerInfo timerInfo : this.myModel.getTimerInfos()) {
                if (timerInfo.getTimerStatus().equals((Object)TimerStatus.STARTED)) {
                    oneActive = true;
                }
                if (!timerInfo.isFlipped()) continue;
                ++numFlipped;
            }
        }
        return !oneActive && (numFlipped != 2 || this.clientPhaseController.getPhase().equals((Object)PLAYER_PHASE.FINISH_BUILDING));
    }

    public void handleDrawFaceDownTile() {
        if (this.currentTileInHand == null || this.isPlaced) {
            this.sendShipUpdate();
        }
        DrawTileRequest request = new DrawTileRequest();
        this.safeSendMessage(request);
    }

    public void handleDrawTileResponse(DrawTileResponse response) {
        String error;
        String string = error = response.getErrorMessage();
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"VALID", "EMPTY", "INVALID_STATE", "FIXED", "NO_TILE", "NO_TILE_AT_INDEX"}, (String)string, n)) {
            case 0: {
                Tile drawnTile = response.getTile();
                if (drawnTile == null) break;
                this.view.showTile(drawnTile);
                ComponentNameVisitor visitor = new ComponentNameVisitor();
                Component c = drawnTile.getMyComponent();
                String name = c.accept(visitor);
                int id = drawnTile.getId();
                this.currentTileInHand = drawnTile;
                this.currentPosition = null;
                this.view.showGenericMessage("You drew a " + name + " tile.ID: " + id, false);
                break;
            }
            case 1: {
                this.view.showGenericMessage("The tile bunch is empty.", false);
                break;
            }
            case 2: {
                this.view.showGenericMessage("You cannot draw a tile right now.", false);
                break;
            }
            case 3: {
                this.view.showGenericMessage("The tile is fixed.", false);
                break;
            }
            case 4: {
                this.view.showGenericMessage("You don't have any reclaimable tile.", false);
                break;
            }
            case 5: {
                this.view.showGenericMessage("No tile at that index.", false);
                break;
            }
            default: {
                this.view.showGenericMessage("Unexpected response while drawing tile: " + error, false);
            }
        }
        this.view.showBuildingMenu();
    }

    public void startChooseTile() {
        ArrayList<Tile> tiles = this.myModel.getFaceUpTiles();
        if (tiles == null || tiles.isEmpty()) {
            this.view.showGenericMessage("No face-up tiles available.", false);
            this.view.showBuildingMenu();
            return;
        }
        this.view.showGenericMessage("--Current face-up tiles--", false);
        this.view.showFaceUpTiles();
        this.view.askChooseTile();
    }

    public void handleChooseFaceUpTile(Tile tile) {
        this.sendShipUpdate();
        DrawTileRequest request = new DrawTileRequest(tile);
        CompletableFuture<NetworkMessage> future = new CompletableFuture<NetworkMessage>();
        this.setCompletableFuture(future, request.getID());
        this.safeSendMessage(request);
    }

    public void reclaimTile() {
        DrawTileRequest request = DrawTileRequest.reclaimLastTileRequest();
        CompletableFuture<NetworkMessage> future = new CompletableFuture<NetworkMessage>();
        this.setCompletableFuture(future, request.getID());
        this.safeSendMessage(request);
    }

    public void handleDrawReservedTile(int slotIndex) {
        this.sendShipUpdate();
        DrawTileRequest request = DrawTileRequest.fromReservedSlot(slotIndex);
        CompletableFuture<NetworkMessage> future = new CompletableFuture<NetworkMessage>();
        this.setCompletableFuture(future, request.getID());
        this.safeSendMessage(request);
    }

    public void showTileInHand() {
        this.view.showTile(this.currentTileInHand);
        this.view.showBuildingMenu();
    }

    public void rotateCurrentTile(int rotation) {
        if (this.currentTileInHand != null) {
            this.currentTileInHand.rotate(rotation);
            this.view.showTile(this.currentTileInHand);
            this.view.showGenericMessage("Tile rotated successfully.", false);
        }
        this.view.showBuildingMenu();
    }

    public void setTmpCurrentPosition(Position tmpCurrentPosition1) {
        this.tmpCurrentPosition = tmpCurrentPosition1;
    }

    public void resetCurrentPos() {
        this.currentPosition = null;
    }

    public void setCurrentPos(int x, int y) {
        Position pos = new Position(x, y);
        Ship ship = this.myModel.getMyInfo().getShip();
        if (!Util.inBoundaries(pos.getX(), pos.getY()).booleanValue() || ship.getInvalidPositions().contains(pos)) {
            throw new IllegalArgumentException("Invalid Position" + pos.toOffsetString());
        }
        this.currentPosition = pos;
    }

    public void handleTilePlacement() {
        if (this.currentTileInHand == null) {
            this.view.showGenericMessage("No tile selected.", false);
            this.view.showBuildingMenu();
            return;
        }
        Tile appInHand = this.currentTileInHand;
        this.currentTileInHand = null;
        this.isPlaced = true;
        this.view.showTile(this.currentTileInHand);
        PlaceTileRequest request = new PlaceTileRequest(appInHand, this.currentPosition);
        CompletableFuture<NetworkMessage> future = new CompletableFuture<NetworkMessage>();
        this.setCompletableFuture(future, request.getID());
        this.safeSendMessage(request);
    }

    public void handlePlaceTileResponse(PlaceTileResponse response) {
        this.view.showGenericMessage(response.getMessage(), false);
        switch (response.getMessage()) {
            case "INVALID_STATE": {
                this.currentPosition = this.tmpCurrentPosition;
                this.view.showGenericMessage("You cannot place a tile right now.", false);
                break;
            }
            case "INVALID_POS": {
                this.currentPosition = this.tmpCurrentPosition;
                this.view.showGenericMessage("You cannot place a tile in that position. invalid pos", false);
                break;
            }
            case "OCCUPIED_POS": {
                this.currentPosition = this.tmpCurrentPosition;
                this.view.showGenericMessage("You cannot place a tile in that position. occupied pos", false);
                break;
            }
            case "VALID": {
                this.resetCurrentPos();
                this.currentTileInHand = null;
                this.isPlaced = true;
                this.view.showTile(null);
                break;
            }
            default: {
                this.isPlaced = false;
                this.view.showTile(this.currentTileInHand);
            }
        }
        this.view.showBuildingMenu();
    }

    private void handlePlaceReservedTile(int slotIndex) {
        if (this.currentTileInHand == null) {
            this.view.showGenericMessage("No tile selected.", false);
            this.view.showBuildingMenu();
            return;
        }
        PlaceTileRequest request = new PlaceTileRequest(this.currentTileInHand, slotIndex);
        CompletableFuture<NetworkMessage> future = new CompletableFuture<NetworkMessage>();
        this.setCompletableFuture(future, request.getID());
        this.safeSendMessage(request);
    }

    public void sendDiscardRequest() {
        if (this.currentTileInHand == null) {
            this.view.showGenericMessage("No tile in hand to discard.", false);
            this.view.showBuildingMenu();
            return;
        }
        int initRotation = this.currentTileInHand.getRotation();
        this.currentTileInHand.rotate(-initRotation);
        DiscardTileRequest request = new DiscardTileRequest(this.currentTileInHand);
        if (!this.safeSendMessage(request)) {
            return;
        }
        this.currentTileInHand = null;
        this.currentPosition = null;
        this.view.showGenericMessage("Tile discarded successfully.", false);
        this.view.showBuildingMenu();
    }

    public void handlePickReservedTile(int slotIndex, boolean isPicking) {
        Tile[] reservedTiles = this.getReservedTiles();
        Tile tile = reservedTiles[slotIndex];
        if (isPicking) {
            if (tile == null) {
                int toShowIndex = slotIndex + 1;
                this.view.showGenericMessage("No reserved tile at slot " + toShowIndex + ".", false);
                this.view.showBuildingMenu();
            } else {
                this.handleDrawReservedTile(slotIndex);
            }
        } else if (tile == null) {
            this.handlePlaceReservedTile(slotIndex);
        } else {
            this.view.showGenericMessage("A tile is already reserved at slot " + slotIndex + ".", false);
            this.view.showBuildingMenu();
        }
    }

    public boolean hasTileInHand() {
        return this.getCurrentTileInHand() != null;
    }

    public void handleDecksUpdate(DecksUpdate decksUpdate) {
        this.myModel.setCardDecks(decksUpdate.getDecks());
    }

    public void handleFlightBoardUpdate(FlightBoardUpdate flightBoardUpdate) {
        this.myModel.setFlightBoard(flightBoardUpdate.getFlightBoard());
        if (this.phase == GameState.FLIGHT && this.view.autoShowUpdates().booleanValue()) {
            this.view.showFlightBoard(this.myModel.getFlightBoard(), this.myModel.getPlayerInfos(), this.myModel.getMyInfo());
        }
    }

    public void handleAskPositionUpdate(AskPositionUpdate askPositionUpdate) {
        new Thread(() -> this.view.askFlightBoardPosition(askPositionUpdate.getValidPositions(), askPositionUpdate.getID())).start();
    }

    public boolean getIsSocket() {
        return this.isSocket;
    }

    public void handleCheckShipChoice(String input) {
        new Thread(() -> {
            switch (input) {
                case "a": {
                    this.view.showShip(this.myModel.getMyInfo().getShip(), this.myModel.getMyInfo().getNickName());
                    this.view.showCheckShipMenu();
                    break;
                }
                case "b": {
                    if (this.myModel.getMyInfo().getShip().remainingTiles() > 1) {
                        this.view.askRemoveTile(this.myModel.getMyInfo().getShip());
                        break;
                    }
                    System.out.println("OPTION DISABLED< YOU HAVE NO TILE");
                    this.view.showCheckShipMenu();
                    break;
                }
                case "c": {
                    this.handleCheckShipRequest();
                    break;
                }
                case "menu": 
                case "m": 
                case "?": {
                    this.view.handleChoiceForPhase(this.phase);
                    break;
                }
                default: {
                    this.view.showGenericMessage("Invalid option. Please try again.", false);
                    this.view.showCheckShipMenu();
                }
            }
        }).start();
    }

    public void handleCheckShipRequest() {
        CheckShipStatusRequest checkShipStatusRequest = new CheckShipStatusRequest();
        checkShipStatusRequest.setRemovedTilesId(this.myModel.getTilesToRemove());
        this.safeSendMessage(checkShipStatusRequest);
    }

    public void handleCheckShipStatusResponse(CheckShipStatusResponse response) {
        boolean isValid = response.getIsValid();
        if (isValid) {
            this.view.showWaitOtherPlayers();
            this.view.showGenericMessage("Nave immacolata!", true);
            return;
        }
        this.view.showGenericMessage("La nave va ricontrollata", true);
        this.myModel.getMyInfo().setShip(response.getShip());
        this.view.showCheckShipMenu();
    }

    public void handleEmbarkCrewMenu(String string) {
        new Thread(() -> {
            switch (string) {
                case "a": {
                    this.view.showShip(this.myModel.getMyInfo().getShip(), this.myModel.getMyInfo().getNickName());
                    this.view.showEmbarkCrewMenu();
                    break;
                }
                case "b": {
                    try {
                        this.view.chooseCrew(this.myModel.getMyInfo().getShip());
                        break;
                    }
                    catch (InvalidTilePosition | PlayerAlreadyExistsException | TooManyPlayersException | IOException | InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                case "menu": 
                case "m": 
                case "?": {
                    this.view.handleChoiceForPhase(this.phase);
                    break;
                }
                default: {
                    this.view.showGenericMessage("Invalid option. Please try again.", false);
                    this.view.showEmbarkCrewMenu();
                }
            }
        }).start();
    }

    public void handleEndTurnUpdate(EndTurnUpdate update) {
        this.view.showGenericMessage("Turn ended", false);
        if (update.isEndGame()) {
            this.view.showGenericMessage("Game ended", false);
            return;
        }
        this.view.toShowCurrentMenu();
        if (this.myModel.getPlayerState() != PlayerState.Spectating) {
            this.view.showGenericMessage("Il turno \u00e8 finito!", false);
            this.view.showFlightMenu();
        } else {
            this.handleReadyTurnRequest();
        }
    }

    public void handleFlightMenuChoice(String input) throws RuntimeException {
        new Thread(() -> {
            switch (input) {
                case "RESET": {
                    break;
                }
                case "a": {
                    this.view.askFetchShip();
                    break;
                }
                case "b": {
                    this.view.showFlightBoard(this.myModel.getFlightBoard(), this.myModel.getPlayerInfos(), this.myModel.getMyInfo());
                    this.view.handleChoiceForPhase(this.phase);
                    break;
                }
                case "c": {
                    this.handleEarlyLandingRequest();
                    break;
                }
                case "d": {
                    this.handleReadyTurnRequest();
                    break;
                }
                case "menu": 
                case "m": 
                case "?": {
                    this.view.handleChoiceForPhase(this.phase);
                    break;
                }
                default: {
                    this.view.showGenericMessage("Invalid option. Please try again.", false);
                    this.view.handleChoiceForPhase(this.phase);
                }
            }
        }).start();
    }

    public void handleEarlyLandingRequest() {
        EarlyLandingRequest request = new EarlyLandingRequest();
        this.safeSendMessage(request);
        this.view.showGenericMessage("Hai scelto l\u2019atterraggio anticipato, ora guarda gli altri giocatori.", false);
        this.view.showYouAreNowSpectating();
    }

    public void handleReadyTurnRequest() {
        ReadyTurnRequest request = new ReadyTurnRequest();
        this.safeSendMessage(request);
        this.view.showGenericMessage(" Devi aspettare che gli altri giocatori siano pronti.", false);
    }

    public void handleGameMessage(GameMessage gameMessage) {
        this.view.showGenericMessage(gameMessage.getMessage(), false);
    }

    public void handleMatchInfoUpdate(MatchInfoUpdate matchInfoUpdate) {
        int remainCards = matchInfoUpdate.getRemainingCards();
        String leaderNickname = matchInfoUpdate.getLeaderNickname();
        boolean amLeader = leaderNickname.equals(this.getNickname());
        this.myModel.setLeader(amLeader);
        this.view.showGenericMessage("Il giocatore: " + leaderNickname + " \u00e8 il leader, rimangono: " + remainCards + "  carte.", false);
        if (amLeader) {
            this.view.askDrawCard();
        } else {
            this.view.showGenericMessage("Non sei leader per questo turno. Devi aspettare che il leader peschi la carta.", false);
        }
    }

    public void sendDrawAdventureCardRequest() {
        DrawAdventureCardRequest request = new DrawAdventureCardRequest();
        this.safeSendMessage(request);
    }

    public void handleDrawnAdventureCardUpdate(DrawnAdventureCardUpdate drawnAdventureCardUpdate) {
        this.view.forceReset();
        this.myModel.setCurrentAdventureCard(drawnAdventureCardUpdate.getCard());
        this.view.showCurrentAdventureCard();
    }

    public void handleActivateAdventureCardRequest(ActivateAdventureCardRequest ignoredActivateAdventureCardRequest) {
        this.view.askActivateAdventureCard();
    }

    public void sendActivateAdventureCardResponse(boolean confirm) {
        ActivateAdventureCardResponse response = new ActivateAdventureCardResponse(confirm);
        if (!this.safeSendMessage(response)) {
            return;
        }
        if (confirm && "Stazione abbandonata".equals(this.getCurrentAdventureCard().getName())) {
            AbandonedStation abandonedStation = (AbandonedStation)this.getCurrentAdventureCard();
            this.myModel.setUnplacedGoods(abandonedStation.getGoods());
            this.view.askLoadGoodChoice();
        }
    }

    public void handleSelectPlanetRequest(SelectPlanetRequest request) {
        HashMap<Integer, Planet> landablePlanets = request.getLandablePlanets();
        this.view.askSelectPlanetChoice(landablePlanets);
    }

    public void sendSelectPlanetResponse(Planet planet, int planetIndex) {
        SelectPlanetResponse response = new SelectPlanetResponse(planet, planetIndex);
        this.safeSendMessage(response);
    }

    public void handleSelectPlanetUpdate(SelectedPlanetUpdate update) {
        String selectingPlayerNickname = update.getSelectingPlayerNickname();
        this.view.showGenericMessage("Player " + selectingPlayerNickname + " ha selezionato il pianeta " + update.getPlanetIndex(), false);
        if (selectingPlayerNickname.equals(this.getNickname())) {
            Planet selectedPlanet = update.getSelectedPlanet();
            this.myModel.setSelectedPlanet(selectedPlanet);
            this.myModel.setUnplacedGoods(selectedPlanet.getGoods());
        }
    }

    public void handleLoadGoodChoice(String input) {
        if (input == null) {
            return;
        }
        switch (input.toLowerCase()) {
            case "l": {
                this.view.askSelectGoodToLoad(this.myModel.getUnplacedGoods(), this.myModel.getMyInfo().getShip());
                break;
            }
            case "d": {
                this.view.askSelectGoodToDiscard(this.myModel.getMyInfo().getShip());
                break;
            }
            case "f": {
                this.view.showGenericMessage(" Caricamento merci completato.", false);
                try {
                    this.sendShipForGoodUpdate();
                }
                catch (Exception e) {
                    this.view.showGenericMessage("Errore durante l'invio della nave: " + e.getMessage(), false);
                }
                break;
            }
            default: {
                this.view.showGenericMessage(" Comando non riconosciuto. Usa L, D o F.", false);
            }
        }
    }

    public void placeMerci(int goodIndex, Good good, Position pos) {
        Ship ship = this.myModel.getMyInfo().getShip();
        Slot slot = ship.getShipBoard()[pos.getX()][pos.getY()];
        GenericCargoHolds hold = (GenericCargoHolds)slot.getTile().getMyComponent();
        hold.playerLoadGood(good);
        this.myModel.getSelectedPlanet().getGoods().remove(goodIndex);
    }

    public void sendShipForGoodUpdate() {
        ShipUpdate update = new ShipUpdate(this.myModel.getMyInfo().getShip(), this.myModel.getMyInfo().getNickName());
        this.safeSendMessage(update);
    }

    public ArrayList<Good> getDiscardPositionGoods(Position pos) {
        Ship ship = this.getMyShip();
        Slot slot = this.getSlot(ship, pos);
        GenericCargoHolds hold = (GenericCargoHolds)slot.getTile().getMyComponent();
        return hold.getGoods();
    }

    public void discardGood(int GoodIndex, Position pos) {
        Slot slot = this.getSlot(this.getMyShip(), pos);
        GenericCargoHolds hold = (GenericCargoHolds)slot.getTile().getMyComponent();
        hold.removeGood(hold.getGoods().get(GoodIndex));
    }

    public void handleActivateComponentRequest(ActivateComponentRequest request) {
        ActivatableComponent component = request.getActivatableComponentType();
        String componentName = switch (component) {
            default -> throw new MatchException(null, null);
            case ActivatableComponent.DoubleCannon -> "DoubleCannon";
            case ActivatableComponent.DoubleEngine -> "DoubleEngine";
            case ActivatableComponent.Shield -> "Shield";
        };
        Ship myShip = this.getMyShip();
        ArrayList<Position> activateComponentPosition = myShip.getComponentPositionsFromName(componentName);
        if (activateComponentPosition == null || activateComponentPosition.isEmpty()) {
            this.handleActivateComponentResponse(component, null, null);
        } else {
            try {
                this.view.chooseComponent(this.myModel.getMyInfo().getShip(), component);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void handleActivateComponentResponse(ActivatableComponent component, ArrayList<Position> componentPos, ArrayList<Position> battPos) {
        ActivateComponentResponse resp = new ActivateComponentResponse(component, componentPos, battPos);
        this.safeSendMessage(resp);
    }

    public void handleDiscardCrewMembersRequest(DiscardCrewMembersRequest request) {
        try {
            this.view.chooseDiscardCrew(this.myModel.getMyInfo().getShip(), request.getNumberOfCrewMembersToDiscard());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void handleDiscardCrewMembersResponse(ArrayList<Position> housingPos) {
        DiscardCrewMembersResponse resp = new DiscardCrewMembersResponse(housingPos);
        this.safeSendMessage(resp);
    }

    public void handlePlayerKickedUpdate(PlayerKickedUpdate playerKickedUpdate) {
        if (playerKickedUpdate.getNickname().equals(this.getNickname())) {
            this.view.showGenericMessage("You've been kicked from the game!", false);
        } else {
            this.view.showGenericMessage(playerKickedUpdate.getNickname() + " got kicked out of the game!", false);
        }
        this.view.showGenericMessage("As " + playerKickedUpdate.getNickname() + " left the game, it has ended prematurely and you'll have search for another one.", true);
        this.backToMainMenu();
    }

    private void backToMainMenu() {
        this.view.askJoinOrCreateRoom();
        this.view.showGenericMessage("", false);
        PlayerInfo myInfo = new PlayerInfo();
        myInfo.setNickName(this.myModel.getMyInfo().getNickName());
        this.myModel = new ClientModel();
        this.myModel.setMyInfo(myInfo);
        this.phase = GameState.LOBBY;
    }

    public void handleAskTrunkRequest(AskTrunkRequest askTrunkRequest) {
        ArrayList<Ship> Trunks = askTrunkRequest.getTrunks();
        try {
            this.view.chooseTroncone(Trunks);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void handleTrunkResponse(int choice) {
        AskTrunkResponse response = new AskTrunkResponse(choice, this.myModel.getMyInfo().getNickName());
        this.safeSendMessage(response);
    }

    public void sendCollectRewardsResponse(boolean confirm) {
        CollectRewardsResponse response = new CollectRewardsResponse(confirm);
        if (!this.safeSendMessage(response)) {
            return;
        }
        if (confirm && "Contrabbandieri".equals(this.getCurrentAdventureCard().getName())) {
            Smugglers smugglers = (Smugglers)this.getCurrentAdventureCard();
            this.myModel.setUnplacedGoods(smugglers.getGoods());
            this.view.askLoadGoodChoice();
        }
    }

    public void handleCollectRewardsRequest(CollectRewardsRequest ignoredrequest) {
        this.view.askCollectRewards();
    }

    public AdventureCard getCurrentAdventureCard() {
        return this.myModel.getCurrentAdventureCard();
    }

    public void handleCrewInitUpdate(CrewInitUpdate crewInitUpdate) {
        this.safeSendMessage(crewInitUpdate);
    }

    public ArrayList<Position> getOccupiedCargoHolds(Ship ship) {
        ArrayList<Position> cargoHolds = this.getCargoHolds(ship);
        ArrayList<Position> occupied = new ArrayList<Position>();
        for (Position pos : cargoHolds) {
            Component c;
            Slot slot = ship.getShipBoard()[pos.getX()][pos.getY()];
            if (slot == null || slot.getTile() == null || !(c = slot.getTile().getMyComponent()).accept(new ComponentNameVisitor()).equalsIgnoreCase("GenericCargoHolds") || !((GenericCargoHolds)c).isFull()) continue;
            occupied.add(pos);
        }
        return occupied;
    }

    public void handleGameEndUpdate(GameEndUpdate update) {
        ArrayList<PlayerScore> scores = update.getScores();
        this.view.showEndGame(scores);
    }

    public void handlePlayerLostUpdate(PlayerLostUpdate update) {
        String nickname = update.getNickname();
        if (nickname.equals(this.getNickname())) {
            this.myModel.setPlayerState(PlayerState.Spectating);
            this.view.showYouAreNowSpectating();
        }
        String message = nickname + " ha perso: ";
        switch (update.getReason()) {
            case Quit: {
                message = message + "ha deciso di atterrare in anticipo.";
                break;
            }
            case NoCrewMembersLeft: {
                message = message + "non aveva pi\u00f9 membri dell'equipaggio a disposizione.";
                break;
            }
            case Lapped: {
                message = message + "\u00e8 stato doppiato.";
                break;
            }
            case ZeroEnginePower: {
                message = message + "non aveva potenza motrice.";
                break;
            }
            default: {
                message = message + "le ragioni rimangono tutt'ora ignote.";
            }
        }
        this.view.showGenericMessage(message, true);
    }

    public Ship getMyShip() {
        return this.myModel.getMyInfo().getShip();
    }

    public void setShip(Ship ship) {
        this.myModel.getMyInfo().setShip(ship);
        this.sendShipUpdate();
    }

    private Slot getSlot(Ship ship, Position pos) {
        return ship.getShipBoard()[pos.getX()][pos.getY()];
    }

    private ArrayList<Position> getCargoHolds(Ship ship) {
        return ship.getComponentPositionsFromName("GenericCargoHolds");
    }

    public ArrayList<Position> getAvailableCargoHolds(Ship ship, Good good) {
        ArrayList<Position> cargoHolds = this.getCargoHolds(ship);
        ArrayList<Position> available = new ArrayList<Position>();
        for (Position pos : cargoHolds) {
            GenericCargoHolds hold;
            Component c;
            Slot slot = ship.getShipBoard()[pos.getX()][pos.getY()];
            if (slot == null || slot.getTile() == null || !((c = slot.getTile().getMyComponent()) instanceof GenericCargoHolds) || (hold = (GenericCargoHolds)c).isFull()) continue;
            if (good.getColor() == Color.RED) {
                if (!hold.isSpecial().booleanValue()) continue;
                available.add(pos);
                continue;
            }
            available.add(pos);
        }
        return available;
    }

    public Client getClient() {
        return this.client;
    }

    public void setView(View v) {
        this.view = v;
    }

    public View getView() {
        return this.view;
    }

    public void setNickname(String nickname) {
        this.myModel.getMyInfo().setNickName(nickname);
    }

    public String getNickname() {
        return this.myModel.getMyInfo().getNickName();
    }

    public Tile getCurrentTileInHand() {
        return this.currentTileInHand;
    }

    public Position getCurrentPosition() {
        return this.currentPosition;
    }

    public Tile[] getReservedTiles() {
        return this.myModel.getReservedTiles();
    }

    public void sendFlipRequest() {
        FlipTimerRequest flipTimerRequest = new FlipTimerRequest();
        this.safeSendMessage(flipTimerRequest);
    }

    public boolean safeSendMessage(NetworkMessage message) {
        if (!this.isConnectionAlive.get()) {
            return false;
        }
        try {
            this.client.sendMessage(message);
            return true;
        }
        catch (IOException e) {
            if (this.isConnectionAlive.getAndSet(false)) {
                this.startOver();
            }
            return false;
        }
    }

    public void startOver() {
        if (this.heartbeatTask != null && !this.heartbeatTask.isCancelled()) {
            this.heartbeatTask.cancel(true);
        }
        this.myModel = new ClientModel();
        MenuManager.clearConsole();
        this.view.forceReset();
        this.view.showGenericMessage("Connessione al server persa, verrai riportato alla schermata di connessione.", true);
        new Thread(() -> this.view.askServerInfo()).start();
    }
}

