/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import java.util.Objects;
import javafx.animation.Interpolatable;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableObjectProperty<T>
extends ObjectPropertyBase<T>
implements StyleableProperty<T> {
    private StyleOrigin origin = null;
    private TransitionMediatorImpl mediator = null;

    public StyleableObjectProperty() {
    }

    public StyleableObjectProperty(T t) {
        super(t);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, T t) {
        Object t2;
        if (t == null) {
            this.set(null);
        } else if (!(t instanceof Interpolatable) || (t2 = this.get()) == null || !t.getClass().isInstance(t2)) {
            this.set(t);
        } else {
            TransitionDefinition transitionDefinition;
            Object object;
            if (this.origin != null && (object = this.getBean()) instanceof Node) {
                Node node = (Node)object;
                v0 = NodeHelper.findTransitionDefinition(node, this.getCssMetaData());
            } else {
                v0 = transitionDefinition = null;
            }
            if (transitionDefinition == null) {
                this.set(t);
            } else if (this.mediator == null || !Objects.equals(this.mediator.newValue, t)) {
                this.mediator = new TransitionMediatorImpl(t2, t);
                this.mediator.run(transitionDefinition);
            }
        }
        this.origin = styleOrigin;
    }

    @Override
    public void bind(ObservableValue<? extends T> observableValue) {
        super.bind(observableValue);
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel(true);
        }
    }

    @Override
    public void set(T t) {
        super.set(t);
        if (this.mediator == null || this.mediator.cancel(false)) {
            this.origin = StyleOrigin.USER;
        }
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private final class TransitionMediatorImpl
    extends TransitionMediator {
        private final T oldValue;
        private final T newValue;

        TransitionMediatorImpl(T t, T t2) {
            this.oldValue = t;
            this.newValue = t2;
        }

        @Override
        public void onUpdate(double d) {
            StyleableObjectProperty.this.set(d < 1.0 ? ((Interpolatable)this.oldValue).interpolate(this.newValue, d) : this.newValue);
        }

        @Override
        public void onStop() {
            if (StyleableObjectProperty.this.mediator == this) {
                StyleableObjectProperty.this.mediator = null;
            }
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return StyleableObjectProperty.this;
        }
    }
}

