/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.visitors.components;

import it.polimi.ingsw.galaxytrucker.enums.AlienColor;
import it.polimi.ingsw.galaxytrucker.model.essentials.Component;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.BatterySlot;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Cannon;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.CentralHousingUnit;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.DoubleCannon;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.DoubleEngine;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Engine;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.GenericCargoHolds;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.LifeSupportSystem;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.ModularHousingUnit;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Shield;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.TuiColor;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentVisitorInterface;

public class ComponentPrintVisitor
implements ComponentVisitorInterface<String[]> {
    @Override
    public String[] visit(Component component) {
        String[] result = new String[]{"         ", "   Str   ", "         "};
        return this.AddRotationIndicator(result, component.getRotation());
    }

    @Override
    public String[] visit(BatterySlot component) {
        String[] result = new String[]{"         ", "   Bat   ", component.getBatteriesLeft() + "        "};
        return this.AddRotationIndicator(result, component.getRotation());
    }

    @Override
    public String[] visit(Cannon component) {
        String[] result = new String[]{"         ", "   Can   ", "         "};
        return this.AddRotationIndicator(result, component.getRotation());
    }

    @Override
    public String[] visit(CentralHousingUnit component) {
        String[] result = new String[]{"         ", "   CCab  ", component.getNCrewMembers() + "        "};
        StringBuilder sb = new StringBuilder(result[1]);
        switch (component.getColor()) {
            case RED: {
                sb.replace(0, 8, String.valueOf((Object)TuiColor.BRIGHT_RED) + "  CCab  " + String.valueOf((Object)TuiColor.RESET));
                break;
            }
            case BLUE: {
                sb.replace(0, 8, String.valueOf((Object)TuiColor.BRIGHT_BLUE) + "  CCab  " + String.valueOf((Object)TuiColor.RESET));
                break;
            }
            case GREEN: {
                sb.replace(0, 8, String.valueOf((Object)TuiColor.BRIGHT_GREEN) + "  CCab  " + String.valueOf((Object)TuiColor.RESET));
                break;
            }
            case YELLOW: {
                sb.replace(0, 8, String.valueOf((Object)TuiColor.BRIGHT_YELLOW) + "  CCab  " + String.valueOf((Object)TuiColor.RESET));
                break;
            }
            default: {
                sb.setCharAt(2, '-');
            }
        }
        result[1] = sb.toString();
        return this.AddRotationIndicator(result, component.getRotation());
    }

    @Override
    public String[] visit(DoubleCannon component) {
        String[] result = new String[]{"         ", "  DCan   ", "         "};
        result = this.AddActiveIndicator(result, component.isCharged());
        return this.AddRotationIndicator(result, component.getRotation());
    }

    @Override
    public String[] visit(DoubleEngine component) {
        String[] result = new String[]{"         ", "  DEng   ", "         "};
        result = this.AddActiveIndicator(result, component.isCharged());
        return this.AddEngineFire(result, component.getRotation());
    }

    @Override
    public String[] visit(Engine component) {
        String[] result = new String[]{"         ", "   Eng   ", "         "};
        return this.AddEngineFire(result, component.getRotation());
    }

    @Override
    public String[] visit(GenericCargoHolds component) {
        String[] result = new String[]{"         ", "   Sto   ", "         "};
        StringBuilder sb = new StringBuilder(result[1]);
        if (component.isSpecial().booleanValue()) {
            sb.setCharAt(2, 'S');
        } else {
            sb.setCharAt(2, 'N');
        }
        result[1] = sb.toString();
        sb = new StringBuilder();
        sb.append(component.getnMaxContainers()).append(" ");
        int j = 0;
        block6: for (j = 0; j < component.getGoods().size(); ++j) {
            switch (component.getGoods().get(j).getColor()) {
                case RED: {
                    sb.append((Object)TuiColor.RED).append("\u2588").append((Object)TuiColor.RESET);
                    continue block6;
                }
                case BLUE: {
                    sb.append((Object)TuiColor.BLUE).append("\u2588").append((Object)TuiColor.RESET);
                    continue block6;
                }
                case GREEN: {
                    sb.append((Object)TuiColor.GREEN).append("\u2588").append((Object)TuiColor.RESET);
                    continue block6;
                }
                case YELLOW: {
                    sb.append((Object)TuiColor.YELLOW).append("\u2588").append((Object)TuiColor.RESET);
                }
            }
        }
        int spazi = 7 - j;
        for (j = 0; j < spazi; ++j) {
            sb.append(" ");
        }
        result[2] = sb.toString();
        return this.AddRotationIndicator(result, component.getRotation());
    }

    @Override
    public String[] visit(LifeSupportSystem component) {
        String[] result = new String[]{"         ", "   Lss   ", "         "};
        StringBuilder sb = new StringBuilder(result[1]);
        if (component.getColor() == AlienColor.PURPLE) {
            sb.setCharAt(2, 'P');
        } else {
            sb.setCharAt(2, 'B');
        }
        result[1] = sb.toString();
        return this.AddRotationIndicator(result, component.getRotation());
    }

    @Override
    public String[] visit(ModularHousingUnit component) {
        String[] result = new String[]{"         ", "   Cab   ", component.getNCrewMembers() + "        "};
        StringBuilder sb = new StringBuilder(result[2]);
        if (component.getNBrownAlien() == 1) {
            sb.setCharAt(8, 'B');
        } else if (component.getNPurpleAlien() == 1) {
            sb.setCharAt(8, 'P');
        } else {
            sb.setCharAt(8, '-');
        }
        result[2] = sb.toString();
        return this.AddRotationIndicator(result, component.getRotation());
    }

    @Override
    public String[] visit(Shield component) {
        String[] result = new String[]{"         ", "   Shl   ", "         "};
        result = this.AddActiveIndicator(result, component.isCharged());
        switch (component.getRotation()) {
            case 90: {
                StringBuilder sb = new StringBuilder(result[1]);
                sb.replace(7, 8, String.valueOf((Object)TuiColor.GREEN) + "\u2588" + String.valueOf((Object)TuiColor.RESET));
                result[1] = sb.toString();
                sb = new StringBuilder(result[2]);
                sb.replace(4, 5, String.valueOf((Object)TuiColor.GREEN) + "\u2588" + String.valueOf((Object)TuiColor.RESET));
                result[2] = sb.toString();
                break;
            }
            case 180: {
                StringBuilder sb = new StringBuilder(result[2]);
                sb.replace(4, 5, String.valueOf((Object)TuiColor.GREEN) + "\u2588" + String.valueOf((Object)TuiColor.RESET));
                result[2] = sb.toString();
                sb = new StringBuilder(result[1]);
                sb.replace(0, 1, String.valueOf((Object)TuiColor.GREEN) + "\u2588" + String.valueOf((Object)TuiColor.RESET));
                result[1] = sb.toString();
                break;
            }
            case 270: {
                StringBuilder sb = new StringBuilder(result[1]);
                sb.replace(0, 1, String.valueOf((Object)TuiColor.GREEN) + "\u2588" + String.valueOf((Object)TuiColor.RESET));
                result[1] = sb.toString();
                sb = new StringBuilder(result[0]);
                sb.replace(4, 5, String.valueOf((Object)TuiColor.GREEN) + "\u2588" + String.valueOf((Object)TuiColor.RESET));
                result[0] = sb.toString();
                break;
            }
            default: {
                StringBuilder sb = new StringBuilder(result[0]);
                sb.replace(4, 5, String.valueOf((Object)TuiColor.GREEN) + "\u2588" + String.valueOf((Object)TuiColor.RESET));
                result[0] = sb.toString();
                sb = new StringBuilder(result[1]);
                sb.replace(7, 8, String.valueOf((Object)TuiColor.GREEN) + "\u2588" + String.valueOf((Object)TuiColor.RESET));
                result[1] = sb.toString();
            }
        }
        return result;
    }

    public String[] AddActiveIndicator(String[] res, boolean active) {
        StringBuilder sb = new StringBuilder(res[2]);
        if (active) {
            sb.setCharAt(0, 'O');
            sb.setCharAt(1, 'N');
        } else {
            sb.setCharAt(0, 'O');
            sb.setCharAt(1, 'F');
            sb.setCharAt(2, 'F');
        }
        res[2] = sb.toString();
        return res;
    }

    public String[] AddEngineFire(String[] res, int rot) {
        switch (rot) {
            case 90: {
                StringBuilder sb = new StringBuilder(res[1]);
                sb.replace(0, 1, String.valueOf((Object)TuiColor.ORANGE) + "\u25c0" + String.valueOf((Object)TuiColor.RESET));
                res[1] = sb.toString();
                break;
            }
            case 180: {
                StringBuilder sb = new StringBuilder(res[2]);
                sb.replace(4, 5, String.valueOf((Object)TuiColor.ORANGE) + "\u25bc" + String.valueOf((Object)TuiColor.RESET));
                res[0] = sb.toString();
                break;
            }
            case 270: {
                StringBuilder sb = new StringBuilder(res[1]);
                sb.replace(7, 8, String.valueOf((Object)TuiColor.ORANGE) + "\u25b6" + String.valueOf((Object)TuiColor.RESET));
                res[1] = sb.toString();
                break;
            }
            default: {
                StringBuilder sb = new StringBuilder(res[2]);
                sb.replace(4, 5, String.valueOf((Object)TuiColor.ORANGE) + "\u25b2" + String.valueOf((Object)TuiColor.RESET));
                res[2] = sb.toString();
            }
        }
        return res;
    }

    public String[] AddRotationIndicator(String[] res, int rot) {
        switch (rot) {
            case 90: {
                StringBuilder sb = new StringBuilder(res[1]);
                sb.setCharAt(8, '*');
                res[1] = sb.toString();
                break;
            }
            case 180: {
                StringBuilder sb = new StringBuilder(res[2]);
                sb.setCharAt(4, '*');
                res[2] = sb.toString();
                break;
            }
            case 270: {
                StringBuilder sb = new StringBuilder(res[1]);
                sb.setCharAt(0, '*');
                res[1] = sb.toString();
                break;
            }
            default: {
                StringBuilder sb = new StringBuilder(res[0]);
                sb.setCharAt(4, '*');
                res[0] = sb.toString();
            }
        }
        return res;
    }
}

