/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Tui.util;

import it.polimi.ingsw.galaxytrucker.enums.Color;
import it.polimi.ingsw.galaxytrucker.model.FlightBoard;
import it.polimi.ingsw.galaxytrucker.model.PlayerInfo;
import it.polimi.ingsw.galaxytrucker.model.essentials.FlightBoardMapSlot;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.TuiColor;
import java.util.ArrayList;

public class FlightBoardPrintUtils {
    public static String[] getCell(ArrayList<FlightBoardMapSlot> slots, int i) {
        String[] result;
        if (i == -1) {
            result = new String[]{"       ", "       ", "       "};
        } else {
            result = new String[]{"\u2554\u2550\u2550\u2550\u2550\u2550\u2557", "\u2551     \u2551", "\u255a\u2550\u2550\u2550\u2550\u2550\u255d"};
            if (slots.get(i).getPlayerToken() != Color.EMPTY) {
                StringBuilder builder = new StringBuilder();
                switch (slots.get(i).getPlayerToken()) {
                    case RED: {
                        builder.append("\u2551  " + String.valueOf((Object)TuiColor.RED) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + "  \u2551");
                        break;
                    }
                    case BLUE: {
                        builder.append("\u2551  " + String.valueOf((Object)TuiColor.BLUE) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + "  \u2551");
                        break;
                    }
                    case GREEN: {
                        builder.append("\u2551  " + String.valueOf((Object)TuiColor.GREEN) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + "  \u2551");
                        break;
                    }
                    case YELLOW: {
                        builder.append("\u2551  " + String.valueOf((Object)TuiColor.BRIGHT_YELLOW) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + "  \u2551");
                    }
                }
                result[1] = builder.toString();
            }
            result[0] = ++i == 1 ? "\u2554\u2550VIA\u2550\u2557" : (i > 9 ? "\u2554\u2550" + i + "\u2550\u2550\u2557" : "\u2554\u2550\u2550" + i + "\u2550\u2550\u2557");
        }
        return result;
    }

    public static String[][] composeRow(ArrayList<FlightBoardMapSlot> slots, int rows, int columns, int r) {
        String[][] tileRow = new String[columns][3];
        int Offset2 = 0;
        for (int i = 0; i < columns; ++i) {
            if (r == 0) {
                tileRow[i] = FlightBoardPrintUtils.getCell(slots, i);
                continue;
            }
            if (r == rows - 1) {
                Offset2 = columns - 1 + rows - 2;
                tileRow[i] = FlightBoardPrintUtils.getCell(slots, Offset2 + columns - i);
                continue;
            }
            Offset2 = columns - 1 + 2 * (rows - 2) - 2 * (r - 1);
            if (i == 0) {
                tileRow[0] = FlightBoardPrintUtils.getCell(slots, columns + r - 1 + Offset2);
                continue;
            }
            tileRow[i] = i == columns - 1 ? FlightBoardPrintUtils.getCell(slots, columns + r - 1) : FlightBoardPrintUtils.getCell(slots, -1);
        }
        return tileRow;
    }

    public static void printFlightBoard(FlightBoard flightBoard, ArrayList<PlayerInfo> infoPlayer, PlayerInfo myinfo) {
        int size = flightBoard.getFlightBoardMap().getFlightBoardMapSlots().size();
        int width = 0;
        int height = 0;
        int i = 0;
        if (size == 18) {
            width = 8;
            height = 3;
        } else {
            width = 10;
            height = 4;
        }
        block6: for (int p = 0; p < infoPlayer.size(); ++p) {
            switch (infoPlayer.get(p).getColor()) {
                case RED: {
                    System.out.println(String.valueOf((Object)TuiColor.RED) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + " " + infoPlayer.get(p).getNickName());
                    continue block6;
                }
                case GREEN: {
                    System.out.println(String.valueOf((Object)TuiColor.GREEN) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + " " + infoPlayer.get(p).getNickName());
                    continue block6;
                }
                case BLUE: {
                    System.out.println(String.valueOf((Object)TuiColor.BLUE) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + " " + infoPlayer.get(p).getNickName());
                    continue block6;
                }
                case YELLOW: {
                    System.out.println(String.valueOf((Object)TuiColor.BRIGHT_YELLOW) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + " " + infoPlayer.get(p).getNickName());
                }
            }
        }
        System.out.println();
        for (int r = 0; r < height; ++r) {
            String[][] StringRow = FlightBoardPrintUtils.composeRow(flightBoard.getFlightBoardMap().getFlightBoardMapSlots(), height, width, r);
            for (i = 0; i < 3; ++i) {
                for (int c = 0; c < width; ++c) {
                    System.out.print(StringRow[c][i]);
                }
                System.out.println();
            }
        }
    }
}

