/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Tui;

import it.polimi.ingsw.galaxytrucker.controller.ClientController;
import it.polimi.ingsw.galaxytrucker.enums.ActivatableComponent;
import it.polimi.ingsw.galaxytrucker.enums.AlienColor;
import it.polimi.ingsw.galaxytrucker.enums.GameState;
import it.polimi.ingsw.galaxytrucker.enums.PLAYER_PHASE;
import it.polimi.ingsw.galaxytrucker.enums.ViewType;
import it.polimi.ingsw.galaxytrucker.model.FlightBoard;
import it.polimi.ingsw.galaxytrucker.model.Planet;
import it.polimi.ingsw.galaxytrucker.model.PlayerInfo;
import it.polimi.ingsw.galaxytrucker.model.PlayerScore;
import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.model.essentials.Good;
import it.polimi.ingsw.galaxytrucker.model.essentials.Position;
import it.polimi.ingsw.galaxytrucker.model.essentials.Slot;
import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.BatterySlot;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.CentralHousingUnit;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.ModularHousingUnit;
import it.polimi.ingsw.galaxytrucker.model.game.TimerInfo;
import it.polimi.ingsw.galaxytrucker.model.utils.Util;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyInfo;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessage;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.SERVER_INFO;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.AskPositionResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.CrewInitUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.PhaseUpdate;
import it.polimi.ingsw.galaxytrucker.observer.Observable;
import it.polimi.ingsw.galaxytrucker.observer.Observer;
import it.polimi.ingsw.galaxytrucker.view.Tui.MenuManager;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.CabinUnitAscii;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.CardPrintUtils;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.FlightBoardPrintUtils;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.InputUtils;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.ScorePrintUtils;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.ShipPrintUtils;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.TilePrintUtils;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.TimerPrinter;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.TuiColor;
import it.polimi.ingsw.galaxytrucker.view.View;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentNameVisitor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.util.Pair;

public class Tui
implements View,
Observable {
    private static PrintStream out;
    private final Boolean isSocket;
    private final ClientController clientController;
    private static final Object outputLock;
    private final ArrayList<Observer> observers = new ArrayList();
    private MenuManager menuManager = new MenuManager();
    private volatile CompletableFuture<String> currentInputFuture = null;
    private volatile boolean flag = false;
    private volatile boolean inputEnabled = false;

    public Tui(PrintStream out, Boolean isSocket, ClientController controller) {
        Tui.out = out;
        this.isSocket = isSocket;
        this.clientController = controller;
        this.addObserver(this.clientController);
        this.startInputListener();
    }

    @Override
    public Boolean autoShowUpdates() {
        return false;
    }

    @Override
    public ViewType getViewType() {
        return ViewType.TUI;
    }

    public void enableInput() {
        this.inputEnabled = true;
    }

    public void disableInput() {
        this.inputEnabled = false;
    }

    public void startInputListener() {
        new Thread(() -> {
            Scanner scanner = new Scanner(System.in);
            while (true) {
                if (!scanner.hasNextLine()) {
                    continue;
                }
                String line = scanner.nextLine();
                if ("RESET".equalsIgnoreCase(line)) {
                    this.flag = true;
                    continue;
                }
                CompletableFuture<String> future = this.currentInputFuture;
                if (!this.inputEnabled) {
                    System.out.println("Non \u00e8 il tuo turno.");
                    continue;
                }
                if (future == null) {
                    System.out.println("Input future non inizializzato.");
                    continue;
                }
                if (future.isDone()) {
                    System.out.println("Input gi\u00e0 completato.");
                    continue;
                }
                future.complete(line);
            }
        }, "ConsoleInputListener").start();
    }

    public String readLine(String prompt) {
        this.inputEnabled = true;
        this.currentInputFuture = new CompletableFuture();
        System.out.print(prompt + " ");
        try {
            String input = this.currentInputFuture.get().trim();
            this.inputEnabled = false;
            return input;
        }
        catch (InterruptedException | ExecutionException e) {
            return "";
        }
    }

    @Override
    public void forceReset() {
        System.out.println();
        if (this.currentInputFuture != null && !this.currentInputFuture.isDone()) {
            this.currentInputFuture.complete("RESET");
        }
    }

    public void start() {
        MenuManager.clearConsole();
        System.out.println("\r".repeat(100));
        String banner = "\u001b[1;34m   __    _   __    _   _  __ _  __  _____ ___  _ __  __  _    ___  ___    ___\n ,'_/  .' \\ / /  .' \\ | |/,'| |/,' /_  _// o |/// /,'_/ / //7/ _/ / o | ,' _/\n/ /_n / o // /_ / o / /  /  | ,'    / / /  ,'/ U // /_ /  ,'/ _/ /  ,' _\\ `. \n|__,'/_n_//___//_n_/,'_n_\\ /_/     /_/ /_/`_\\\\_,' |__//_/\\/___//_/`_\\/___,' \n\u001b[0m";
        out.println(banner);
        this.askServerInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void askServerInfo() {
        HashMap<String, String> serverInfo = new HashMap<String, String>();
        String defaultAddress = "localhost";
        int defaultPort = this.isSocket != false ? 5000 : 1099;
        int portNumber = -1;
        Object object = outputLock;
        synchronized (object) {
            out.println("Please specify the following settings. The default value is shown between brackets.");
            this.enableInput();
            String address = this.readLine("Enter the server address [" + defaultAddress + "]: ").trim();
            serverInfo.put("address", address.isBlank() ? defaultAddress : address);
            do {
                String port;
                if ((port = this.readLine("Enter the server port [" + defaultPort + "]: ").trim()).equals("RESET")) {
                    this.disableInput();
                    return;
                }
                try {
                    portNumber = port.isEmpty() ? defaultPort : Integer.parseInt(port);
                }
                catch (NumberFormatException e) {
                    out.println("Errore: la porta deve essere un numero intero.");
                }
            } while (portNumber == -1);
        }
        SERVER_INFO message = new SERVER_INFO((String)serverInfo.get("address"), portNumber);
        this.notifyObservers(message);
    }

    @Override
    public void askNickname() {
        String nickname = this.readLine("Enter your nickname: ");
        if (this.checkReset(nickname).booleanValue()) {
            return;
        }
        this.clientController.handleNicknameInput(nickname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void askJoinOrCreateRoom() {
        this.enableInput();
        try {
            String choice;
            do {
                if (this.checkReset(choice = this.readLine("Create Room (a) or Join Room (b): ").trim().toLowerCase()).booleanValue()) {
                    return;
                }
                if (choice.equals("a") || choice.equals("b")) continue;
                Object object = outputLock;
                synchronized (object) {
                    out.println("Invalid input. Please enter 'a' or 'b'.");
                }
            } while (!choice.equals("a") && !choice.equals("b"));
            this.clientController.handleCreateOrJoinChoice(choice);
        }
        catch (Exception e) {
            System.err.println("Error while choosing: " + e.getMessage());
        }
        finally {
            this.disableInput();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void askCreateRoom() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void askRoomCode() {
        Object object = outputLock;
        synchronized (object) {
            out.println("\nPlease enter the Lobby ID you want to join:");
            this.enableInput();
            try {
                String input = this.readLine("> ").trim().toLowerCase();
                if (input.equals("reset")) {
                    return;
                }
                int lobbyId = Integer.parseInt(input);
                this.clientController.handleJoinChoice(lobbyId);
            }
            catch (NumberFormatException e) {
                out.println("Invalid Lobby ID. Please enter a number.");
                this.askRoomCode();
            }
            finally {
                this.disableInput();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showLobbies(List<LobbyInfo> lobbies) {
        if (lobbies.isEmpty()) {
            Object object = outputLock;
            synchronized (object) {
                out.println(" No game rooms, Returning to main menu. ");
            }
            this.askJoinOrCreateRoom();
            return;
        }
        Object object = outputLock;
        synchronized (object) {
            out.println("\uff1aList of rooms");
            for (LobbyInfo lobby : lobbies) {
                boolean isLearningMatch = lobby.isLearningMatch();
                String matchType = isLearningMatch ? "Learning" : "Normal";
                out.printf("Lobby ID: %d | Host: %s | GameType: " + matchType + " |Players: (%d/%d)  \n", lobby.getLobbyID(), lobby.getHost(), lobby.getConnectedPlayers(), lobby.getMaxPlayers());
            }
        }
    }

    @Override
    public void showPlayerJoined(PlayerInfo infoPlayer) {
        out.println("Giocatore entrato nella lobby:");
        switch (infoPlayer.getColor()) {
            case RED: {
                System.out.println(String.valueOf((Object)TuiColor.RED) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + " " + infoPlayer.getNickName());
                break;
            }
            case GREEN: {
                System.out.println(String.valueOf((Object)TuiColor.GREEN) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + " " + infoPlayer.getNickName());
                break;
            }
            case BLUE: {
                System.out.println(String.valueOf((Object)TuiColor.BLUE) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + " " + infoPlayer.getNickName());
                break;
            }
            case YELLOW: {
                System.out.println(String.valueOf((Object)TuiColor.BRIGHT_YELLOW) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + " " + infoPlayer.getNickName());
            }
        }
        System.out.println();
        out.println();
    }

    @Override
    public void showPlayersLobby(PlayerInfo myInfo, ArrayList<PlayerInfo> infoPlayer) {
        System.out.println("Giocatori nella lobby: ");
        System.out.print("IO: ");
        switch (myInfo.getColor()) {
            case RED: {
                System.out.println(String.valueOf((Object)TuiColor.RED) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + " ");
                break;
            }
            case GREEN: {
                System.out.println(String.valueOf((Object)TuiColor.GREEN) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + " ");
                break;
            }
            case BLUE: {
                System.out.println(String.valueOf((Object)TuiColor.BLUE) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + " ");
                break;
            }
            case YELLOW: {
                System.out.println(String.valueOf((Object)TuiColor.BRIGHT_YELLOW) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + " ");
            }
        }
        block12: for (int p = 0; p < infoPlayer.size(); ++p) {
            switch (infoPlayer.get(p).getColor()) {
                case RED: {
                    System.out.println(String.valueOf((Object)TuiColor.RED) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + " " + infoPlayer.get(p).getNickName());
                    continue block12;
                }
                case GREEN: {
                    System.out.println(String.valueOf((Object)TuiColor.GREEN) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + " " + infoPlayer.get(p).getNickName());
                    continue block12;
                }
                case BLUE: {
                    System.out.println(String.valueOf((Object)TuiColor.BLUE) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + " " + infoPlayer.get(p).getNickName());
                    continue block12;
                }
                case YELLOW: {
                    System.out.println(String.valueOf((Object)TuiColor.BRIGHT_YELLOW) + "\u2588" + String.valueOf((Object)TuiColor.RESET) + " " + infoPlayer.get(p).getNickName());
                }
            }
        }
        System.out.println();
    }

    @Override
    public void handlePhaseUpdate(PhaseUpdate phaseUpdate) {
        GameState phase = phaseUpdate.getState();
        this.menuManager.showPhaseStart(phase);
        if (phase.equals((Object)GameState.BUILDING_TIMER)) {
            new Thread(() -> this.showGenericMessage("TIMER STARTED !!", false)).start();
            return;
        }
        this.menuManager.setMenuText(phase);
        if (phase.equals((Object)GameState.BUILDING_START) || phase.equals((Object)GameState.BUILDING_END) || phase.equals((Object)GameState.SHIP_CHECK) || phase.equals((Object)GameState.CREW_INIT) || phase.equals((Object)GameState.FLIGHT)) {
            this.toShowCurrentMenu();
            this.handleChoiceForPhase(phase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toShowCurrentMenu() {
        Object object = outputLock;
        synchronized (object) {
            this.menuManager.showCurrentMenu();
        }
    }

    @Override
    public void handleChoiceForPhase(GameState phase) {
        switch (phase) {
            case BUILDING_START: {
                this.showBuildingMenu();
                break;
            }
            case BUILDING_END: {
                this.showFinishedBuildingMenu();
                break;
            }
            case SHIP_CHECK: {
                this.showCheckShipMenu();
                break;
            }
            case CREW_INIT: {
                this.showEmbarkCrewMenu();
                break;
            }
            case FLIGHT: {
                this.showFlightMenu();
                break;
            }
        }
    }

    @Override
    public void showBuildingMenu() {
        this.enableInput();
        String choiceEnd = MenuManager.learningMatch != false ? "i" : "j";
        String string = "\nChoose an option (a\u2013" + choiceEnd + ") or reprint this menu (m): ";
        String input = this.readLine(string).trim().toLowerCase();
        if (this.checkReset(input).booleanValue()) {
            return;
        }
        while (input.equals("m") || input.equals("menu") || input.equals("?")) {
            this.menuManager.showCurrentMenu();
            input = this.readLine(string).trim().toLowerCase();
        }
        this.clientController.handleBuildingMenuChoice(input);
    }

    @Override
    public void showFinishedBuildingMenu() {
        this.enableInput();
        String choiceEnd = MenuManager.learningMatch != false ? "c" : "j";
        String string = "\nChoose an option (a\u2013" + choiceEnd + ") or reprint this menu (m): ";
        String input = this.readLine(string).trim().toLowerCase();
        if (this.checkReset(input).booleanValue()) {
            return;
        }
        while (input.equals("m") || input.equals("menu") || input.equals("?")) {
            this.menuManager.showCurrentMenu();
            input = this.readLine(string).trim().toLowerCase();
        }
        this.clientController.handleFinishedBuildingMenuChoice(input);
    }

    @Override
    public void askShowFaceUpTiles() {
        this.showFaceUpTiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void askViewAdventureDecks() {
        boolean valid = false;
        do {
            this.enableInput();
            try {
                String DeckIDStr = this.readLine("Enter which Deck you want to view (1~4)> ").trim();
                int DeckID = Integer.parseInt(DeckIDStr);
                if (this.checkReset(DeckIDStr).booleanValue()) {
                    return;
                }
                if (DeckID < 1 || DeckID > 4) {
                    out.println("Deck ID not valid. Please enter a number between 1 and 4.");
                    continue;
                }
                this.clientController.viewAdventureCardDeck(DeckID - 1);
                valid = true;
            }
            catch (Exception e) {
                out.println("Error during ask view adventure Decks: " + e.getMessage());
            }
            finally {
                this.disableInput();
            }
        } while (!valid);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void askFetchShip() {
        this.enableInput();
        boolean success = false;
        do {
            String targetName;
            try {
                targetName = this.readLine("Enter the nickname of the player to fetch their ship: ").trim();
                if (this.checkReset(targetName).booleanValue()) {
                    this.disableInput();
                    return;
                }
            }
            catch (Exception e) {
                this.showGenericMessage("Unexpected error: " + e.getMessage(), false);
                continue;
            }
            catch (Throwable throwable) {
                this.disableInput();
                throw throwable;
            }
            {
                this.clientController.handleFetchShip(targetName);
                success = true;
            }
        } while (!success);
        this.disableInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void askRotation() {
        valid = false;
        this.enableInput();
        do {
            try {
                Tui.out.println("Enter rotation degree (0,90, 180, 270): ");
                input = this.readLine("> ").trim();
                if (this.checkReset(input).booleanValue()) {
                }
                ** GOTO lbl-1000
            }
            catch (IllegalArgumentException e) {
                Tui.out.println("Invalid input: " + e.getMessage());
                continue;
            }
            catch (Exception e) {
                Tui.out.println("Unexpected error: " + e.getMessage());
                continue;
            }
            catch (Throwable var4_6) {
                this.disableInput();
                throw var4_6;
            }
            this.disableInput();
            return;
lbl-1000:
            // 1 sources

            {
                rotation = InputUtils.parseRotation(input);
                this.clientController.rotateCurrentTile(rotation);
                valid = true;
            }
        } while (!valid);
        this.disableInput();
    }

    @Override
    public void askPosition() {
        boolean valid = false;
        Position pos = null;
        do {
            try {
                String input = this.readLine("Enter position to move the tile to (format: (x,y)): ").trim();
                if (this.checkReset(input).booleanValue()) {
                    return;
                }
                pos = InputUtils.parseCoordinate(input);
                this.clientController.setTmpCurrentPosition(this.clientController.getCurrentPosition());
                this.clientController.setCurrentPos(pos.getX() - 4, pos.getY() - 5);
                valid = true;
            }
            catch (IllegalArgumentException e) {
                out.println(e.getMessage());
            }
            catch (Exception e) {
                out.println("Unexpected error: " + e.getMessage());
            }
        } while (!valid);
    }

    @Override
    public void showTile(Tile tile) {
        if (tile != null) {
            TilePrintUtils.printTile(tile);
        }
    }

    @Override
    public void handleFaceUpTilesUpdate() {
    }

    @Override
    public void showFaceUpTiles() {
        ArrayList<Tile> faceUpTiles = this.clientController.getMyModel().getFaceUpTiles();
        int size = faceUpTiles.size();
        if (size == 0) {
            out.println("Face up Tiles is empty");
            this.showBuildingMenu();
            return;
        }
        out.println("Face up tiles size: " + faceUpTiles.size());
        TilePrintUtils.printTileList(new ArrayList<Tile>(faceUpTiles), 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void askDrawTile() {
        this.enableInput();
        try {
            boolean validInput = false;
            do {
                out.println("How do you want to draw a tile?");
                out.println("1) draw a random tile(face down)");
                out.println("2) choose a face up tile");
                out.println("3) choose from your reserved tiles");
                out.println("4) Reclaim the tile that is still movable.");
                out.println();
                String choice = this.readLine("Choose(1/2/3/4) > ");
                if (this.checkReset(choice).booleanValue()) {
                    return;
                }
                switch (choice) {
                    case "1": {
                        this.clientController.handleDrawFaceDownTile();
                        validInput = true;
                        break;
                    }
                    case "2": {
                        this.clientController.sendShipUpdate();
                        this.clientController.startChooseTile();
                        validInput = true;
                        break;
                    }
                    case "3": {
                        this.clientController.sendShipUpdate();
                        this.askPickOrPlaceReservedTile(true);
                        validInput = true;
                        break;
                    }
                    case "4": {
                        this.clientController.reclaimTile();
                        validInput = true;
                        break;
                    }
                    default: {
                        out.println("Invalid input. Please enter 1, 2, 3, or 4.");
                    }
                }
            } while (!validInput);
        }
        finally {
            this.disableInput();
        }
    }

    @Override
    public void askChooseTile() {
        this.enableInput();
        try {
            boolean validInput = false;
            do {
                ArrayList<Tile> faceUpTiles;
                if ((faceUpTiles = this.clientController.getMyModel().getFaceUpTiles()).isEmpty()) {
                    out.println("No tiles available to choose.");
                    this.showBuildingMenu();
                    break;
                }
                String input = this.readLine("Enter the Tile ID to draw, or use R to refresh: ").trim().toLowerCase();
                if (this.checkReset(input).booleanValue()) {
                    return;
                }
                if (input.equalsIgnoreCase("R")) {
                    out.println("Refreshing tile list");
                    Thread.sleep(200L);
                    this.showFaceUpTiles();
                    continue;
                }
                try {
                    int tileID = Integer.parseInt(input);
                    Tile selectedTile = this.clientController.getMyModel().getFaceUpTiles().stream().filter(t -> t.getId() == tileID).findFirst().orElse(null);
                    if (selectedTile != null) {
                        this.clientController.handleChooseFaceUpTile(selectedTile);
                        validInput = true;
                        continue;
                    }
                    out.println("Tile ID not found. Please try again.");
                }
                catch (NumberFormatException e) {
                    out.println("Invalid tile ID. Please enter a number.");
                }
            } while (!validInput);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.disableInput();
        }
    }

    private void showTileSlots() {
        Tile[] reservedTiles = this.clientController.getReservedTiles();
        out.println("Reserved Slot 1:");
        if (reservedTiles[0] != null) {
            this.showTile(reservedTiles[0]);
        } else {
            out.println("Empty");
        }
        out.println("Reserved Slot 2:");
        if (reservedTiles[1] != null) {
            this.showTile(reservedTiles[1]);
        } else {
            out.println("Empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void askPickOrPlaceReservedTile(boolean isPicking) {
        String input;
        int slotIndex;
        boolean validInput;
        Tile[] reservedTiles = this.clientController.getReservedTiles();
        if (isPicking) {
            if (!this.clientController.hasTileInHand()) {
                if (reservedTiles[0] != null || reservedTiles[1] != null) {
                    this.showTileSlots();
                    this.enableInput();
                    try {
                        validInput = false;
                        slotIndex = -1;
                        do {
                            if (this.checkReset(input = this.readLine("Enter the Slot Index to pick (1 or 2)> ")).booleanValue()) {
                                return;
                            }
                            if (input.equals("1") || input.equals("2")) {
                                slotIndex = Integer.parseInt(input);
                                validInput = true;
                                continue;
                            }
                            out.println("Invalid input. Please enter 1 or 2.");
                        } while (!validInput);
                        this.clientController.handlePickReservedTile(slotIndex - 1, true);
                    }
                    finally {
                        this.disableInput();
                    }
                } else {
                    this.showGenericMessage("There is no tile to pick", false);
                    this.showBuildingMenu();
                }
            } else {
                this.showGenericMessage("You already have a tile in hand to place ", false);
                this.showBuildingMenu();
            }
        }
        if (!isPicking) {
            if (this.clientController.hasTileInHand()) {
                if (reservedTiles[0] == null || reservedTiles[1] == null) {
                    this.showTileSlots();
                    this.enableInput();
                    try {
                        validInput = false;
                        slotIndex = -1;
                        do {
                            if (this.checkReset(input = this.readLine("Enter the Slot Index to place (1 or 2)> ")).booleanValue()) {
                                return;
                            }
                            if (input.equals("1") || input.equals("2")) {
                                slotIndex = Integer.parseInt(input);
                                validInput = true;
                                continue;
                            }
                            out.println("Invalid input. Please enter 1 or 2.");
                        } while (!validInput);
                        this.clientController.handlePickReservedTile(slotIndex - 1, false);
                    }
                    finally {
                        this.disableInput();
                    }
                } else {
                    this.showGenericMessage("There is no place to place the tile", false);
                    this.showBuildingMenu();
                }
            } else {
                this.showGenericMessage("You have no tile in hand to place", false);
                this.showBuildingMenu();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void askTilePlacement() {
        this.enableInput();
        try {
            if (!this.clientController.hasTileInHand()) {
                out.println("No tile in hand to place.");
                this.showBuildingMenu();
                return;
            }
            out.println("Current tile info:");
            TilePrintUtils.printTile(this.clientController.getCurrentTileInHand());
            while (true) {
                out.println("Where do you want to place this tile?");
                out.println("1) Place on ship");
                out.println("2) Place in reserved slot");
                String input = this.readLine("Choose (1/2): ").trim().toLowerCase();
                if (this.checkReset(input).booleanValue()) {
                    return;
                }
                switch (input) {
                    case "1": {
                        this.choosePlaceTileInShip();
                        return;
                    }
                    case "2": {
                        this.askPickOrPlaceReservedTile(false);
                        return;
                    }
                }
                out.println("Invalid input. Please choose 1 or 2.");
                continue;
                break;
            }
        }
        catch (Exception e) {
            out.println("Error during tile placement: " + e.getMessage());
            return;
        }
        finally {
            this.disableInput();
        }
    }

    private void choosePlaceTileInShip() {
        this.enableInput();
        try {
            out.println(" Current tile info:");
            TilePrintUtils.printTile(this.clientController.getCurrentTileInHand());
            if (this.clientController.getCurrentPosition() != null) {
                out.println("Current position:  X: " + (this.clientController.getCurrentPosition().getX() + 4) + ",  Y:" + (this.clientController.getCurrentPosition().getY() + 5));
            } else {
                out.println("Current position: null");
            }
            out.println("Current rotation: " + this.clientController.getCurrentTileInHand().getRotation());
            this.askPosition();
            out.println("Do you want to place this tile at the current position and rotation? (y/n)");
            this.enableInput();
            String input = this.readLine("> ").trim().toLowerCase();
            if (this.checkReset(input).booleanValue()) {
                return;
            }
            boolean confirm = input.equals("y");
            if (confirm) {
                this.clientController.handleTilePlacement();
            } else {
                this.clientController.resetCurrentPos();
                out.println("Tile not placed. You can rotate or move it again.");
                this.showBuildingMenu();
            }
        }
        catch (Exception e) {
            out.println("Error during tile placement " + e.getMessage());
        }
        finally {
            this.disableInput();
        }
    }

    @Override
    public void showCheckShipMenu() {
        this.enableInput();
        try {
            String input = this.readLine("\nChoose an option (a\u2013c) or menu: ").trim().toLowerCase();
            if (this.checkReset(input).booleanValue()) {
                return;
            }
            this.clientController.handleCheckShipChoice(input);
        }
        finally {
            this.disableInput();
        }
    }

    @Override
    public void showEmbarkCrewMenu() {
        this.enableInput();
        try {
            String input = this.readLine("\nChoose an option (a\u2013b) or menu: ").trim().toLowerCase();
            if (this.checkReset(input).booleanValue()) {
                return;
            }
            this.clientController.handleEmbarkCrewMenu(Character.toString(input.charAt(input.length() - 1)));
        }
        finally {
            this.disableInput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void askRemoveTile(Ship ship) {
        valid = false;
        pos1 = null;
        this.enableInput();
        do {
            try {
                input = this.readLine("Enter position to remove the Tile from(format: (x,y)): ").trim();
                if (this.checkReset(input).booleanValue()) {
                }
                ** GOTO lbl-1000
            }
            catch (IllegalArgumentException e) {
                Tui.out.println(e.getMessage());
                continue;
            }
            catch (Exception e) {
                Tui.out.println("Unexpected error: " + e.getMessage());
                continue;
            }
            catch (Throwable var8_10) {
                this.disableInput();
                throw var8_10;
            }
            this.disableInput();
            return;
lbl-1000:
            // 1 sources

            {
                pos1 = InputUtils.parseCoordinate(input);
                pos = new Position(pos1.getX() - 4, pos1.getY() - 5);
                if (!Util.inBoundaries(pos.getX(), pos.getY()).booleanValue() || ship.getInvalidPositions().contains(pos) || ship.getShipBoard()[pos.getX()][pos.getY()].getTile() == null) {
                    throw new IllegalArgumentException("Invalid Position " + String.valueOf(pos));
                }
                tile = ship.getShipBoard()[pos.getX()][pos.getY()].getTile();
                this.clientController.getMyModel().addTileToRemove(tile.getId());
                ship.removeTile(pos, true);
                if (ship.remainingTiles() != 0) ** GOTO lbl-1000
                System.out.println("Your ship is a ghost, go back to the menuuuuuu");
                this.showCheckShipMenu();
            }
            this.disableInput();
            return;
lbl-1000:
            // 1 sources

            {
                input2 = this.readLine("Do you want to finish? (y/n)").trim().toLowerCase();
                if (!this.checkReset(input2).booleanValue()) ** GOTO lbl-1000
            }
            this.disableInput();
            return;
lbl-1000:
            // 2 sources

            {
                while (!input2.equals("n") && !input2.equals("y")) {
                    System.out.println("Invalid input. Please enter (y/n))");
                    input2 = this.readLine("Do you want to finish? (y/n)").trim().toLowerCase();
                }
                if (!input2.equals("y")) continue;
                this.menuManager.showCurrentMenu();
                this.showCheckShipMenu();
                valid = true;
            }
        } while (!valid);
        this.disableInput();
        this.showCheckShipMenu();
    }

    @Override
    public void showShip(Ship targetShipView, String nickname) {
        ShipPrintUtils.printShip(targetShipView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void askFlightBoardPosition(ArrayList<Integer> validPositions, int id) {
        int chosenPos = -1;
        MenuManager.clearConsole();
        System.out.println("Free FlightBoard starting positions: ");
        for (Integer i : validPositions) {
            System.out.println(" --> " + i);
        }
        boolean valid = false;
        this.enableInput();
        try {
            do {
                String inputStr;
                if (this.checkReset(inputStr = this.readLine("Choose one > ").trim()).booleanValue()) {
                    return;
                }
                if (inputStr.isEmpty()) {
                    System.out.println("Input vuoto, riprova.");
                    continue;
                }
                try {
                    chosenPos = Integer.parseInt(inputStr);
                    if (validPositions.contains(chosenPos)) {
                        valid = true;
                        continue;
                    }
                    System.out.println("Posizione non valida. Riprova.");
                }
                catch (NumberFormatException e) {
                    System.out.println("Inserisci un numero valido.");
                }
            } while (!valid);
            AskPositionResponse askPositionResponse = new AskPositionResponse(id, chosenPos);
            this.clientController.safeSendMessage(askPositionResponse);
        }
        finally {
            this.disableInput();
        }
        this.handlePhaseUpdate(new PhaseUpdate(GameState.BUILDING_END));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showGenericMessage(String message, Boolean important) {
        Object object = outputLock;
        synchronized (object) {
            out.println();
            if (important.booleanValue()) {
                System.out.println(String.valueOf((Object)TuiColor.RED) + message + String.valueOf((Object)TuiColor.RESET));
            } else {
                System.out.println(String.valueOf((Object)TuiColor.YELLOW) + message + String.valueOf((Object)TuiColor.RESET));
            }
            System.out.print("> ");
        }
    }

    @Override
    public void showWaitOtherPlayers() {
        this.showGenericMessage("Attendi gli altri giocatori per avanzare alla prossima fase", false);
    }

    @Override
    public void chooseComponent(Ship myShip, ActivatableComponent component) {
        ShipPrintUtils.printShip(myShip);
        System.out.println("You can activate your " + component.name());
        int totalBatteries = myShip.getnBatterieLeft();
        boolean stop = false;
        ArrayList<Position> activatedComponentPositions = new ArrayList<Position>();
        ArrayList<Position> usedBatteryPositions = new ArrayList<Position>();
        while (!stop && totalBatteries > 0) {
            System.out.print("Activate " + component.name() + " specify the coordinates or type no to stop");
            System.out.println();
            this.enableInput();
            String input = this.readLine(" input (x,y) or no: ").trim().toLowerCase();
            this.disableInput();
            if (this.checkReset(input).booleanValue()) {
                return;
            }
            if (input.equals("n") || input.equals("no")) {
                stop = true;
                continue;
            }
            Position compPos = InputUtils.parseCoordinate(input);
            compPos.setPos(compPos.getX() - 4, compPos.getY() - 5);
            if (!Util.inBoundaries(compPos.getX(), compPos.getY()).booleanValue() || myShip.getInvalidPositions().contains(compPos)) {
                System.out.println("Wrong Coordinates, out of bounds ");
                continue;
            }
            if (!myShip.getComponentPositionsFromName(component.name()).contains(compPos)) {
                System.out.println("Wrong Coordinates, another kind of component at that coordinates ");
                continue;
            }
            if (activatedComponentPositions.contains(compPos)) {
                System.out.println("Wrong Coordinates, already activated ");
                continue;
            }
            System.out.print("Specify the coordinates of the battery to use");
            this.enableInput();
            input = this.readLine(" input (x,y): ").trim().toLowerCase();
            this.disableInput();
            Position battPos = InputUtils.parseCoordinate(input);
            battPos.setPos(battPos.getX() - 4, battPos.getY() - 5);
            if (!Util.inBoundaries(battPos.getX(), battPos.getY()).booleanValue() || myShip.getInvalidPositions().contains(battPos)) {
                System.out.println("Wrong Coordinates, out of bounds ");
                continue;
            }
            if (!myShip.getComponentPositionsFromName("batterySlot").contains(battPos)) {
                System.out.println("Wrong Coordinates, another kind of component at that coordinates ");
                continue;
            }
            int batteriesInSlot = ((BatterySlot)myShip.getComponentFromPosition(battPos)).getBatteriesLeft();
            Position finalBattPos = battPos;
            int timesSlotUsed = (int)usedBatteryPositions.stream().filter(p -> p.equals(finalBattPos)).count();
            if (batteriesInSlot <= timesSlotUsed) {
                System.out.println("Batteries already depleted ad those coordinates ");
                continue;
            }
            activatedComponentPositions.add(compPos);
            usedBatteryPositions.add(battPos);
            --totalBatteries;
        }
        if (totalBatteries == 0) {
            System.out.println("Batterie terminate");
        }
        this.clientController.handleActivateComponentResponse(component, activatedComponentPositions, usedBatteryPositions);
    }

    @Override
    public void chooseDiscardCrew(Ship myShip, int nCrewToDiscard) {
        ComponentNameVisitor componentNameVisitor = new ComponentNameVisitor();
        ShipPrintUtils.printShip(myShip);
        ArrayList<Position> housingPositions = new ArrayList<Position>();
        System.out.println("You have to discard " + nCrewToDiscard + " crew:");
        while (nCrewToDiscard > 0) {
            System.out.print("specify the coordinates of a Cabin");
            try {
                this.enableInput();
                String input = this.readLine(" input (x,y): ").trim().toLowerCase();
                this.disableInput();
                if (this.checkReset(input).booleanValue()) {
                    return;
                }
                Position housingPos = InputUtils.parseCoordinate(input);
                housingPos.setPos(housingPos.getX() - 4, housingPos.getY() - 5);
                System.out.println(housingPos.getX() + " " + housingPos.getY());
                if (!Util.inBoundaries(housingPos.getX(), housingPos.getY()).booleanValue() || myShip.getInvalidPositions().contains(housingPos)) {
                    System.out.println("Wrong Coordinates, out of bounds ");
                    continue;
                }
                if (!myShip.getComponentPositionsFromName("ModularHousingUnit").contains(housingPos) && !myShip.getComponentPositionsFromName("CentralHousingUnit").contains(housingPos)) {
                    System.out.println("Wrong Coordinates, another kind of component at that coordinates ");
                    continue;
                }
                int nCrewAtPos = switch (myShip.getComponentFromPosition(housingPos).accept(componentNameVisitor)) {
                    case "ModularHousingUnit" -> ((ModularHousingUnit)myShip.getComponentFromPosition(housingPos)).getNCrewMembers();
                    case "CentralHousingUnit" -> ((CentralHousingUnit)myShip.getComponentFromPosition(housingPos)).getNCrewMembers();
                    default -> 0;
                };
                Position finalHousingPos = housingPos;
                int timesSlotUsed = (int)housingPositions.stream().filter(p -> p.equals(finalHousingPos)).count();
                if (nCrewAtPos <= timesSlotUsed) {
                    System.out.println("Crew already selected at those coordinates ");
                    continue;
                }
                housingPositions.add(housingPos);
                System.out.println("Accepted, you have " + --nCrewToDiscard + " crew members to discard left");
            }
            catch (IllegalArgumentException e) {
                this.disableInput();
                System.out.println("invalid input, out of bounds ");
            }
        }
        this.clientController.handleDiscardCrewMembersResponse(housingPositions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void chooseTroncone(ArrayList<Ship> tronconi) {
        System.out.println("The ship divided into pieces choose one to continue ");
        for (int i = 0; i < tronconi.size(); ++i) {
            out.println();
            System.out.println("Ship Fragment " + (i + 1) + ": ");
            ShipPrintUtils.printShip(tronconi.get(i));
        }
        int choice = -1;
        this.enableInput();
        try {
            while (choice < 0 || choice >= tronconi.size()) {
                String input;
                block9: {
                    System.out.println("Choose a Fragment as your ship (1-" + tronconi.size() + "): ");
                    input = this.readLine(" > ").trim().toLowerCase();
                    if (!this.checkReset(input).booleanValue()) break block9;
                    return;
                }
                try {
                    int inputNum = Integer.parseInt(input);
                    choice = inputNum - 1;
                }
                catch (Exception e) {
                    System.out.println("Invalid choice entered, please try again");
                    choice = -1;
                }
                if (choice >= 0 && choice < tronconi.size()) continue;
                System.out.println("Invalid choice entered, choose a number equivalent to a ship fragment.");
            }
        }
        finally {
            this.disableInput();
        }
        this.clientController.handleTrunkResponse(choice - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void chooseCrew(Ship myShip) {
        ArrayList<Position> housinPos = myShip.getComponentPositionsFromName("ModularHousingUnit");
        int nBrownAliens = 0;
        int nPurpleAliens = 0;
        CrewInitUpdate crewInitUpdate = new CrewInitUpdate();
        System.out.println("You have " + housinPos.size() + " Cabins to fill");
        if (!housinPos.isEmpty()) {
            this.enableInput();
            try {
                for (Position pos : housinPos) {
                    Slot tempSlot = myShip.getShipBoard()[pos.getX()][pos.getY()];
                    if (tempSlot == null || tempSlot.getTile() == null) continue;
                    ArrayList<String> choices = new ArrayList<String>();
                    ModularHousingUnit housing = (ModularHousingUnit)tempSlot.getTile().getMyComponent();
                    if (Util.checkNearLFS(pos, AlienColor.PURPLE, myShip).booleanValue() || Util.checkNearLFS(pos, AlienColor.BROWN, myShip).booleanValue()) {
                        if (Util.checkNearLFS(pos, AlienColor.PURPLE, myShip).booleanValue() && nPurpleAliens == 0) {
                            CabinUnitAscii.printCabinUnitWithFigures(1, true, AlienColor.PURPLE);
                            choices.add("purple");
                        }
                        if (Util.checkNearLFS(pos, AlienColor.BROWN, myShip).booleanValue() && nBrownAliens == 0) {
                            CabinUnitAscii.printCabinUnitWithFigures(1, true, AlienColor.BROWN);
                            choices.add("brown");
                        }
                    }
                    CabinUnitAscii.printCabinUnitWithFigures(2, false, AlienColor.EMPTY);
                    choices.add("human");
                    boolean correct = false;
                    block15: while (!correct) {
                        String choice;
                        StringBuilder prompt = new StringBuilder("Type ");
                        for (String choice2 : choices) {
                            prompt.append("(").append(choice2).append(") ");
                        }
                        switch (choice = this.readLine(prompt.toString()).toLowerCase()) {
                            case "purple": {
                                ++nPurpleAliens;
                                correct = true;
                                crewInitUpdate.addCrewPos(new Pair<Position, AlienColor>(pos, AlienColor.PURPLE));
                                continue block15;
                            }
                            case "brown": {
                                ++nBrownAliens;
                                correct = true;
                                crewInitUpdate.addCrewPos(new Pair<Position, AlienColor>(pos, AlienColor.BROWN));
                                continue block15;
                            }
                            case "human": {
                                correct = true;
                                crewInitUpdate.addCrewPos(new Pair<Position, AlienColor>(pos, AlienColor.EMPTY));
                                crewInitUpdate.addCrewPos(new Pair<Position, AlienColor>(pos, AlienColor.EMPTY));
                                continue block15;
                            }
                        }
                        System.out.println("Invalid choice: " + choice);
                    }
                }
            }
            finally {
                this.showGenericMessage("Finito di caricare crew, waiting alters ", false);
                this.disableInput();
            }
        }
        this.notifyObservers(crewInitUpdate);
    }

    @Override
    public void askActivateAdventureCard() {
        this.enableInput();
        this.askYesNoConfirmation("Congratulazioni, soddisfi i requisiti. Vuoi attivare l'effetto della carta?", () -> this.clientController.sendActivateAdventureCardResponse(true), () -> {
            this.clientController.sendActivateAdventureCardResponse(false);
            this.showGenericMessage("Hai scelto di non attivare l'effetto.", false);
        });
        this.disableInput();
    }

    @Override
    public void askDrawCard() {
        this.enableInput();
        this.askYesConfirmation("Sei il leader. Inserire un 'y' per pescare la carta avventura: ", this.clientController::sendDrawAdventureCardRequest);
        this.disableInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void askSelectPlanetChoice(HashMap<Integer, Planet> landablePlanets) {
        int size = landablePlanets.size();
        boolean validInput = false;
        this.enableInput();
        try {
            do {
                int choice;
                out.println();
                out.println("List Planet choices: ");
                CardPrintUtils.printPlanetList(landablePlanets);
                String input = this.readLine("Scegli un pianeta, oppure '0' per non scegliere: ").trim();
                if (this.checkReset(input).booleanValue()) {
                    return;
                }
                try {
                    choice = Integer.parseInt(input);
                }
                catch (NumberFormatException e) {
                    choice = -1;
                }
                if (!landablePlanets.containsKey(choice) && choice != 0) {
                    System.out.println("Input non valido.");
                    continue;
                }
                if (choice == 0) {
                    this.clientController.sendSelectPlanetResponse(null, -1);
                    this.showGenericMessage("Hai scelto di non scegliere un pianeta. Devi aspettare la scelta degli altri giocatori.", false);
                } else {
                    Planet selected = landablePlanets.get(choice);
                    this.clientController.sendSelectPlanetResponse(selected, choice);
                }
                validInput = true;
            } while (!validInput);
        }
        finally {
            this.disableInput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void askLoadGoodChoice() {
        String input = null;
        boolean valid = false;
        this.enableInput();
        do {
            try {
                input = this.readLine("Cosa vuoi fare? [L]Load, [D]Discard, [F]Finish: ").trim().toLowerCase();
                if (this.checkReset(input).booleanValue()) {
                    this.disableInput();
                    return;
                }
            }
            catch (Exception e) {
                out.println("Errore nella lettura dell'input: " + e.getMessage());
                continue;
            }
            catch (Throwable throwable) {
                this.disableInput();
                throw throwable;
            }
            {
                if (input.toLowerCase().matches("[ldf]")) {
                    valid = true;
                    continue;
                }
                out.println("Input non valido. Inserisci L, D o F.");
            }
        } while (!valid);
        this.disableInput();
        this.clientController.handleLoadGoodChoice(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void askSelectGoodToLoad(ArrayList<Good> goods, Ship myShip) {
        ArrayList<Position> availableCargoHolds;
        Good selectedGood;
        int goodIndex;
        block22: {
            if (goods.isEmpty()) {
                out.println(" Nessuna merce disponibile sul pianeta.");
                this.askLoadGoodChoice();
                return;
            }
            this.displayGoods(goods);
            goodIndex = -1;
            this.enableInput();
            try {
                while (goodIndex < 0 || goodIndex >= goods.size()) {
                    String input;
                    block20: {
                        input = this.readLine("Seleziona una merce da caricare (1-" + goods.size() + ", oppure 0 per saltare il caricamento merci): ");
                        if (this.checkReset(input).booleanValue()) {
                            this.disableInput();
                            return;
                        }
                        if (!input.equals("0")) break block20;
                        this.showGenericMessage("Hai scelto di non caricare nessuna merce. ", false);
                        this.disableInput();
                        this.askLoadGoodChoice();
                        this.disableInput();
                        return;
                    }
                    try {
                        goodIndex = Integer.parseInt(input) - 1;
                    }
                    catch (Exception e) {
                        out.println("Input non valido.");
                    }
                }
                this.disableInput();
            }
            catch (Throwable throwable) {
                this.disableInput();
                throw throwable;
            }
            selectedGood = goods.get(goodIndex);
            availableCargoHolds = this.clientController.getAvailableCargoHolds(myShip, selectedGood);
            if (!availableCargoHolds.isEmpty()) break block22;
            out.println(" Nessun cargo hold disponibile sulla nave.");
            this.askLoadGoodChoice();
            return;
        }
        Position selectedPos = null;
        this.enableInput();
        try {
            while (selectedPos == null) {
                String input;
                block21: {
                    input = this.readLine("Inserisci le coordinate della posizione cargo (es. 6,7 oppure 0 per saltare): ");
                    if (this.checkReset(input).booleanValue()) {
                        this.disableInput();
                        return;
                    }
                    if (!input.equals("0")) break block21;
                    out.println("Hai deciso di non caricare la merce.");
                    this.askLoadGoodChoice();
                    this.disableInput();
                    return;
                }
                try {
                    Position pos = InputUtils.parseCoordinate(input);
                    if (availableCargoHolds.contains(pos)) {
                        selectedPos = new Position(pos.getX() - 4, pos.getY() - 5);
                        continue;
                    }
                    out.println("Questa posizione non \u00e8 disponibile.");
                }
                catch (Exception e) {
                    out.println("Formato non valido. Usa es. 6,7");
                }
            }
            this.disableInput();
        }
        catch (Throwable throwable) {
            this.disableInput();
            throw throwable;
        }
        this.clientController.placeMerci(goodIndex, selectedGood, selectedPos);
        out.println("Merce caricata.");
        this.askLoadGoodChoice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void askSelectGoodToDiscard(Ship myShip) {
        Position pos;
        Position selectedPos;
        block22: {
            this.showShip(myShip, this.clientController.getMyModel().getMyInfo().getNickName());
            ArrayList<Position> occupiedPositions = this.clientController.getOccupiedCargoHolds(myShip);
            selectedPos = null;
            pos = null;
            if (occupiedPositions.isEmpty()) {
                out.println("Nessun cargo hold occupato.");
                this.askLoadGoodChoice();
                return;
            }
            this.enableInput();
            while (true) {
                String input;
                block19: {
                    block18: {
                        if (selectedPos != null) break;
                        input = this.readLine("Inserisci le coordinate della posizione cargo (es. 6,7 oppure 0 per saltare): ");
                        if (!this.checkReset(input).booleanValue()) break block18;
                        this.disableInput();
                        return;
                    }
                    if (!input.equals("0")) break block19;
                    out.println("Hai deciso di non discard la merce.");
                    this.askLoadGoodChoice();
                    this.disableInput();
                    return;
                }
                pos = InputUtils.parseCoordinate(input);
                if (occupiedPositions.contains(pos)) {
                    selectedPos = new Position(pos.getX() - 4, pos.getY() - 5);
                    continue;
                }
                out.println("Questa posizione non \u00e8 disponibile.");
                {
                    catch (Exception e) {
                        out.println("Formato non valido. Usa es. 6,7");
                    }
                }
                continue;
                break;
            }
            break block22;
            catch (Throwable throwable) {
                this.disableInput();
                throw throwable;
            }
        }
        this.disableInput();
        ArrayList<Good> goods = this.clientController.getDiscardPositionGoods(selectedPos);
        out.println(" Merci disponibili:");
        this.displayGoods(goods);
        int goodIndex = -1;
        this.enableInput();
        try {
            while (goodIndex < 0 || goodIndex >= goods.size()) {
                String input;
                block20: {
                    input = this.readLine("Seleziona una merce da caricare (1-" + goods.size() + "): ");
                    if (!this.checkReset(input).booleanValue()) break block20;
                    return;
                }
                try {
                    goodIndex = Integer.parseInt(input) - 1;
                }
                catch (Exception e) {
                    out.println("Input non valido.");
                }
            }
        }
        finally {
            this.disableInput();
        }
        this.clientController.discardGood(goodIndex, pos);
        out.println("Merce scartata.");
        this.askLoadGoodChoice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showFlightMenu() {
        boolean valid = false;
        this.enableInput();
        try {
            do {
                String input = this.readLine("Inserisci la tua scelta (a/b/c/d o menu) : ").trim().toLowerCase();
                while (input.equals("m") || input.equals("menu") || input.equals("?")) {
                    this.menuManager.showCurrentMenu();
                    input = this.readLine("\nInserisci la tua scelta (a/b/c/d o menu) : ").trim().toLowerCase();
                }
                if (input.matches("[abcd]")) {
                    try {
                        this.clientController.handleFlightMenuChoice(input);
                        valid = true;
                    }
                    catch (Exception e) {
                        System.err.println("Errore durante la gestione della scelta: " + e.getMessage());
                    }
                    continue;
                }
                if (input.equals("reset")) {
                    System.out.println();
                    valid = true;
                    continue;
                }
                System.out.println("Input non valido");
            } while (!valid);
        }
        finally {
            this.disableInput();
        }
    }

    @Override
    public void showFlightBoard(FlightBoard flightBoard, ArrayList<PlayerInfo> infoPlayers, PlayerInfo myinfo) {
        FlightBoardPrintUtils.printFlightBoard(flightBoard, infoPlayers, myinfo);
    }

    @Override
    public void askCollectRewards() {
        this.enableInput();
        this.askYesNoConfirmation("Hai sconfitto con successo il nemico. Scegli se accettare la ricompensa.", () -> this.clientController.sendCollectRewardsResponse(true), () -> {
            this.clientController.sendCollectRewardsResponse(false);
            this.showGenericMessage("Hai scelto di non accettare la ricompensa.", false);
        });
        this.disableInput();
    }

    @Override
    public void showTimerInfos(ArrayList<TimerInfo> timerInfos, PLAYER_PHASE phase) {
        if (this.clientController.isRecentTimerAsked()) {
            new Thread(() -> {
                this.printTimerInfo(timerInfos);
                this.showTimerMenu(timerInfos);
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showTimerMenu(ArrayList<TimerInfo> timerInfos) {
        boolean valid = false;
        this.enableInput();
        this.clientController.setRecentTimerAsked(false);
        try {
            do {
                boolean now = false;
                String input = !this.clientController.canFlipHourglass() ? this.readLine("Inserisci la tua scelta (menu) : ").trim().toLowerCase() : this.readLine("Inserisci la tua scelta  \n a) Flip Timer \n m) (menu/m/?)\n > ").trim().toLowerCase();
                if (input.equals("m") || input.equals("menu") || input.equals("?")) {
                    this.menuManager.showCurrentMenu();
                    this.handleChoiceForPhase(this.clientController.getPhase());
                }
                if (input.equals("a") && this.clientController.canFlipHourglass()) {
                    valid = true;
                    this.clientController.sendFlipRequest();
                    out.println("Timer flipped!");
                    this.menuManager.showCurrentMenu();
                    this.handleChoiceForPhase(this.clientController.getPhase());
                    continue;
                }
                if (input.equals("reset")) {
                    System.out.println();
                    continue;
                }
                System.out.println("Input non valido");
            } while (!valid);
        }
        finally {
            this.disableInput();
        }
    }

    private void printTimerInfo(ArrayList<TimerInfo> timerInfos) {
        TimerPrinter.printTimers(timerInfos);
    }

    public void displayGoods(List<Good> goods) {
        out.println("Merci disponibili:");
        for (int i = 0; i < goods.size(); ++i) {
            out.println("[" + (i + 1) + "] " + CardPrintUtils.colorBlock(goods.get(i)));
        }
        out.println("[0] Salta");
    }

    @Override
    public void showCurrentAdventureCard() {
        out.println("Carta avventura attiva: ");
        CardPrintUtils.printCard(this.clientController.getCurrentAdventureCard());
    }

    @Override
    public void showEndGame(ArrayList<PlayerScore> scores) {
        ScorePrintUtils.printScoreTable(scores);
    }

    @Override
    public void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    @Override
    public void notifyObservers(NetworkMessage message) {
        for (Observer observer : this.observers) {
            observer.update(message);
        }
    }

    @Override
    public void showYouAreNowSpectating() {
    }

    @Override
    public void autoShowShipInTui(Ship shipView, String Nickname) {
        System.out.println();
        System.out.println("Ship di " + Nickname);
        System.out.println();
        ShipPrintUtils.printShip(shipView);
    }

    private Boolean checkReset(String input) {
        return input.equalsIgnoreCase("reset");
    }

    private void askYesConfirmation(String prompt, Runnable onYesAction) {
        boolean validInput = false;
        do {
            String input;
            if ((input = this.readLine(prompt).trim().toLowerCase()).equalsIgnoreCase("y")) {
                onYesAction.run();
                validInput = true;
                continue;
            }
            if (input.equalsIgnoreCase("reset")) {
                return;
            }
            System.out.println("Input non valido. Inserisci solo 'y' per confermare.");
        } while (!validInput);
    }

    private void askYesNoConfirmation(String prompt, Runnable onYes, Runnable onNo) {
        boolean validInput = false;
        do {
            String input;
            switch (input = this.readLine(prompt).trim().toLowerCase()) {
                case "y": 
                case "yes": {
                    onYes.run();
                    validInput = true;
                    break;
                }
                case "n": 
                case "no": {
                    onNo.run();
                    validInput = true;
                    break;
                }
                case "reset": {
                    return;
                }
                default: {
                    System.out.println("Input non valido. Inserisci 'y' per s\u00ec o 'n' per no.");
                }
            }
        } while (!validInput);
    }

    static {
        outputLock = new Object();
    }
}

