/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Gui;

import java.io.BufferedInputStream;
import java.io.InputStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;

public class MusicManager {
    private static MusicManager instance;
    private Clip backgroundClip;

    protected MusicManager() {
    }

    public void playBackgroundMusic(String fileName, boolean loop) {
        if (this.backgroundClip != null && this.backgroundClip.isRunning()) {
            return;
        }
        try {
            InputStream raw = this.getClass().getResourceAsStream("/it/polimi/ingsw/galaxytrucker/Sounds/Music/" + fileName);
            BufferedInputStream bufferedIn = new BufferedInputStream(raw);
            AudioInputStream audioStream = AudioSystem.getAudioInputStream(bufferedIn);
            this.backgroundClip = AudioSystem.getClip();
            this.backgroundClip.open(audioStream);
            if (loop) {
                this.backgroundClip.loop(-1);
            } else {
                this.backgroundClip.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopBackgroundMusic() {
        if (this.backgroundClip != null && this.backgroundClip.isRunning()) {
            this.backgroundClip.stop();
        }
    }

    public boolean isPlaying() {
        return this.backgroundClip != null && this.backgroundClip.isRunning();
    }
}

