/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Gui;

import it.polimi.ingsw.galaxytrucker.controller.ClientController;
import it.polimi.ingsw.galaxytrucker.enums.ActivatableComponent;
import it.polimi.ingsw.galaxytrucker.model.Planet;
import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.model.essentials.Good;
import it.polimi.ingsw.galaxytrucker.model.essentials.Position;
import it.polimi.ingsw.galaxytrucker.network.client.ClientModel;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.DrawAdventureCardRequest;
import it.polimi.ingsw.galaxytrucker.view.Gui.Abstract.GenericGamePhaseSceneController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Elements.FlightBoardController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Elements.SMactivateCardController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Elements.SMactivateComponentController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Elements.SMavanzaTurnoController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Elements.SMdiscardCrewController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Elements.SMloadGoodsController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Elements.SMplanetChoiceController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Elements.SMtronconiController;
import it.polimi.ingsw.galaxytrucker.view.Gui.Elements.SingleShipController;
import it.polimi.ingsw.galaxytrucker.view.Gui.GuiJavaFx;
import it.polimi.ingsw.galaxytrucker.view.Gui.MusicManager;
import it.polimi.ingsw.galaxytrucker.view.Gui.zUtils;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.FlightBoardPrintUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class FlightController
extends GenericGamePhaseSceneController {
    private GuiJavaFx mainViewController;
    private ClientController clientController;
    private ClientModel mymodel;
    private Stage primaryStage;
    private MusicManager musicManager;
    private SingleShipController shipController;
    private FlightBoardController flightBoardController;
    private Good inHandGood;
    @FXML
    private ImageView cardView;
    @FXML
    private HBox imageBox;
    @FXML
    private HBox subMenu;
    @FXML
    private StackPane shipZone;
    @FXML
    private StackPane boardZone;
    @FXML
    private ImageView avatar1;
    @FXML
    private ImageView avatar2;
    @FXML
    private ImageView avatar3;
    @FXML
    private ImageView avatar4;
    @FXML
    private Label name1;
    @FXML
    private Label name2;
    @FXML
    private Label name3;
    @FXML
    private Label name4;
    @FXML
    private RadioButton radio1;
    @FXML
    private RadioButton radio2;
    @FXML
    private RadioButton radio3;
    @FXML
    private RadioButton radio4;
    @FXML
    private StackPane mainStackPane;
    @FXML
    private StackPane StackCenterMenu;
    @FXML
    private ImageView handImage;
    @FXML
    private VBox logContainer;
    @FXML
    private ScrollPane logScroll;
    private Boolean isDiscardingCrewTime = false;
    private Boolean isManagingGoodsTime = false;
    private Boolean battInHand = false;
    private Position inHandBatteryPosition;
    private Boolean readyForNextTurn = false;
    private Boolean leaderHasToDraw = false;
    SMdiscardCrewController discardCrewController;
    SMactivateComponentController activateComponentController;

    @Override
    public void initialSetup(GuiJavaFx mainViewController, ClientController clientController, ClientModel mymodel, Stage primaryStage, MusicManager musicManager) {
        this.mainViewController = mainViewController;
        this.clientController = clientController;
        this.mymodel = mymodel;
        this.primaryStage = primaryStage;
        this.musicManager = musicManager;
        List<RadioButton> radioButtons = List.of(this.radio1, this.radio2, this.radio3, this.radio4);
        List<Label> names = List.of(this.name1, this.name2, this.name3, this.name4);
        List<ImageView> avatars = List.of(this.avatar1, this.avatar2, this.avatar3, this.avatar4);
        block8: for (int i = 0; i < mymodel.getPlayerInfos().size(); ++i) {
            names.get(i).setText(mymodel.getPlayerInfos().get(i).getNickName());
            radioButtons.get(i).visibleProperty().set(true);
            if (mymodel.getPlayerInfos().get(i).getNickName().equals(mymodel.getMyInfo().getNickName())) {
                radioButtons.get(i).selectedProperty().set(true);
                names.get(i).setStyle("-fx-text-fill: Yellow;");
            }
            switch (mymodel.getPlayerInfos().get(i).getColor()) {
                case RED: {
                    avatars.get(i).setImage(new Image(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/AvatarRosso.png").toExternalForm()));
                    continue block8;
                }
                case YELLOW: {
                    avatars.get(i).setImage(new Image(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/AvatarGiallo.png").toExternalForm()));
                    continue block8;
                }
                case BLUE: {
                    avatars.get(i).setImage(new Image(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/AvatarBlu.png").toExternalForm()));
                    continue block8;
                }
                case GREEN: {
                    avatars.get(i).setImage(new Image(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/AvatarVerde.png").toExternalForm()));
                }
            }
        }
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/SingleShip.fxml"));
        Parent shipNode = null;
        try {
            shipNode = (Parent)loader.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.shipController = (SingleShipController)loader.getController();
        this.shipController.initialize(mymodel.getMyInfo().getNickName(), this.shipZone);
        this.shipZone.getChildren().add(shipNode);
        this.showShip(mymodel.getMyInfo().getShip(), mymodel.getMyInfo().getNickName());
        this.cardView.fitWidthProperty().bind(this.imageBox.widthProperty().divide(1.5));
        this.cardView.fitHeightProperty().bind(this.imageBox.widthProperty().divide(1.3));
        this.flightBoardController = new FlightBoardController();
        this.flightBoardController.initialize(this.boardZone, clientController.getMyModel().getFlightBoard());
        FlightBoardPrintUtils.printFlightBoard(mymodel.getFlightBoard(), mymodel.getPlayerInfos(), mymodel.getMyInfo());
        this.showEndTurnMenu();
        this.mainStackPane.setOnMouseMoved(event -> {
            this.handImage.setLayoutX(event.getX() - this.handImage.getFitWidth() / 2.0);
            this.handImage.setLayoutY(event.getY() - this.handImage.getFitHeight() / 2.0);
        });
        this.ShowGenericMessage("In una galassia lontana i nostri eroi si stanno preparando ad iniziare la loro avventura, sono quasi pronti al decollo.");
    }

    public void showEndTurnMenu() {
        Platform.runLater(() -> {
            this.readyForNextTurn = false;
            if (this.subMenu.getChildren().size() > 0) {
                this.subMenu.getChildren().removeLast();
            }
            try {
                FXMLLoader secondloader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/SMavanzaTurno.fxml"));
                VBox root = (VBox)secondloader.load();
                SMavanzaTurnoController pageController = (SMavanzaTurnoController)secondloader.getController();
                pageController.initialize(this.clientController, this.subMenu, this);
                root.setMaxWidth(Double.MAX_VALUE);
                root.setMaxHeight(Double.MAX_VALUE);
                HBox.setHgrow(root, Priority.ALWAYS);
                this.subMenu.getChildren().add(root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void setReadyForNextTurn() {
        this.readyForNextTurn = true;
        if (this.leaderHasToDraw.booleanValue()) {
            this.askDrawCard();
        }
    }

    public void showPickedGood() {
        String pathMerce = null;
        switch (this.inHandGood.getColor()) {
            case YELLOW: {
                pathMerce = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/merceGialla.png";
                break;
            }
            case RED: {
                pathMerce = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/merceRossa.png";
                break;
            }
            case GREEN: {
                pathMerce = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/merceVerde.png";
                break;
            }
            case BLUE: {
                pathMerce = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/merceBlu.png";
            }
        }
        Image img = new Image(zUtils.class.getResource(pathMerce).toExternalForm());
        this.handImage.setImage(img);
        this.handImage.setVisible(true);
        this.handImage.setFitHeight(80.0);
        this.handImage.setFitWidth(80.0);
    }

    public void showBattery(Position position) {
        this.battInHand = true;
        this.inHandBatteryPosition = position;
        String path = "/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/pedineSegnalini/batteryCharge.png";
        Image img = new Image(zUtils.class.getResource(path).toExternalForm());
        this.handImage.setImage(img);
        this.handImage.setVisible(true);
        this.handImage.setFitHeight(80.0);
        this.handImage.setFitWidth(80.0);
    }

    public Boolean getInHandBattery() {
        return this.battInHand;
    }

    public void useInHandBattery() {
        this.battInHand = false;
        this.hideHand();
        this.activateComponentController.addBatteryPosition(this.inHandBatteryPosition);
    }

    public void resetInHandBattery() {
        this.battInHand = false;
        this.hideHand();
    }

    public void hideHand() {
        this.handImage.visibleProperty().set(false);
    }

    public Good getCurrentInHandGood() {
        return this.inHandGood;
    }

    public void setCurrentInHandGood(Good inHandGood) {
        this.inHandGood = inHandGood;
    }

    public void handleGoodsLoading(ArrayList<Good> goods) {
        this.isManagingGoodsTime = true;
        Platform.runLater(() -> {
            if (this.subMenu.getChildren().size() > 0) {
                this.subMenu.getChildren().removeLast();
            }
            try {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/SMloadGoods.fxml"));
                VBox root = (VBox)loader.load();
                SMloadGoodsController pageController = (SMloadGoodsController)loader.getController();
                pageController.initialize(this.clientController, this, goods, this.subMenu);
                root.setMaxWidth(Double.MAX_VALUE);
                root.setMaxHeight(Double.MAX_VALUE);
                HBox.setHgrow(root, Priority.ALWAYS);
                this.subMenu.getChildren().add(root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public Boolean getIsManagingGoodTime() {
        return this.isManagingGoodsTime;
    }

    public void endManagingGoodTime() {
        this.isManagingGoodsTime = false;
    }

    public void handleAskActivateCard() {
        Platform.runLater(() -> {
            if (this.subMenu.getChildren().size() > 0) {
                this.subMenu.getChildren().removeLast();
            }
            try {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/SMactivateCard.fxml"));
                VBox root = (VBox)loader.load();
                SMactivateCardController pageController = (SMactivateCardController)loader.getController();
                pageController.initialize(this.clientController, this.subMenu);
                root.setMaxWidth(Double.MAX_VALUE);
                root.setMaxHeight(Double.MAX_VALUE);
                HBox.setHgrow(root, Priority.ALWAYS);
                this.subMenu.getChildren().add(root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void handleDiscradCrew(int total) {
        this.isDiscardingCrewTime = true;
        Platform.runLater(() -> {
            if (this.subMenu.getChildren().size() > 0) {
                this.subMenu.getChildren().removeLast();
            }
            try {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/SMdiscardCrew.fxml"));
                VBox root = (VBox)loader.load();
                this.discardCrewController = (SMdiscardCrewController)loader.getController();
                this.discardCrewController.initialize(this.clientController, this, this.subMenu, total);
                root.setMaxWidth(Double.MAX_VALUE);
                root.setMaxHeight(Double.MAX_VALUE);
                HBox.setHgrow(root, Priority.ALWAYS);
                this.subMenu.getChildren().add(root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void addHousingPosition(Position position) {
        this.discardCrewController.add(position);
    }

    public void endDiscardCrew() {
        this.isDiscardingCrewTime = false;
    }

    public Boolean getIsDiscardingCrewTime() {
        return this.isDiscardingCrewTime;
    }

    public void handleChooseComponent(ActivatableComponent component) {
        System.out.println("Debug: handleChooseComponent");
        Platform.runLater(() -> {
            if (this.subMenu.getChildren().size() > 0) {
                this.subMenu.getChildren().removeLast();
            }
            try {
                FXMLLoader secondloader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/SMactivateComponent.fxml"));
                VBox root = (VBox)secondloader.load();
                this.activateComponentController = (SMactivateComponentController)secondloader.getController();
                this.activateComponentController.initialize(component, this.subMenu, this.clientController, this);
                root.setMaxWidth(Double.MAX_VALUE);
                root.setMaxHeight(Double.MAX_VALUE);
                HBox.setHgrow(root, Priority.ALWAYS);
                this.subMenu.getChildren().add(root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Debug: stampo con component attivabile");
            zUtils.showShipInGrid(this.clientController.getMyModel().getMyInfo().getShip(), this.shipController.getShipGrid(), this.clientController, true, true, this, component);
        });
    }

    public void addActivatedPosition(Position position) {
        this.activateComponentController.addComponentPosition(position);
    }

    @Override
    public void ShowGenericMessage(String message) {
        Label logEntry = new Label("Narratore: " + message);
        logEntry.setStyle("-fx-text-fill: white;");
        logEntry.setWrapText(true);
        logEntry.setMaxWidth(Double.MAX_VALUE);
        logEntry.setMaxHeight(Double.MAX_VALUE);
        this.logContainer.getChildren().add(logEntry);
        this.logScroll.setVvalue(1.0);
    }

    public void askDrawCard() {
        this.leaderHasToDraw = true;
        if (this.readyForNextTurn.booleanValue()) {
            this.cardView.setImage(new Image(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/cards/deck.png").toExternalForm()));
            this.cardView.setOnMouseClicked(event -> {
                DrawAdventureCardRequest request = new DrawAdventureCardRequest();
                this.clientController.safeSendMessage(request);
            });
            this.leaderHasToDraw = false;
            this.readyForNextTurn = false;
        }
    }

    public void updateBoard() {
        System.out.println("Flight controller: UpdateBoard");
        this.flightBoardController.updateBoard(this.clientController.getMyModel().getFlightBoard());
    }

    public void showCurrentAdventureCard() {
        int id = this.mymodel.getCurrentAdventureCard().getID();
        this.cardView.setImage(new Image(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/galaxy_trucker_imgs/cards/GT-cards_" + id + ".jpg").toExternalForm()));
    }

    public void handlePlanetChoice(HashMap<Integer, Planet> landablePlanets) {
        Platform.runLater(() -> {
            if (this.subMenu.getChildren().size() > 0) {
                this.subMenu.getChildren().removeLast();
            }
            try {
                FXMLLoader secondloader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/SMplanetChoice.fxml"));
                VBox root = (VBox)secondloader.load();
                SMplanetChoiceController pageController = (SMplanetChoiceController)secondloader.getController();
                pageController.initialize(this.clientController, this.subMenu, landablePlanets);
                root.setMaxWidth(Double.MAX_VALUE);
                root.setMaxHeight(Double.MAX_VALUE);
                HBox.setHgrow(root, Priority.ALWAYS);
                this.subMenu.getChildren().add(root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void selected0() {
        this.updateShownShip(0);
    }

    public void selected1() {
        this.updateShownShip(1);
    }

    public void selected2() {
        this.updateShownShip(2);
    }

    public void selected3() {
        this.updateShownShip(3);
    }

    public void updateShownShip(int i) {
        if (this.mymodel.getPlayerInfos().size() > i && this.mymodel.getPlayerInfos().get(i) != null) {
            if (this.mymodel.getMyInfo().getNickName().equals(this.mymodel.getPlayerInfos().get(i).getNickName())) {
                this.showShip(this.mymodel.getMyInfo().getShip(), this.mymodel.getMyInfo().getNickName());
            } else {
                this.showShip(this.mymodel.getPlayerInfos().get(i).getShip(), this.mymodel.getPlayerInfos().get(i).getNickName());
            }
        }
    }

    @Override
    public void showShip(Ship ship, String Nickname) {
        Boolean editable = false;
        if (Nickname.equals(this.mymodel.getMyInfo().getNickName())) {
            editable = true;
        }
        List<RadioButton> radioButtons = List.of(this.radio1, this.radio2, this.radio3, this.radio4);
        for (int i = 0; i < this.mymodel.getPlayerInfos().size(); ++i) {
            if (Nickname.equals(this.mymodel.getPlayerInfos().get(i).getNickName())) {
                radioButtons.get(i).selectedProperty().set(true);
                continue;
            }
            radioButtons.get(i).selectedProperty().set(false);
        }
        zUtils.showShipInGrid(ship, this.shipController.getShipGrid(), this.clientController, editable, true, this, null);
    }

    @Override
    public void chooseTroncone(ArrayList<Ship> tronconi) {
        Platform.runLater(() -> {
            try {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/SMtronconi.fxml"));
                ScrollPane root = (ScrollPane)loader.load();
                SMtronconiController pageController = (SMtronconiController)loader.getController();
                pageController.initialize(this.clientController, tronconi, this.StackCenterMenu);
                root.setMaxWidth(Double.MAX_VALUE);
                root.setMaxHeight(Double.MAX_VALUE);
                this.StackCenterMenu.getChildren().add(root);
                this.showShip(this.mymodel.getMyInfo().getShip(), this.mymodel.getMyInfo().getNickName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void showWaitOtherPlayers(Boolean clearLast) {
        this.ShowGenericMessage("Aspetta gli altri giocatori");
    }

    @Override
    public String pageName() {
        return "Flight";
    }
}

