/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.view.Gui.Elements;

import it.polimi.ingsw.galaxytrucker.controller.ClientController;
import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.view.Gui.Elements.SingleShipController;
import it.polimi.ingsw.galaxytrucker.view.Gui.zUtils;
import java.io.IOException;
import java.util.ArrayList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Parent;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class SMtronconiController {
    ClientController clientController;
    StackPane container;
    ToggleGroup shipToggleGroup;
    @FXML
    VBox shipList;

    public void initialize(ClientController clientController, ArrayList<Ship> tronconi, StackPane container) {
        this.container = container;
        this.clientController = clientController;
        this.shipToggleGroup = new ToggleGroup();
        int i = 0;
        for (Ship ship : tronconi) {
            HBox shipBox = new HBox();
            RadioButton radio = new RadioButton();
            radio.setToggleGroup(this.shipToggleGroup);
            radio.setUserData(i);
            shipBox.getChildren().add(radio);
            StackPane shipContainer = new StackPane();
            shipBox.getChildren().add(shipContainer);
            shipBox.setMinHeight(400.0);
            shipBox.setAlignment(Pos.CENTER);
            shipBox.setSpacing(20.0);
            shipContainer.setMinHeight(400.0);
            shipContainer.setAlignment(Pos.CENTER);
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/it/polimi/ingsw/galaxytrucker/GuiPages/Elements/SingleShip.fxml"));
            Parent shipNode = null;
            try {
                shipNode = (Parent)loader.load();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            SingleShipController shipController = (SingleShipController)loader.getController();
            shipContainer.getChildren().add(shipNode);
            this.shipList.getChildren().add(shipBox);
            shipController.initialize(clientController.getMyModel().getMyInfo().getNickName(), shipContainer);
            zUtils.showShipInGrid(ship, shipController.getShipGrid(), clientController, false, true, null, null);
            ++i;
        }
    }

    public void confirmChoice() {
        if (this.shipToggleGroup.getSelectedToggle() != null) {
            this.container.getChildren().removeLast();
            int id = (Integer)this.shipToggleGroup.getSelectedToggle().getUserData();
            this.clientController.handleTrunkResponse(id);
        }
    }
}

